/*
 * Decompiled with CFR 0.152.
 */
package jm.midi;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import jm.JMC;
import jm.midi.MidiUtil;
import jm.midi.SMF;
import jm.midi.Track;
import jm.midi.event.CChange;
import jm.midi.event.EndTrack;
import jm.midi.event.Event;
import jm.midi.event.KeySig;
import jm.midi.event.NoteOn;
import jm.midi.event.PChange;
import jm.midi.event.TempoEvent;
import jm.midi.event.TimeSig;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;

public final class MidiParser
implements JMC {
    private static double tickRemainder = 0.0;

    public static void SMFToScore(Score score, SMF sMF) {
        System.out.println("Convert SMF to JM");
        Enumeration enumeration = sMF.getTrackList().elements();
        while (enumeration.hasMoreElements()) {
            Part part = new Part();
            Track track = (Track)enumeration.nextElement();
            Vector vector = track.getEvtList();
            Vector vector2 = new Vector();
            MidiParser.sortEvents(score, vector, vector2, sMF, part);
            for (int i = 0; i < vector2.size(); ++i) {
                part.addPhrase((Phrase)vector2.elementAt(i));
            }
            score.addPart(part);
            score.clean();
        }
    }

    private static void sortEvents(Score score, Vector vector, Vector vector2, SMF sMF, Part part) {
        double d = 0.0;
        double[] dArray = new double[100];
        Note[] noteArray = new Note[100];
        boolean bl = false;
        double d2 = 0.0;
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            Event event;
            Event event2 = (Event)vector.elementAt(i);
            d += (double)event2.getTime() / (double)sMF.getPPQN();
            if (event2.getID() == 7) {
                event = (PChange)event2;
                part.setInstrument(((PChange)event).getValue());
                continue;
            }
            if (event2.getID() == 16) {
                event = (TempoEvent)event2;
                score.setTempo(((TempoEvent)event).getTempo());
                continue;
            }
            if (event2.getID() != 5) continue;
            event = (NoteOn)event2;
            part.setChannel(((NoteOn)event).getMidiChannel());
            short s = ((NoteOn)event).getPitch();
            short s2 = ((NoteOn)event).getVelocity();
            short s3 = ((NoteOn)event).getMidiChannel();
            if (s2 <= 0) continue;
            MidiParser.noteOn(n, noteArray, sMF, i, dArray, d, vector2, s3, s, s2, vector);
        }
    }

    private static void noteOn(int n, Note[] noteArray, SMF sMF, int n2, double[] dArray, double d, Vector vector, short s, short s2, int n3, Vector vector2) {
        n = -1;
        for (int i = 0; i < vector.size(); ++i) {
            if (!(dArray[i] <= d + 0.08)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            n = vector.size();
            vector.addElement(new Phrase(d));
            dArray[n] = d;
        }
        if (d > dArray[n] && noteArray[n] != null) {
            double d2 = d - dArray[n];
            if (d2 < 0.25) {
                double d3 = noteArray[n].getRhythmValue();
                noteArray[n].setRhythmValue(d3 + d2);
            } else {
                Note note = new Note(Integer.MIN_VALUE, d2, 0);
                note.setPan(s);
                note.setDuration(d2);
                note.setOffset(0.0);
                ((Phrase)vector.elementAt(n)).addNote(note);
            }
            int n4 = n;
            dArray[n4] = dArray[n4] + d2;
        }
        double d4 = MidiUtil.getEndEvt(s2, vector2, n2) / (double)sMF.getPPQN();
        Note note = new Note(s2, d4, n3);
        note.setDuration(d4);
        noteArray[n] = note;
        ((Phrase)vector.elementAt(n)).addNote(noteArray[n]);
        int n5 = n;
        dArray[n5] = dArray[n5] + noteArray[n].getRhythmValue();
    }

    public static void scoreToSMF(Score score, SMF sMF) {
        System.out.println("Converting to SMF data structure...");
        double d = score.getTempo();
        double d2 = 1.0;
        Track track = new Track();
        track.addEvent(new TempoEvent(0, score.getTempo()));
        track.addEvent(new TimeSig(0, score.getNumerator(), score.getDenominator()));
        track.addEvent(new KeySig(0, score.getKeySignature()));
        track.addEvent(new EndTrack());
        sMF.getTrackList().addElement(track);
        int n = 0;
        Enumeration enumeration = score.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            int n2;
            double d3;
            Object[] objectArray;
            Track track2 = new Track();
            Part part = (Part)enumeration.nextElement();
            System.out.print("    Part " + n + " '" + part.getTitle() + "' to SMF Track on Ch. " + part.getChannel() + ": ");
            ++n;
            d2 = part.getTempo() != -1.0 ? d / part.getTempo() : 1.0;
            int n3 = part.getPhraseList().size();
            block1: for (int i = 0; i < n3; ++i) {
                Phrase phrase = (Phrase)part.getPhraseList().elementAt(i);
                for (int j = 0; j < n3; ++j) {
                    Phrase phrase2 = (Phrase)part.getPhraseList().elementAt(j);
                    if (!(phrase2.getStartTime() > phrase.getStartTime())) continue;
                    part.getPhraseList().setElementAt(phrase2, i);
                    part.getPhraseList().setElementAt(phrase, j);
                    continue block1;
                }
            }
            HashMap hashMap = new HashMap();
            if (part.getTempo() != -1.0) {
                MidiParser.putMidiEvent(hashMap, new Double(0.0), new TempoEvent(part.getTempo()));
            }
            if (part.getInstrument() != -1) {
                MidiParser.putMidiEvent(hashMap, new Double(0.0), new PChange((short)part.getInstrument(), (short)part.getChannel(), 0));
            }
            if (part.getNumerator() != Integer.MIN_VALUE) {
                MidiParser.putMidiEvent(hashMap, new Double(0.0), new TimeSig(part.getNumerator(), part.getDenominator()));
            }
            if (part.getKeySignature() != Integer.MIN_VALUE) {
                MidiParser.putMidiEvent(hashMap, new Double(0.0), new KeySig(part.getKeySignature(), part.getKeyQuality()));
            }
            Enumeration enumeration2 = part.getPhraseList().elements();
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            int n4 = 0;
            double d7 = 1.0;
            while (enumeration2.hasMoreElements()) {
                objectArray = (Object[])enumeration2.nextElement();
                Enumeration enumeration3 = objectArray.getNoteList().elements();
                d5 = objectArray.getStartTime() * d2;
                if (objectArray.getInstrument() != -1) {
                    MidiParser.putMidiEvent(hashMap, new Double(d5), new PChange((short)objectArray.getInstrument(), (short)part.getChannel(), 0));
                }
                d7 = objectArray.getTempo() != -1.0 ? d * d2 / objectArray.getTempo() : d2;
                boolean bl = false;
                System.out.print(" Phrase " + n4++ + ":");
                d3 = -1.0;
                MidiParser.resetTicker();
                while (enumeration3.hasMoreElements()) {
                    Note note = (Note)enumeration3.nextElement();
                    d6 = note.getOffset();
                    if (note.getPan() != d3) {
                        d3 = note.getPan();
                        MidiParser.putMidiEvent(hashMap, new Double(d5 + d6), new CChange(10, (short)(d3 * 127.0), (short)part.getChannel(), 0));
                    }
                    n2 = 0;
                    if (note.getPitchType()) {
                        System.err.println("jMusic warning: converting note frequency to the closest MIDI pitch for SMF.");
                        n2 = Note.freqToMidiPitch(note.getFrequency());
                    } else {
                        n2 = note.getPitch();
                    }
                    if (n2 != Integer.MIN_VALUE) {
                        MidiParser.putMidiEvent(hashMap, new Double(d5 + d6), new NoteOn((short)n2, (short)note.getDynamic(), (short)part.getChannel(), 0));
                        double d8 = d5 + note.getDuration() * d7;
                        MidiParser.putMidiEvent(hashMap, new Double(d8 + d6), new NoteOn((short)n2, 0, (short)part.getChannel(), 0));
                    }
                    d5 += MidiParser.tickRounder(note.getRhythmValue() * d7);
                    System.out.print(".");
                }
            }
            objectArray = hashMap.keySet().toArray();
            Arrays.sort(objectArray);
            double d9 = 0.0;
            MidiParser.resetTicker();
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                Event event = (Event)hashMap.get(objectArray[n2]);
                d3 = (Double)objectArray[n2];
                int n5 = (int)((d3 - d9) * (double)sMF.getPPQN() * d2 + 0.5);
                d9 = d3;
                event.setTime(n5);
                track2.addEvent(event);
            }
            track2.addEvent(new EndTrack());
            sMF.getTrackList().addElement(track2);
            System.out.println();
        }
    }

    private static void putMidiEvent(HashMap hashMap, Double d, Event event) {
        while (hashMap.get(d) != null) {
            d = new Double(d + 1.0E-6);
        }
        hashMap.put(d, event);
    }

    private static boolean zeroVelEventQ(Event event) {
        return event.getID() == 5 && ((NoteOn)event).getVelocity() == 0;
    }

    private static void resetTicker() {
        tickRemainder = 0.0;
    }

    private static double tickRounder(double d) {
        int n = (int)(d * 480.0);
        double d2 = (double)n * 0.0020833333333333333;
        if ((tickRemainder += d - d2) > 0.0010416666666666667) {
            d2 += 0.0020833333333333333;
            tickRemainder -= 0.0020833333333333333;
        }
        return d2;
    }
}

