/*
 * Decompiled with CFR 0.152.
 */
package jm.midi.event;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jm.midi.MidiUtil;
import jm.midi.event.Event;
import jm.midi.event.VoiceEvt;

public final class CChange
implements VoiceEvt,
Cloneable {
    private final short id = (short)3;
    private short controllerNum;
    private short value;
    private short midiChannel;
    private int time;

    public CChange() {
        this.controllerNum = 0;
        this.value = 0;
        this.midiChannel = 0;
        this.time = 0;
    }

    public CChange(short s, short s2, short s3, int n) {
        this.controllerNum = s;
        this.value = s2;
        this.midiChannel = s3;
        this.time = n;
    }

    public short getControllerNum() {
        return this.controllerNum;
    }

    public void setControllerNum(short s) {
        this.controllerNum = s;
    }

    public short getValue() {
        return this.value;
    }

    public void setValue(short s) {
        this.value = s;
    }

    public short getMidiChannel() {
        return this.midiChannel;
    }

    public void setMidiChannel(short s) {
        this.midiChannel = s;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int n) {
        this.time = n;
    }

    public short getID() {
        return 3;
    }

    public int write(DataOutputStream dataOutputStream) throws IOException {
        int n = MidiUtil.writeVarLength(this.time, dataOutputStream);
        dataOutputStream.writeByte((byte)(176 + this.midiChannel));
        dataOutputStream.writeByte((byte)this.controllerNum);
        dataOutputStream.writeByte((byte)this.value);
        return n + 3;
    }

    public int read(DataInputStream dataInputStream) throws IOException {
        this.controllerNum = (short)dataInputStream.readUnsignedByte();
        this.value = (short)dataInputStream.readUnsignedByte();
        return 2;
    }

    public Event copy() throws CloneNotSupportedException {
        CChange cChange;
        try {
            cChange = (CChange)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println(cloneNotSupportedException);
            cChange = new CChange();
        }
        return cChange;
    }

    public void print() {
        System.out.println("Contol Change(003):\t\t\t [time = " + this.time + "][midiChannel = " + this.midiChannel + "][contoller_num = " + this.controllerNum + "][value = " + this.value + "]");
    }
}

