/*
 * Decompiled with CFR 0.152.
 */
package jm.midi.event;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jm.midi.MidiUtil;
import jm.midi.event.Event;
import jm.midi.event.TempoEvent;

public final class EndTrack
implements Event {
    private final short id = (short)23;
    private int time = 0;

    public int getTime() {
        return this.time;
    }

    public void setTime(int n) {
        this.time = n;
    }

    public short getID() {
        return this.id;
    }

    public int write(DataOutputStream dataOutputStream) throws IOException {
        int n = MidiUtil.writeVarLength(this.time, dataOutputStream);
        dataOutputStream.writeByte(-1);
        dataOutputStream.writeByte(47);
        dataOutputStream.writeByte(0);
        return n + 2;
    }

    public int read(DataInputStream dataInputStream) throws IOException {
        return 0;
    }

    public Event copy() throws CloneNotSupportedException {
        TempoEvent tempoEvent;
        try {
            tempoEvent = (TempoEvent)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println(cloneNotSupportedException);
            tempoEvent = new TempoEvent();
        }
        return tempoEvent;
    }

    public void print() {
        System.out.println("EndTrack(023):             [time = " + this.time + "]");
    }
}

