/*
 * Decompiled with CFR 0.152.
 */
package jm.midi.event;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jm.midi.MidiUtil;
import jm.midi.event.Event;

public final class KeySig
implements Event {
    private final short id = (short)18;
    private int time;
    private int keySig;
    private int keyQual;

    public KeySig() {
        this.time = 0;
        this.keySig = 0;
        this.keyQual = 0;
    }

    public KeySig(int n, int n2) {
        this.time = 0;
        this.keySig = n;
        this.keyQual = n2;
    }

    public KeySig(int n, int n2, int n3) {
        this.time = n;
        this.keySig = n2;
        this.keyQual = n3;
    }

    public int getKeyQuality() {
        return this.keyQual;
    }

    public void setKeyQuality(int n) {
        this.keyQual = this.keyQual;
    }

    public int getKeySig() {
        return this.keySig;
    }

    public void setKeySig(int n) {
        this.keySig = n;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int n) {
        this.time = n;
    }

    public short getID() {
        return this.id;
    }

    public int write(DataOutputStream dataOutputStream) throws IOException {
        int n = MidiUtil.writeVarLength(this.time, dataOutputStream);
        dataOutputStream.writeByte(255);
        dataOutputStream.writeByte(89);
        dataOutputStream.writeByte((byte)this.keySig);
        dataOutputStream.writeByte((byte)this.keyQual);
        return (n += MidiUtil.writeVarLength(2, dataOutputStream)) + 4;
    }

    public int read(DataInputStream dataInputStream) throws IOException {
        return 0;
    }

    public Event copy() throws CloneNotSupportedException {
        KeySig keySig;
        try {
            keySig = (KeySig)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println(cloneNotSupportedException);
            keySig = new KeySig();
        }
        return keySig;
    }

    public void print() {
        System.out.println("KeySig(022):             [time = " + this.time + "][keySig = " + this.keySig + "][keyQual = " + this.keyQual + "]");
    }
}

