/*
 * Decompiled with CFR 0.152.
 */
package jm.midi.event;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jm.midi.MidiUtil;
import jm.midi.event.Event;

public final class TimeSig
implements Event {
    private final short id = (short)17;
    private int time;
    private int numerator;
    private int denominator;

    public TimeSig() {
        this.time = 0;
        this.numerator = 4;
        this.denominator = 4;
    }

    public TimeSig(int n, int n2) {
        this.time = 0;
        this.denominator = n2;
        this.numerator = n;
    }

    public TimeSig(int n, int n2, int n3) {
        this.time = n;
        this.numerator = n2;
        this.denominator = n3;
    }

    public int getDenominator() {
        return this.denominator;
    }

    public void setDenominator(int n) {
        this.denominator = n;
    }

    public int getNumerator() {
        return this.numerator;
    }

    public void setNumerator(int n) {
        this.numerator = n;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int n) {
        this.time = n;
    }

    public short getID() {
        return this.id;
    }

    public int write(DataOutputStream dataOutputStream) throws IOException {
        int n = MidiUtil.writeVarLength(this.time, dataOutputStream);
        dataOutputStream.writeByte(255);
        dataOutputStream.writeByte(88);
        n += MidiUtil.writeVarLength(4, dataOutputStream);
        dataOutputStream.writeByte((byte)this.numerator);
        int n2 = this.denominator;
        int n3 = 0;
        while (n2 % 2 == 0) {
            n2 /= 2;
            ++n3;
        }
        dataOutputStream.writeByte((byte)n3);
        dataOutputStream.writeByte(24);
        dataOutputStream.writeByte(8);
        return n + 6;
    }

    public int read(DataInputStream dataInputStream) throws IOException {
        return 0;
    }

    public Event copy() throws CloneNotSupportedException {
        TimeSig timeSig;
        try {
            timeSig = (TimeSig)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println(cloneNotSupportedException);
            timeSig = new TimeSig();
        }
        return timeSig;
    }

    public void print() {
        System.out.println("TimeSig(021):             [time = " + this.time + "][numerator = " + this.numerator + "][denominator = " + this.denominator + "]");
    }
}

