/*
 * Decompiled with CFR 0.152.
 */
package jm.music.data;

import java.io.Serializable;

public abstract class Alignment
implements Serializable {
    public static final Alignment START_TOGETHER = new Alignment(){

        public double determineStartTime(double d, double d2, double d3) {
            return d2;
        }
    };
    public static final Alignment END_TOGETHER = new Alignment(){

        public double determineStartTime(double d, double d2, double d3) {
            return d3 - d;
        }
    };
    public static final Alignment AFTER = new Alignment(){

        public double determineStartTime(double d, double d2, double d3) {
            return d3;
        }
    };
    public static final Alignment BEFORE = new Alignment(){

        public double determineStartTime(double d, double d2, double d3) {
            return d2 - d;
        }
    };
    public static final Alignment CENTRE_ALIGN;
    public static final Alignment CENTER_ALIGN;
    public static final Alignment START_ON_CENTRE;
    public static final Alignment START_ON_CENTER;
    public static final Alignment END_ON_CENTRE;
    public static final Alignment END_ON_CENTER;
    public static final Alignment CENTRE_ON_START;
    public static final Alignment CENTER_ON_START;
    public static final Alignment CENTRE_ON_END;
    public static final Alignment CENTER_ON_END;

    protected Alignment() {
    }

    abstract double determineStartTime(double var1, double var3, double var5);

    static {
        CENTER_ALIGN = CENTRE_ALIGN = new Alignment(){

            public double determineStartTime(double d, double d2, double d3) {
                return (d3 + d2 - d) / 2.0;
            }
        };
        START_ON_CENTER = START_ON_CENTRE = new Alignment(){

            public double determineStartTime(double d, double d2, double d3) {
                return (d2 + d3) / 2.0;
            }
        };
        END_ON_CENTER = END_ON_CENTRE = new Alignment(){

            public double determineStartTime(double d, double d2, double d3) {
                return (d2 + d3) / 2.0 - d;
            }
        };
        CENTER_ON_START = CENTRE_ON_START = new Alignment(){

            public double determineStartTime(double d, double d2, double d3) {
                return d2 - d / 2.0;
            }
        };
        CENTER_ON_END = CENTRE_ON_END = new Alignment(){

            public double determineStartTime(double d, double d2, double d3) {
                return d3 - d / 2.0;
            }
        };
    }
}

