/*
 * Decompiled with CFR 0.152.
 */
package jm.music.data;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import jm.JMC;
import jm.music.data.Note;
import jm.music.data.Phrase;

public class CPhrase
implements JMC,
Cloneable,
Serializable {
    private Vector phraseList;
    private double currentTime;
    private double startTime;
    private String title;
    private int instrument = -1;
    private boolean append = false;
    private Phrase linkedPhrase;
    private double pan = 0.5;
    private double tempo = -1.0;
    private int volume = 100;

    public CPhrase() {
        this("Untitled CPhrase", 0.0, -1, true);
    }

    public CPhrase(double d) {
        this("Untitled CPhrase", d, -1, false);
    }

    public CPhrase(String string) {
        this(string, 0.0, -1, true);
    }

    public CPhrase(String string, double d) {
        this(string, d, -1, false);
    }

    public CPhrase(double d, int n) {
        this("Untitled CPhrase", d, n, false);
    }

    public CPhrase(String string, double d, int n) {
        this(string, d, n, false);
    }

    public CPhrase(String string, double d, int n, boolean bl) {
        this.title = string;
        this.startTime = d;
        this.currentTime = d;
        this.instrument = n;
        this.append = bl;
        this.phraseList = new Vector();
    }

    public Vector getPhraseList() {
        return this.phraseList;
    }

    public void setPhraseList(Vector vector) {
        this.phraseList = vector;
    }

    public void addPhrase(Phrase phrase) {
        if (phrase.getAppend()) {
            phrase.setStartTime(this.startTime);
        }
        if (phrase.getStartTime() >= this.startTime) {
            this.phraseList.addElement(phrase);
        } else {
            System.err.println("Phrase to added to CPhrase: Phrases added to a CPhrase must have a start time at ot after the CPhrase start time.");
        }
    }

    public void removePhrase(Phrase phrase) {
        this.phraseList.removeElement(phrase);
    }

    public void addChord(int[] nArray, double d) {
        this.addChord(nArray, d, 70);
    }

    public void addChord(int[] nArray, double d, int n) {
        int n2;
        if (this.phraseList.size() < nArray.length) {
            n2 = nArray.length - this.phraseList.size();
            for (int i = 0; i < n2; ++i) {
                Phrase phrase = new Phrase(this.getEndTime(), this.instrument);
                this.phraseList.addElement(phrase);
            }
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            Note note = new Note(nArray[n2], d, n);
            ((Phrase)this.phraseList.elementAt(n2)).addNote(note);
        }
        while (n2 < this.phraseList.size()) {
            Note note = new Note(Integer.MIN_VALUE, d);
            ((Phrase)this.phraseList.elementAt(n2)).addNote(note);
            ++n2;
        }
    }

    public void addChord(Note[] noteArray) {
        int n;
        this.currentTime = this.getEndTime();
        double d = noteArray[0].getRhythmValue();
        if (this.phraseList.size() < noteArray.length) {
            n = noteArray.length - this.phraseList.size();
            for (int i = 0; i < n; ++i) {
                Phrase phrase = new Phrase(this.getEndTime(), this.instrument);
                this.phraseList.addElement(phrase);
            }
        }
        for (n = 0; n < noteArray.length; ++n) {
            noteArray[n].setRhythmValue(d);
            ((Phrase)this.phraseList.elementAt(n)).addNote(noteArray[n]);
        }
        while (n < this.phraseList.size()) {
            Note note = new Note(Integer.MIN_VALUE, d);
            ((Phrase)this.phraseList.elementAt(n)).addNote(note);
            ++n;
        }
        this.currentTime += d;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public void setStartTime(double d) {
        double d2 = d - this.startTime;
        Enumeration enumeration = this.phraseList.elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            phrase.setStartTime(phrase.getStartTime() + d2);
        }
        this.startTime = d;
        this.append = false;
    }

    public double getEndTime() {
        double d = this.getStartTime();
        Enumeration enumeration = this.phraseList.elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            double d2 = phrase.getEndTime();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public int getInstrument() {
        return this.instrument;
    }

    public void setTitle(int n) {
        if (n < -1) {
            this.instrument = n;
        }
    }

    public boolean getAppend() {
        return this.append;
    }

    public void setAppend(boolean bl) {
        this.append = bl;
    }

    public Phrase getLinkedPhrase() {
        return this.linkedPhrase;
    }

    public void setLinkedPhrase(Phrase phrase) {
        this.linkedPhrase = phrase;
    }

    public double getPan() {
        return this.pan;
    }

    public void setPan(double d) {
        this.pan = d;
        Enumeration enumeration = this.phraseList.elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            phrase.setPan(d);
        }
    }

    public int getHighestPitch() {
        int n = 0;
        Enumeration enumeration = this.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            if (phrase.getHighestPitch() <= n) continue;
            n = phrase.getHighestPitch();
        }
        return n;
    }

    public int getLowestPitch() {
        int n = 127;
        Enumeration enumeration = this.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            if (phrase.getLowestPitch() >= n) continue;
            n = phrase.getLowestPitch();
        }
        return n;
    }

    public double getLongestRhythmValue() {
        double d = 0.0;
        Enumeration enumeration = this.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            if (!(phrase.getLongestRhythmValue() > d)) continue;
            d = phrase.getLongestRhythmValue();
        }
        return d;
    }

    public double getShortestRhythmValue() {
        double d = 1000.0;
        Enumeration enumeration = this.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            if (!(phrase.getShortestRhythmValue() < d)) continue;
            d = phrase.getShortestRhythmValue();
        }
        return d;
    }

    public CPhrase copy() {
        Vector<Phrase> vector = new Vector<Phrase>();
        CPhrase cPhrase = new CPhrase(this.title + " copy", this.startTime, this.instrument);
        Enumeration enumeration = this.phraseList.elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = ((Phrase)enumeration.nextElement()).copy();
            vector.addElement(phrase);
        }
        cPhrase.setPhraseList(vector);
        cPhrase.setAppend(this.append);
        cPhrase.setLinkedPhrase(this.linkedPhrase);
        return cPhrase;
    }

    public CPhrase copy(double d, double d2) {
        Vector<Phrase> vector = new Vector<Phrase>();
        CPhrase cPhrase = new CPhrase(this.title + " copy", d, this.instrument);
        Enumeration enumeration = this.phraseList.elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = ((Phrase)enumeration.nextElement()).copy(d, d2);
            phrase.setStartTime(0.0);
            vector.addElement(phrase);
        }
        cPhrase.setPhraseList(vector);
        cPhrase.setAppend(this.append);
        cPhrase.setLinkedPhrase(this.linkedPhrase);
        return cPhrase;
    }

    public void empty() {
        this.phraseList.removeAllElements();
    }

    public String toString() {
        String string = new String("---- jMusic CPHRASE: '" + this.title + "' Start time: " + this.startTime + " ----" + '\n');
        Enumeration enumeration = this.phraseList.elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            string = string + phrase.toString() + '\n';
        }
        return string;
    }

    public void setDynamic(int n) {
        Enumeration enumeration = this.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            phrase.setDynamic(n);
        }
    }

    public void setPitch(int n) {
        Enumeration enumeration = this.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            phrase.setPitch(n);
        }
    }

    public void setRhythmValue(int n) {
        Enumeration enumeration = this.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            phrase.setRhythmValue(n);
        }
    }

    public void setDuration(double d) {
        Enumeration enumeration = this.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            phrase.setDuration(d);
        }
    }

    public void flam() {
        this.flam(0.05);
    }

    public void flam(double d) {
        int n = 0;
        Enumeration enumeration = this.phraseList.elements();
        while (enumeration.hasMoreElements()) {
            double d2 = d * (double)n;
            Phrase phrase = (Phrase)enumeration.nextElement();
            Enumeration enumeration2 = phrase.getNoteList().elements();
            while (enumeration2.hasMoreElements()) {
                Note note = (Note)enumeration2.nextElement();
                note.setOffset(d2);
            }
            ++n;
        }
    }

    public void setTempo(double d) {
        if (d > 0.0) {
            this.tempo = d;
            Enumeration enumeration = this.phraseList.elements();
            while (enumeration.hasMoreElements()) {
                Phrase phrase = (Phrase)enumeration.nextElement();
                phrase.setTempo(d);
            }
        }
    }

    public double getTempo() {
        return this.tempo;
    }

    public void setVolume(int n) {
        if ((double)n > 0.0) {
            this.volume = n;
            Enumeration enumeration = this.phraseList.elements();
            while (enumeration.hasMoreElements()) {
                Phrase phrase = (Phrase)enumeration.nextElement();
                phrase.setVolume(n);
            }
        }
    }

    public double getVolume() {
        return this.volume;
    }
}

