/*
 * Decompiled with CFR 0.152.
 */
package jm.music.data;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import jm.JMC;
import jm.music.data.CPhrase;
import jm.music.data.Note;
import jm.music.data.Phrase;
import jm.music.data.Score;

public class Part
implements Cloneable,
Serializable,
JMC {
    public static final String DEFAULT_TITLE = "Untitled Part";
    public static final int DEFAULT_INSTRUMENT = 0;
    public static final int DEFAULT_CHANNEL = 0;
    public static final double DEFAULT_TEMPO = -1.0;
    public static final int DEFAULT_VOLUME = 100;
    public static final int DEFAULT_KEY_SIGNATURE = Integer.MIN_VALUE;
    public static final int DEFAULT_KEY_QUALITY = Integer.MIN_VALUE;
    public static final int DEFAULT_NUMERATOR = Integer.MIN_VALUE;
    public static final int DEFAULT_DENOMINATOR = Integer.MIN_VALUE;
    public static final double DEFAULT_PAN = 0.5;
    private Vector phraseList;
    private String title;
    private int channel;
    private int instrument;
    private double tempo;
    private int volume;
    private double[] points = null;
    private long[] time = null;
    private int timeIndex = 0;
    private Score myScore = null;
    private int keySignature;
    private int keyQuality;
    private int numerator;
    private int denominator;
    private double pan = 0.5;

    public Part() {
        this(DEFAULT_TITLE);
    }

    public Part(String string) {
        this(string, 0);
    }

    public Part(int n) {
        this("", n);
    }

    public Part(String string, int n) {
        this(string, n, 0);
    }

    public Part(int n, int n2) {
        this("", n, n2);
    }

    public Part(String string, int n, int n2) {
        this.title = string;
        this.phraseList = new Vector();
        if (this.channel > 16) {
            System.err.println(new Exception("jMusic Warning: A MIDI Channel cannot be greater than 16. There can be any number of Audio channels."));
            new Exception().printStackTrace();
        }
        this.channel = n2;
        if (n < -1) {
            System.err.println(new Exception("jMusic EXCEPTION: instrument value must be greater than 0"));
            new Exception().printStackTrace();
            System.exit(1);
        }
        this.instrument = n;
        this.tempo = -1.0;
        this.volume = 100;
        this.keySignature = Integer.MIN_VALUE;
        this.keyQuality = Integer.MIN_VALUE;
        this.numerator = Integer.MIN_VALUE;
        this.denominator = Integer.MIN_VALUE;
    }

    public Part(Phrase phrase) {
        this();
        phrase.setMyPart(this);
        this.addPhrase(phrase);
    }

    public Part(String string, int n, Phrase phrase) {
        this(string, n, 0, phrase);
    }

    public Part(String string, int n, int n2, Phrase phrase) {
        this(string, n, n2);
        phrase.setMyPart(this);
        this.addPhrase(phrase);
    }

    public Part(Phrase[] phraseArray) {
        this();
        this.addPhraseList(phraseArray);
    }

    public Part(CPhrase cPhrase) {
        this();
        this.addCPhrase(cPhrase);
    }

    public Part(Phrase phrase, String string) {
        this(string);
        this.addPhrase(phrase);
    }

    public Part(Phrase[] phraseArray, String string) {
        this(string);
        this.addPhraseList(phraseArray);
    }

    public Part(Phrase phrase, String string, int n) {
        this(string, n);
        this.addPhrase(phrase);
    }

    public Part(Phrase[] phraseArray, String string, int n) {
        this(string, n);
        this.addPhraseList(phraseArray);
    }

    public Part(Phrase phrase, String string, int n, int n2) {
        this(string, n, n2);
        this.addPhrase(phrase);
    }

    public Part(Phrase[] phraseArray, String string, int n, int n2) {
        this(string, n, n2);
        this.addPhraseList(phraseArray);
    }

    public Phrase getPhrase(int n) {
        Enumeration enumeration = this.phraseList.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            if (n2 == n) {
                return phrase;
            }
            ++n2;
        }
        return null;
    }

    public void add(Phrase phrase) {
        this.addPhrase(phrase);
    }

    public void addPhrase(Phrase phrase) {
        phrase.setMyPart(this);
        if (phrase.getAppend()) {
            phrase.setStartTime(this.getEndTime());
        }
        this.phraseList.addElement(phrase);
    }

    public void appendPhrase(Phrase phrase) {
        Phrase phrase2 = phrase.copy();
        phrase2.setStartTime(this.getEndTime());
        this.addPhrase(phrase2);
    }

    public void addPhraseList(Phrase[] phraseArray) {
        for (int i = 0; i < phraseArray.length; ++i) {
            if (phraseArray[i].getAppend()) {
                Phrase phrase = phraseArray[i].copy();
                phrase.setStartTime(this.getEndTime());
                this.addPhrase(phrase);
                continue;
            }
            this.addPhrase(phraseArray[i]);
        }
    }

    public void removePhrase(int n) {
        Vector vector = this.phraseList;
        try {
            vector.removeElement(vector.elementAt(n));
        }
        catch (RuntimeException runtimeException) {
            System.err.println("The Phrase index to be deleted must be within the part.");
        }
    }

    public void removePhrase(Phrase phrase) {
        this.phraseList.removeElement(phrase);
    }

    public void removeLastPhrase() {
        Vector vector = this.phraseList;
        vector.removeElement(vector.lastElement());
    }

    public void removeAllPhrases() {
        this.phraseList.removeAllElements();
    }

    public Vector getPhraseList() {
        return this.phraseList;
    }

    public void setPhraseList(Vector vector) {
        this.phraseList = vector;
    }

    public Phrase[] getPhraseArray() {
        Vector vector = this.phraseList;
        Phrase[] phraseArray = new Phrase[vector.size()];
        for (int i = 0; i < phraseArray.length; ++i) {
            phraseArray[i] = (Phrase)vector.elementAt(i);
        }
        return phraseArray;
    }

    public void addCPhrase(CPhrase cPhrase) {
        if (cPhrase.getAppend()) {
            cPhrase.setStartTime(this.getEndTime());
        }
        Enumeration enumeration = cPhrase.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            this.addPhrase(phrase);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int n) {
        this.channel = n;
    }

    public int getInstrument() {
        return this.instrument;
    }

    public void setInstrument(int n) {
        this.instrument = n;
    }

    public void setProgChg(int n) {
        this.instrument = n;
    }

    public double getTempo() {
        return this.tempo;
    }

    public void setTempo(double d) {
        this.tempo = d;
    }

    public int getVolume() {
        return this.volume;
    }

    public void setVolume(int n) {
        this.volume = n;
    }

    public int getKeySignature() {
        return this.keySignature;
    }

    public void setKeySignature(int n) {
        this.keySignature = n;
    }

    public int getKeyQuality() {
        return this.keyQuality;
    }

    public void setKeyQuality(int n) {
        this.keyQuality = n;
    }

    public int getNumerator() {
        return this.numerator;
    }

    public void setNumerator(int n) {
        this.numerator = n;
    }

    public int getDenominator() {
        return this.denominator;
    }

    public void setDenominator(int n) {
        this.denominator = n;
    }

    public double getPan() {
        return this.pan;
    }

    public void setPan(double d) {
        this.pan = d;
        Enumeration enumeration = this.phraseList.elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            phrase.setPan(d);
        }
    }

    public void setMyScore(Score score) {
        this.myScore = score;
    }

    public Score getMyScore() {
        return this.myScore;
    }

    public Part copy() {
        Part part = new Part();
        Enumeration enumeration = this.phraseList.elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            part.addPhrase(phrase.copy());
        }
        this.copyAttributes(part);
        return part;
    }

    private void copyAttributes(Part part) {
        part.setInstrument(this.getInstrument());
        part.setChannel(this.getChannel());
        part.setTitle(this.getTitle() + " copy");
        part.setTempo(this.tempo);
        part.setVolume(this.volume);
        part.setPoints(this.points);
        part.setTime(this.time);
        part.setTimeIndex(this.timeIndex);
        part.setMyScore(this.getMyScore());
    }

    public Part copy(double d, double d2) {
        Vector<Phrase> vector = new Vector<Phrase>();
        Part part = new Part();
        this.copyAttributes(part);
        Enumeration enumeration = this.phraseList.elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            if (!(phrase.getStartTime() < d2) || !(phrase.getEndTime() > d)) continue;
            vector.addElement(phrase.copy(d, d2));
        }
        part.setPhraseList(vector);
        return part;
    }

    public Part copy(double d, double d2, boolean bl, boolean bl2, boolean bl3) {
        Part part = new Part();
        this.copyAttributes(part);
        Vector<Phrase> vector = new Vector<Phrase>();
        part.setMyScore(this.getMyScore());
        Enumeration enumeration = this.phraseList.elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            double d3 = phrase.getStartTime();
            if (!(d3 < d2) || !(phrase.getEndTime() > d)) continue;
            Phrase phrase2 = phrase.copy(d, d2, bl, bl2, false);
            double d4 = 0.0;
            if (d4 < 0.0) {
                d4 = 0.0;
            }
            if (bl3) {
                d4 += d;
            }
            phrase2.setStartTime(d4);
            vector.addElement(phrase2);
        }
        part.setPhraseList(vector);
        return part;
    }

    public double getEndTime() {
        double d = 0.0;
        Enumeration enumeration = this.phraseList.elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            double d2 = phrase.getEndTime();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public String toString() {
        String string = new String("----- jMusic PART: '" + this.title + "' contains " + this.size() + " phrases.  -----" + '\n');
        string = string + "Channel = " + this.channel + '\n';
        string = string + "Instrument = " + this.instrument + '\n';
        if (this.tempo > 0.0) {
            string = string + "Part Tempo = " + this.tempo + '\n';
        }
        Enumeration enumeration = this.phraseList.elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            string = string + phrase.toString() + '\n';
        }
        return string;
    }

    public void empty() {
        this.phraseList.removeAllElements();
    }

    public int length() {
        return this.size();
    }

    public int size() {
        return this.phraseList.size();
    }

    public int getSize() {
        return this.phraseList.size();
    }

    public void clean() {
        Enumeration enumeration = this.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            if (phrase.getInstrument() == this.instrument) {
                phrase.setInstrument(-1);
            }
            if (phrase.getNoteList().size() != 0) continue;
            this.removePhrase(phrase);
        }
    }

    public int getHighestPitch() {
        int n = 0;
        Enumeration enumeration = this.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            if (phrase.getHighestPitch() <= n) continue;
            n = phrase.getHighestPitch();
        }
        return n;
    }

    public int getLowestPitch() {
        int n = 127;
        Enumeration enumeration = this.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            if (phrase.getLowestPitch() >= n) continue;
            n = phrase.getLowestPitch();
        }
        return n;
    }

    public double getLongestRhythmValue() {
        double d = 0.0;
        Enumeration enumeration = this.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            if (!(phrase.getLongestRhythmValue() > d)) continue;
            d = phrase.getLongestRhythmValue();
        }
        return d;
    }

    public double getShortestRhythmValue() {
        double d = 1000.0;
        Enumeration enumeration = this.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            if (!(phrase.getShortestRhythmValue() < d)) continue;
            d = phrase.getShortestRhythmValue();
        }
        return d;
    }

    public void setDynamic(int n) {
        Enumeration enumeration = this.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            phrase.setDynamic(n);
        }
    }

    public void setPitch(int n) {
        Enumeration enumeration = this.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            phrase.setPitch(n);
        }
    }

    public void setRhythmValue(int n) {
        Enumeration enumeration = this.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            phrase.setRhythmValue(n);
        }
    }

    public void setDuration(double d) {
        Enumeration enumeration = this.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            phrase.setDuration(d);
        }
    }

    public void setPoints(double[] dArray) {
        this.points = dArray;
    }

    public double getPoint() {
        return this.points[this.timeIndex];
    }

    public void setTime(long[] lArray) {
        this.time = lArray;
    }

    public long getTime() {
        return this.time[this.timeIndex++];
    }

    public void setTimeIndex(int n) {
        this.timeIndex = n;
    }

    public int getTimeIndex() {
        return this.timeIndex;
    }

    public void addNote(Note note, double d) {
        Phrase phrase = new Phrase("Generated by Part.addNote()", d);
        phrase.addNote(note);
        this.addPhrase(phrase);
    }

    public Phrase createPhrase() {
        Phrase phrase = new Phrase();
        this.addPhrase(phrase);
        return phrase;
    }
}

