/*
 * Decompiled with CFR 0.152.
 */
package jm.music.data;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import jm.JMC;
import jm.music.data.Alignment;
import jm.music.data.Anchoring;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Rest;

public class Phrase
implements JMC,
Cloneable,
Serializable {
    public static final double MIN_START_TIME = 0.0;
    public static final String DEFAULT_TITLE = "Untitled Phrase";
    public static final double DEFAULT_START_TIME = 0.0;
    public static final int DEFAULT_INSTRUMENT = -1;
    public static final boolean DEFAULT_APPEND = false;
    public static final double DEFAULT_TEMPO = -1.0;
    public static final double DEFAULT_PAN = 0.5;
    public static final int DEFAULT_NUMERATOR = 4;
    public static final int DEFAULT_DENOMINATOR = 4;
    public static final int DEFAULT_VOLUME = 100;
    private Vector noteList;
    private String title;
    private Position position;
    private int instrument;
    private double tempo;
    private boolean append = false;
    private Phrase linkedPhrase;
    private double pan = 0.5;
    private int numerator;
    private int denominator;
    private Part myPart = null;
    private int volume;
    private boolean mute = false;

    public Phrase() {
        this(0.0);
        this.append = true;
    }

    public Phrase(double d) {
        this(d, -1);
    }

    public Phrase(double d, int n) {
        this(DEFAULT_TITLE, d, n);
    }

    public Phrase(String string) {
        this(string, 0.0);
        this.append = true;
    }

    public Phrase(String string, double d) {
        this(string, d, -1);
    }

    public Phrase(String string, double d, int n) {
        this(string, d, n, false);
    }

    public Phrase(String string, double d, int n, boolean bl) {
        this.title = string;
        this.position = new Position(d, this);
        this.append = bl;
        if (n < -1) {
            System.err.println(new Exception("jMusic EXCEPTION: instrument value must be greater than 0"));
            new Exception().printStackTrace();
            System.exit(1);
        }
        this.instrument = n;
        this.noteList = new Vector();
        this.numerator = 4;
        this.denominator = 4;
        this.tempo = -1.0;
        this.volume = 100;
    }

    public Phrase(Note note) {
        this();
        this.addNote(note);
    }

    public Phrase(Note[] noteArray) {
        this();
        this.addNoteList(noteArray);
    }

    public Phrase(Note note, String string) {
        this(string);
        this.addNote(note);
    }

    public Phrase(Note[] noteArray, String string) {
        this(string);
        this.addNoteList(noteArray);
    }

    public Phrase(Note note, double d) {
        this(note);
        this.setStartTime(d);
    }

    public int getInstrument() {
        return this.instrument;
    }

    public void setInstrument(int n) {
        this.instrument = n;
    }

    public void addNote(Note note) {
        note.setMyPhrase(this);
        this.noteList.addElement(note);
    }

    public void addNote(int n, double d) {
        Note note = new Note(n, d);
        this.addNote(note);
    }

    public void add(Note note) {
        this.addNote(note);
    }

    public void addRest(Rest rest) {
        rest.setMyPhrase(this);
        this.noteList.addElement(rest);
    }

    public void addNoteList(Note[] noteArray) {
        for (int i = 0; i < noteArray.length; ++i) {
            this.addNote(noteArray[i]);
        }
    }

    public void addNoteList(Vector vector, boolean bl) {
        Enumeration enumeration = vector.elements();
        if (!bl) {
            this.noteList.removeAllElements();
        }
        while (enumeration.hasMoreElements()) {
            try {
                Note note = (Note)enumeration.nextElement();
                this.addNote(note);
            }
            catch (RuntimeException runtimeException) {
                System.err.println("The vector passed to this method must contain Notes only!");
            }
        }
    }

    public void addNoteList(Note[] noteArray, boolean bl) {
        if (!bl) {
            this.noteList.removeAllElements();
        }
        for (int i = 0; i < noteArray.length; ++i) {
            this.addNote(noteArray[i]);
        }
    }

    public void addNoteList(int[] nArray, double d) {
        double[] dArray = new double[nArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = d;
        }
        this.addNoteList(nArray, dArray);
    }

    public void addNoteList(int[] nArray, double d, int n) {
        double[] dArray = new double[nArray.length];
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = d;
            nArray2[i] = n;
        }
        this.addNoteList(nArray, dArray, nArray2);
    }

    public void addNoteList(double[] dArray, double d) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = d;
        }
        this.addNoteList(dArray, dArray2);
    }

    public void addNoteList(int[] nArray, double[] dArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = 85;
        }
        this.addNoteList(nArray, dArray, nArray2);
    }

    public void addNoteList(double[] dArray, double[] dArray2) {
        int[] nArray = new int[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            nArray[i] = 85;
        }
        this.addNoteList(dArray, dArray2, nArray);
    }

    public void addNoteList(int[] nArray, double[] dArray, int[] nArray2) {
        this.addNoteList(nArray, dArray, nArray2, true);
    }

    public void addNoteList(double[] dArray, double[] dArray2, int[] nArray) {
        this.addNoteList(dArray, dArray2, nArray, true);
    }

    public void addNoteList(int[] nArray, double[] dArray, int[] nArray2, boolean bl) {
        if (!bl) {
            this.noteList.removeAllElements();
        }
        for (int i = 0; i < nArray.length; ++i) {
            try {
                Note note = new Note(nArray[i], dArray[i], nArray2[i]);
                this.addNote(note);
                continue;
            }
            catch (RuntimeException runtimeException) {
                System.err.println("You must enter arrays of even length");
            }
        }
    }

    public void addNoteList(double[] dArray, double[] dArray2, int[] nArray, boolean bl) {
        if (!bl) {
            this.noteList.removeAllElements();
        }
        for (int i = 0; i < dArray.length; ++i) {
            try {
                Note note = new Note(dArray[i], dArray2[i], nArray[i]);
                this.addNote(note);
                continue;
            }
            catch (RuntimeException runtimeException) {
                System.err.println("jMusic Phrase error: You must enter arrays of even length");
            }
        }
    }

    public void addNoteList(double[] dArray) {
        for (int i = 0; i < dArray.length; i += 2) {
            try {
                Note note = new Note((int)dArray[i], dArray[i + 1]);
                this.addNote(note);
                continue;
            }
            catch (RuntimeException runtimeException) {
                System.err.println("Error adding note list: Possibly the wrong number of values in the pitch and rhythm array.");
            }
        }
    }

    public void addNoteList(int n, double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            this.addNote(new Note(n, dArray[i]));
        }
    }

    public void addNoteList(double d, double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            this.addNote(new Note(d, dArray[i]));
        }
    }

    public void addChord(int[] nArray, double d) {
        for (int i = 0; i < nArray.length - 1; ++i) {
            Note note = new Note(nArray[i], 0.0);
            note.setDuration(d * 0.9);
            this.addNote(note);
        }
        this.addNote(nArray[nArray.length - 1], d);
    }

    public void removeNote(int n) {
        Vector vector = this.noteList;
        try {
            vector.removeElement(vector.elementAt(n));
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Note index to be deleted must be within the phrase.");
        }
    }

    public void removeNote(Note note) {
        this.noteList.removeElement(note);
    }

    public void removeLastNote() {
        Vector vector = this.noteList;
        vector.removeElementAt(vector.size() - 1);
    }

    public Vector getNoteList() {
        return this.noteList;
    }

    public void setNoteList(Vector vector) {
        this.noteList = vector;
    }

    public Note[] getNoteArray() {
        Vector vector = this.noteList;
        Note[] noteArray = new Note[vector.size()];
        for (int i = 0; i < noteArray.length; ++i) {
            noteArray[i] = (Note)vector.elementAt(i);
        }
        return noteArray;
    }

    public double getStartTime() {
        return this.position.getStartTime();
    }

    public void setStartTime(double d) {
        if (d >= 0.0) {
            this.position.setStartTime(d);
            this.setAppend(false);
        } else {
            System.err.println("Error setting phrase start time value: You must enter values greater than 0.0");
        }
    }

    public boolean attemptAnchoringTo(Phrase phrase, Alignment alignment, double d) {
        Position position = new Position(phrase.position, alignment, d, this);
        if (position.getStartTime() < 0.0) {
            return false;
        }
        this.position = position;
        return true;
    }

    public Anchoring getAnchoring() {
        return this.position.getAnchoring();
    }

    public double getEndTime() {
        double d;
        double d2 = d = this.getStartTime() < 0.0 ? 0.0 : this.getStartTime();
        Enumeration enumeration = this.noteList.elements();
        while (enumeration.hasMoreElements()) {
            Note note = (Note)enumeration.nextElement();
            d2 += note.getRhythmValue();
        }
        return d2;
    }

    final double getTotalDuration() {
        double d = 0.0;
        Enumeration enumeration = this.noteList.elements();
        while (enumeration.hasMoreElements()) {
            Note note = (Note)enumeration.nextElement();
            d += note.getRhythmValue();
        }
        return d;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public boolean getAppend() {
        return this.append;
    }

    public void setAppend(boolean bl) {
        this.append = bl;
    }

    public Phrase getLinkedPhrase() {
        return this.linkedPhrase;
    }

    public void setLinkedPhrase(Phrase phrase) {
        this.linkedPhrase = phrase;
    }

    public double getPan() {
        return this.pan;
    }

    public void setPan(double d) {
        this.pan = d;
        Enumeration enumeration = this.noteList.elements();
        while (enumeration.hasMoreElements()) {
            Note note = (Note)enumeration.nextElement();
            note.setPan(d);
        }
    }

    public double getTempo() {
        return this.tempo;
    }

    public void setTempo(double d) {
        this.tempo = d;
    }

    public Note getNote(int n) {
        Enumeration enumeration = this.noteList.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            Note note = (Note)enumeration.nextElement();
            if (n2 == n) {
                return note;
            }
            ++n2;
        }
        return null;
    }

    public int length() {
        return this.size();
    }

    public int size() {
        return this.noteList.size();
    }

    public int getSize() {
        return this.noteList.size();
    }

    public int getNumerator() {
        return this.numerator;
    }

    public void setNumerator(int n) {
        this.numerator = n;
    }

    public int getDenominator() {
        return this.denominator;
    }

    public void setDenominator(int n) {
        this.denominator = n;
    }

    public void setMyPart(Part part) {
        this.myPart = part;
    }

    public Part getMyPart() {
        return this.myPart;
    }

    public Phrase copy() {
        Phrase phrase = new Phrase();
        this.copyAttributes(phrase);
        Enumeration enumeration = this.noteList.elements();
        while (enumeration.hasMoreElements()) {
            phrase.addNote(((Note)enumeration.nextElement()).copy());
        }
        return phrase;
    }

    private void copyAttributes(Phrase phrase) {
        phrase.position = this.position.copy(phrase);
        phrase.setTitle(this.title + " copy");
        phrase.setInstrument(this.instrument);
        phrase.setAppend(this.append);
        phrase.setPan(this.pan);
        phrase.setLinkedPhrase(this.linkedPhrase);
        phrase.setMyPart(this.getMyPart());
        phrase.setTempo(this.tempo);
        phrase.setNumerator(this.numerator);
        phrase.setDenominator(this.denominator);
        phrase.setVolume(this.volume);
    }

    public Phrase copy(double d, double d2) {
        Phrase phrase = this.copy(d, d2, true);
        return phrase;
    }

    public Phrase copy(double d, double d2, boolean bl) {
        if (d >= d2 || d2 < this.getStartTime()) {
            return null;
        }
        boolean bl2 = bl;
        Phrase phrase = new Phrase();
        this.copyAttributes(phrase);
        double d3 = this.getStartTime();
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        if (d < d3) {
            Note note = new Note(Integer.MIN_VALUE, d3 - d);
            phrase.addNote(note);
        }
        for (int i = 0; i < this.size(); ++i) {
            Note note;
            if (d3 < d) {
                if (d3 + this.getNote(i).getRhythmValue() > d && d3 + this.getNote(i).getRhythmValue() <= d2) {
                    if (bl2) {
                        note = new Note(Integer.MIN_VALUE, d3 + this.getNote(i).getRhythmValue() - d, this.getNote(i).getDynamic());
                        phrase.addNote(note);
                    } else if (!this.getNote(i).getPitchType()) {
                        note = new Note(this.getNote(i).getPitch(), d3 + this.getNote(i).getRhythmValue() - d, this.getNote(i).getDynamic());
                        phrase.addNote(note);
                    } else {
                        note = new Note(this.getNote(i).getFrequency(), d3 + this.getNote(i).getRhythmValue() - d, this.getNote(i).getDynamic());
                        phrase.addNote(note);
                    }
                }
                if (d3 + this.getNote(i).getRhythmValue() > d2) {
                    if (bl2) {
                        note = new Note(Integer.MIN_VALUE, d3 + this.getNote(i).getRhythmValue() - d, this.getNote(i).getDynamic());
                        phrase.addNote(note);
                    } else if (!this.getNote(i).getPitchType()) {
                        note = new Note(this.getNote(i).getPitch(), d3 + d2 - d, this.getNote(i).getDynamic());
                        phrase.addNote(note);
                    } else {
                        note = new Note(this.getNote(i).getPitch(), d3 + d2 - d, this.getNote(i).getDynamic());
                        phrase.addNote(note);
                    }
                }
            }
            if (d3 >= d && d3 < d2) {
                if (d3 + this.getNote(i).getRhythmValue() <= d2) {
                    phrase.addNote(this.getNote(i));
                } else {
                    note = new Note(this.getNote(i).getPitch(), d2 - d3, this.getNote(i).getDynamic());
                    phrase.addNote(note);
                }
            }
            d3 += this.getNote(i).getRhythmValue();
        }
        if (d3 < d2) {
            Note note = new Note(Integer.MIN_VALUE, d2 - d3);
            phrase.addNote(note);
        }
        return phrase;
    }

    public Phrase copy(double d, double d2, boolean bl, boolean bl2, boolean bl3) {
        Note note;
        Note note2;
        if (d >= d2 || d2 < this.getStartTime()) {
            System.out.println("invalid arguments in Phrase.copy");
            return null;
        }
        Phrase phrase = new Phrase("", d, this.instrument);
        phrase.setAppend(this.append);
        phrase.setPan(this.pan);
        phrase.setLinkedPhrase(this.linkedPhrase);
        phrase.setMyPart(this.getMyPart());
        double d3 = this.getStartTime();
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        Enumeration enumeration = this.getNoteList().elements();
        while (d > d3 && enumeration.hasMoreElements()) {
            note2 = (Note)enumeration.nextElement();
            d3 += note2.getRhythmValue();
        }
        if (d < d3) {
            if (d3 < d2) {
                if (bl3) {
                    phrase.setStartTime(d3 + this.getStartTime());
                } else {
                    note2 = new Note(Integer.MIN_VALUE, d3 - d);
                    phrase.addNote(note2);
                }
            } else {
                note2 = new Note(Integer.MIN_VALUE, d2 - d);
                phrase.addNote(note2);
                return phrase;
            }
        }
        double d4 = 0.0;
        while (enumeration.hasMoreElements() && d3 < d2) {
            note = ((Note)enumeration.nextElement()).copy();
            if (note.getRhythmValue() + d3 > d2 && bl) {
                note.setRhythmValue(d2 - d3, bl2);
            }
            phrase.addNote(note);
            d4 += note.getRhythmValue();
            d3 += note.getRhythmValue();
        }
        if (d3 < d2) {
            note = new Note(Integer.MIN_VALUE, d2 - d3);
            phrase.addNote(note);
        } else if (d4 == 0.0) {
            note = new Note(Integer.MIN_VALUE, d2 - d);
            phrase.addNote(note);
        }
        return phrase;
    }

    public Phrase copy(int n, int n2) {
        if (n2 >= n) {
            System.err.println("jMusic Phrase copy error: lowset pitch is not lower than highest pitch");
            System.exit(0);
        }
        Phrase phrase = new Phrase(this.title + " copy");
        phrase.position = this.position.copy(phrase);
        phrase.setInstrument(this.instrument);
        phrase.setAppend(this.append);
        phrase.setPan(this.pan);
        phrase.setLinkedPhrase(this.linkedPhrase);
        phrase.setMyPart(this.getMyPart());
        Enumeration enumeration = this.noteList.elements();
        while (enumeration.hasMoreElements()) {
            Note note = ((Note)enumeration.nextElement()).copy();
            if (note.getPitch() > n && note.getPitch() < n2) {
                note.setPitch(Integer.MIN_VALUE);
            }
            phrase.addNote(note);
        }
        return phrase;
    }

    public String toString() {
        String string = new String("-------- jMusic PHRASE: '" + this.title + "' contains " + this.size() + " notes.  Start time: " + this.getStartTime() + " --------" + '\n');
        if (this.tempo > 0.0) {
            string = string + "Phrase Tempo = " + this.tempo + '\n';
        }
        Enumeration enumeration = this.getNoteList().elements();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            Note note = (Note)enumeration.nextElement();
            string = string + note.toString() + '\n';
        }
        return string;
    }

    public void empty() {
        this.noteList.removeAllElements();
    }

    public Phrase alias() {
        Phrase phrase = new Phrase(this.title + " alias", this.getStartTime(), this.instrument);
        phrase.setTempo(this.tempo);
        phrase.setAppend(this.append);
        phrase.noteList = this.noteList;
        return phrase;
    }

    public int getHighestPitch() {
        int n = -1;
        Enumeration enumeration = this.getNoteList().elements();
        while (enumeration.hasMoreElements()) {
            Note note = (Note)enumeration.nextElement();
            if (note.getPitchType() || note.getPitch() <= n) continue;
            n = note.getPitch();
        }
        return n;
    }

    public int getLowestPitch() {
        int n = 128;
        Enumeration enumeration = this.getNoteList().elements();
        while (enumeration.hasMoreElements()) {
            Note note = (Note)enumeration.nextElement();
            if (note.getPitchType() || note.getPitch() >= n || note.getPitch() < 0) continue;
            n = note.getPitch();
        }
        return n;
    }

    public double getLongestRhythmValue() {
        double d = 0.0;
        Enumeration enumeration = this.getNoteList().elements();
        while (enumeration.hasMoreElements()) {
            Note note = (Note)enumeration.nextElement();
            if (!(note.getRhythmValue() > d)) continue;
            d = note.getRhythmValue();
        }
        return d;
    }

    public double getShortestRhythmValue() {
        double d = 1000.0;
        Enumeration enumeration = this.getNoteList().elements();
        while (enumeration.hasMoreElements()) {
            Note note = (Note)enumeration.nextElement();
            if (!(note.getRhythmValue() < d)) continue;
            d = note.getRhythmValue();
        }
        return d;
    }

    public void setDynamic(int n) {
        Enumeration enumeration = this.getNoteList().elements();
        while (enumeration.hasMoreElements()) {
            Note note = (Note)enumeration.nextElement();
            note.setDynamic(n);
        }
    }

    public void setPitch(int n) {
        Enumeration enumeration = this.getNoteList().elements();
        while (enumeration.hasMoreElements()) {
            Note note = (Note)enumeration.nextElement();
            note.setPitch(n);
        }
    }

    public void setRhythmValue(int n) {
        Enumeration enumeration = this.getNoteList().elements();
        while (enumeration.hasMoreElements()) {
            Note note = (Note)enumeration.nextElement();
            note.setRhythmValue(n);
        }
    }

    public void setDuration(double d) {
        Enumeration enumeration = this.getNoteList().elements();
        while (enumeration.hasMoreElements()) {
            Note note = (Note)enumeration.nextElement();
            note.setDuration(d);
        }
    }

    public double getBeatLength() {
        return this.getEndTime();
    }

    public Note createNote() {
        Note note = new Note();
        this.addNote(note);
        return note;
    }

    public void setVolume(int n) {
        this.volume = n;
    }

    public int getVolume() {
        return this.volume;
    }

    public void setNote(Note note, int n) {
        if (n >= this.getSize()) {
            System.out.println("jMusic error: Phrase setNote index is too large.");
            return;
        }
        this.noteList.removeElementAt(n);
        this.noteList.insertElementAt(note, n);
    }

    public void setMute(boolean bl) {
        this.mute = bl;
    }

    public boolean getMute() {
        return this.mute;
    }

    private final class Position
    implements Serializable {
        private double startTime = 0.0;
        private final Phrase phrase;
        private boolean isAbsolute = false;
        private Position anchor;
        private Alignment alignment = Alignment.AFTER;
        private double offset;

        private Position(double d, Phrase phrase2) {
            this.isAbsolute = true;
            this.startTime = d;
            this.phrase = phrase2;
        }

        private Position(Position position, Alignment alignment, double d, Phrase phrase2) {
            this.isAbsolute = false;
            this.anchor = position;
            this.alignment = alignment;
            this.offset = d;
            this.phrase = phrase2;
        }

        private final Anchoring getAnchoring() {
            if (this.isAbsolute) {
                return null;
            }
            return new Anchoring(this.anchor.phrase, this.alignment, this.offset);
        }

        private final void setStartTime(double d) {
            this.isAbsolute = true;
            this.startTime = d;
        }

        private final double getStartTime() {
            if (this.isAbsolute) {
                return this.startTime;
            }
            return this.alignment.determineStartTime(this.phrase.getTotalDuration(), this.anchor.getStartTime(), this.anchor.getEndTime()) + this.offset;
        }

        private final double getEndTime() {
            return this.phrase.getEndTime();
        }

        private final Position copy(Phrase phrase) {
            return this.isAbsolute ? new Position(this.startTime, phrase) : new Position(this.anchor, this.alignment, this.offset, phrase);
        }
    }
}

