/*
 * Decompiled with CFR 0.152.
 */
package jm.music.data;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import jm.JMC;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;

public class Score
implements JMC,
Cloneable,
Serializable {
    public static final String DEFAULT_TITLE = "Untitled Score";
    public static final double DEFAULT_TEMPO = 60.0;
    public static final int DEFAULT_VOLUME = 100;
    public static final int DEFAULT_KEY_SIGNATURE = 0;
    public static final int DEFAULT_KEY_QUALITY = 0;
    public static final int DEFAULT_NUMERATOR = 4;
    public static final int DEFAULT_DENOMINATOR = 4;
    private String title;
    private Vector partList;
    private double tempo;
    private int volume;
    private int keySignature;
    private int keyQuality;
    private int numerator;
    private int denominator;

    public Score() {
        this(DEFAULT_TITLE);
    }

    public Score(String string) {
        this(string, 60.0);
    }

    public Score(double d) {
        this(DEFAULT_TITLE, d);
    }

    public Score(String string, double d) {
        this.title = string;
        this.tempo = d;
        this.partList = new Vector();
        this.volume = 100;
        this.keySignature = 0;
        this.keyQuality = 0;
        this.numerator = 4;
        this.denominator = 4;
    }

    public Score(Part part) {
        this();
        this.addPart(part);
    }

    public Score(String string, double d, Part part) {
        this(string, d);
        this.addPart(part);
    }

    public Score(Part[] partArray) {
        this();
        this.addPartList(partArray);
    }

    public Score(Part part, String string) {
        this(string);
        this.addPart(part);
    }

    public Score(Part[] partArray, String string) {
        this(string);
        this.addPartList(partArray);
    }

    public Score(Part part, String string, double d) {
        this(string, d);
        this.addPart(part);
    }

    public Score(Part[] partArray, String string, double d) {
        this(string, d);
        this.addPartList(partArray);
    }

    public void add(Part part) {
        this.addPart(part);
    }

    public void addPart(Part part) {
        part.setMyScore(this);
        this.partList.addElement(part);
    }

    public void insertPart(Part part, int n) throws ArrayIndexOutOfBoundsException {
        this.partList.insertElementAt(part, n);
        part.setMyScore(this);
    }

    public void addPartList(Part[] partArray) {
        for (int i = 0; i < partArray.length; ++i) {
            this.addPart(partArray[i]);
        }
    }

    public void removePart(int n) {
        Vector vector = this.partList;
        try {
            vector.removeElement(vector.elementAt(n));
        }
        catch (RuntimeException runtimeException) {
            System.err.println("The Part index to be deleted must be within the score.");
        }
    }

    public void removePart(Part part) {
        this.partList.removeElement(part);
    }

    public void removeLastPart() {
        Vector vector = this.partList;
        vector.removeElement(vector.lastElement());
    }

    public void removeAllParts() {
        this.partList.removeAllElements();
    }

    public Vector getPartList() {
        return this.partList;
    }

    public Part[] getPartArray() {
        Vector vector = (Vector)this.partList.clone();
        Part[] partArray = new Part[vector.size()];
        for (int i = 0; i < partArray.length; ++i) {
            partArray[i] = (Part)vector.elementAt(i);
        }
        return partArray;
    }

    public Part getPart(String string) {
        Enumeration enumeration = this.partList.elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            if (!part.getTitle().equalsIgnoreCase(string)) continue;
            return part;
        }
        return null;
    }

    public Part getPart(int n) {
        Enumeration enumeration = this.partList.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            if (n2 == n) {
                return part;
            }
            ++n2;
        }
        return null;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public double getTempo() {
        return this.tempo;
    }

    public void setTempo(double d) {
        this.tempo = d;
    }

    public int getVolume() {
        return this.volume;
    }

    public void setVolume(int n) {
        this.volume = n;
    }

    public int getKeySignature() {
        return this.keySignature;
    }

    public void setKeySignature(int n) {
        this.keySignature = n;
    }

    public int getKeyQuality() {
        return this.keyQuality;
    }

    public void setKeyQuality(int n) {
        this.keyQuality = n;
    }

    public int getNumerator() {
        return this.numerator;
    }

    public void setNumerator(int n) {
        this.numerator = n;
    }

    public int getDenominator() {
        return this.denominator;
    }

    public void setDenominator(int n) {
        this.denominator = n;
    }

    public void setTimeSignature(int n, int n2) {
        this.numerator = n;
        this.denominator = n2;
    }

    public Score copy() {
        Score score = new Score(this.title + " copy");
        score.setTempo(this.tempo);
        score.setVolume(this.volume);
        Enumeration enumeration = this.partList.elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            score.addPart(part.copy());
        }
        return score;
    }

    public Score copy(double d, double d2) {
        Score score = this.copy();
        score.removeAllParts();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            score.addPart(this.getPart(i).copy(d, d2));
        }
        return score;
    }

    public double getEndTime() {
        double d = 0.0;
        Enumeration enumeration = this.partList.elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            double d2 = part.getEndTime();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public String toString() {
        String string = new String("***** jMusic SCORE: '" + this.title + "' contains " + this.size() + " parts. ****" + '\n');
        string = string + "Score Tempo = " + this.tempo + " bpm" + '\n';
        Enumeration enumeration = this.partList.elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            string = string + part.toString() + '\n';
        }
        return string;
    }

    public void empty() {
        this.empty(false);
    }

    public void empty(boolean bl) {
        if (bl) {
            Enumeration enumeration = this.getPartList().elements();
            while (enumeration.hasMoreElements()) {
                Part part = (Part)enumeration.nextElement();
                Enumeration enumeration2 = part.getPhraseList().elements();
                while (enumeration2.hasMoreElements()) {
                    Phrase phrase = (Phrase)enumeration2.nextElement();
                    Enumeration enumeration3 = part.getPhraseList().elements();
                    while (enumeration3.hasMoreElements()) {
                        Note note = (Note)enumeration3.nextElement();
                        note = null;
                    }
                    phrase = null;
                }
                part = null;
            }
        }
        this.partList.removeAllElements();
    }

    public int length() {
        return this.size();
    }

    public int size() {
        return this.partList.size();
    }

    public int getSize() {
        return this.partList.size();
    }

    public void clean() {
        Enumeration enumeration = this.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            part.clean();
            if (part.getPhraseList().size() != 0) continue;
            this.removePart(part);
        }
    }

    public int getHighestPitch() {
        int n = 0;
        Enumeration enumeration = this.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            if (part.getHighestPitch() <= n) continue;
            n = part.getHighestPitch();
        }
        return n;
    }

    public int getLowestPitch() {
        int n = 127;
        Enumeration enumeration = this.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            if (part.getLowestPitch() >= n) continue;
            n = part.getLowestPitch();
        }
        return n;
    }

    public double getLongestRhythmValue() {
        double d = 0.0;
        Enumeration enumeration = this.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            if (!(part.getLongestRhythmValue() > d)) continue;
            d = part.getLongestRhythmValue();
        }
        return d;
    }

    public double getShortestRhythmValue() {
        double d = 1000.0;
        Enumeration enumeration = this.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            if (!(part.getShortestRhythmValue() < d)) continue;
            d = part.getShortestRhythmValue();
        }
        return d;
    }

    public void setPan(double d) {
        Enumeration enumeration = this.partList.elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            part.setPan(d);
        }
    }

    public Part createPart() {
        Part part = new Part();
        this.addPart(part);
        return part;
    }
}

