/*
 * Decompiled with CFR 0.152.
 */
package jm.music.rt;

import jm.audio.AOException;
import jm.audio.AudioChainListener;
import jm.audio.Instrument;
import jm.audio.RTMixer;
import jm.music.data.Note;

public abstract class RTLine
implements AudioChainListener {
    protected Instrument[] inst;
    protected boolean clear = false;
    private double localCounter = 0.0;
    private boolean newNote = true;
    private double tempo = 60.0;
    private double testpos;
    private double size;

    public RTLine(Instrument[] instrumentArray) {
        int n;
        this.inst = instrumentArray;
        for (n = 0; n < instrumentArray.length; ++n) {
            instrumentArray[n].addRTLine(this);
        }
        n = instrumentArray[0].getSampleRate();
        int n2 = instrumentArray[0].getChannels();
        for (int i = 0; i < instrumentArray.length; ++i) {
            if (instrumentArray[i].getSampleRate() != n) {
                System.err.println("jMusic RTLine error: All instruments must have the same sample rate.");
                System.exit(0);
            }
            if (instrumentArray[i].getChannels() == n2) continue;
            System.err.println("jMusic RTLine error: All instruments must have the same number of channels.");
            System.exit(0);
        }
        this.size = n * n2;
    }

    public Instrument[] getInstrument() {
        return this.inst;
    }

    public int getNumLines() {
        return this.inst.length;
    }

    public void setTempo(double d) {
        this.tempo = d;
    }

    public void setBufferSize(int n) {
        for (int i = 0; i < this.inst.length; ++i) {
            this.inst[i].setBufSize(n);
        }
    }

    public int getSampleRate() {
        return this.inst[0].getSampleRate();
    }

    public int getChannels() {
        return this.inst[0].getChannels();
    }

    public void externalAction(Object object, int n) {
    }

    public synchronized void controlChange(float[] fArray, int n, boolean bl) {
    }

    public void instNote(Instrument instrument, long l) {
        Note note = null;
        double d = (double)l / this.size;
        double d2 = 60.0 / this.tempo;
        if (d > this.testpos - 0.001 && d < this.testpos + 0.001) {
            note = this.getNote().copy();
            note.setRhythmValue(note.getRhythmValue() * d2);
            note.setDuration(note.getDuration() * d2);
            this.testpos += note.getRhythmValue();
        } else {
            note = new Note(Integer.MIN_VALUE, this.testpos - d);
            note.setRhythmValue(note.getRhythmValue() * d2);
            note.setDuration(note.getRhythmValue());
        }
        instrument.renderNote(note, d);
    }

    public void start(double d, RTMixer rTMixer) {
        int n;
        for (n = 0; n < this.inst.length; ++n) {
            try {
                if (!this.inst[n].getInitialised()) {
                    this.inst[n].createChain();
                    this.inst[n].setInitialised(true);
                }
                this.inst[n].addAudioChainListener(rTMixer);
                continue;
            }
            catch (AOException aOException) {
                aOException.printStackTrace();
            }
        }
        for (n = 0; n < this.inst.length; ++n) {
            this.inst[n].start();
        }
    }

    public void pause() {
        for (int i = 0; i < this.inst.length; ++i) {
            this.inst[i].pause();
        }
    }

    public void unPause() {
        for (int i = 0; i < this.inst.length; ++i) {
            this.inst[i].unPause();
        }
    }

    public abstract Note getNote();
}

