/*
 * Decompiled with CFR 0.152.
 */
package jm.music.tools;

import java.util.Enumeration;
import java.util.Vector;
import jm.JMC;
import jm.music.data.CPhrase;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;

public class Mod
implements JMC {
    private Mod() {
    }

    public static void append(Note note, Note note2) {
        try {
            if (note == null || note2 == null) {
                new NullPointerException();
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        note.setRhythmValue(note.getRhythmValue() + note2.getRhythmValue());
        note.setDuration(note.getDuration() + note2.getDuration());
    }

    public static void transpose(Note note, int n) {
        try {
            if (note == null) {
                new NullPointerException();
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        if (!note.getPitchType() && note.getPitch() != Integer.MIN_VALUE) {
            note.setPitch(note.getPitch() + n);
        }
        if (note.getPitchType()) {
            System.err.println("jMusic Mod transpose: No action taken - notes with frequency values cannot yet be transposed.");
        }
    }

    public static void transpose(Note note, int n, int[] nArray, int n2) {
        try {
            if (note == null) {
                new NullPointerException();
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        int n3 = note.getPitch();
        if (n3 != Integer.MIN_VALUE) {
            int n4;
            int n5 = n3 / 12;
            int n6 = 0;
            Note note2 = note.copy();
            while (!note2.isScale(nArray)) {
                note2.setPitch(note2.getPitch() - 1);
                ++n6;
            }
            int n7 = 0;
            for (n4 = 0; n4 < nArray.length; ++n4) {
                if (n3 % 12 - n6 != nArray[n4]) continue;
                n7 = n4;
                n4 = nArray.length;
            }
            for (n4 = n7 + n; n4 >= nArray.length; n4 -= nArray.length) {
                ++n5;
            }
            while (n4 < 0) {
                --n5;
                n4 += nArray.length;
            }
            note.setPitch(nArray[n4] + n5 * 12 + n6);
        }
    }

    public static final void crescendo(Phrase phrase, double d, double d2, int n, int n2) {
        double d3 = n2 - n;
        double d4 = d2 - d;
        if (d4 == 0.0) {
            return;
        }
        double d5 = 0.0;
        Vector vector = phrase.getNoteList();
        for (int i = 0; i < vector.size(); ++i) {
            Note note = (Note)vector.elementAt(i);
            if (d5 >= d) {
                note.setDynamic((int)((d5 - d) / d4 * d3 + (double)n));
            }
            if ((d5 += note.getRhythmValue()) > d2) break;
        }
    }

    public static final void diminuendo(Phrase phrase, double d, double d2, int n, int n2) {
        Mod.crescendo(phrase, d, d2, n, n2);
    }

    public static final void decrescendo(Phrase phrase, double d, double d2, int n, int n2) {
        Mod.crescendo(phrase, d, d2, n, n2);
    }

    public static void transpose(Phrase phrase, int n) {
        try {
            if (phrase == null) {
                new NullPointerException();
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        Vector vector = phrase.getNoteList();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Note note = (Note)enumeration.nextElement();
            if (note.getPitch() == Integer.MIN_VALUE) continue;
            note.setPitch(note.getPitch() + n);
        }
        phrase.setNoteList(vector);
    }

    public static void transpose(Phrase phrase, int n, int[] nArray, int n2) {
        try {
            if (phrase == null) {
                new NullPointerException();
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        int n3 = n2 % 12;
        Vector vector = phrase.getNoteList();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Note note = (Note)enumeration.nextElement();
            Mod.transpose(note, n, nArray, n2);
        }
        phrase.setNoteList(vector);
    }

    public static void repeat(Phrase phrase) {
        Mod.repeat(phrase, 2);
    }

    public static void repeat(Phrase phrase, int n) {
        try {
            if (phrase == null) {
                new NullPointerException();
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        int n2 = phrase.size();
        for (int i = 0; i < n - 1; ++i) {
            for (int j = 0; j < n2; ++j) {
                phrase.addNote(phrase.getNote(j).copy());
            }
        }
    }

    public static void repeat(Phrase phrase, double d, double d2) {
        Mod.repeat(phrase, 2, d, d2);
    }

    public static void repeat(Phrase phrase, int n, double d, double d2) {
        int n2;
        int n3;
        if (phrase == null) {
            System.err.println("phrase is null");
            return;
        }
        if (d >= d2) {
            System.err.println("startlocation is bigger or equal to end location");
            return;
        }
        if (n < 2) {
            System.err.println("times is smaller than 2");
            return;
        }
        if (d < 0.0) {
            System.err.println("startLoc is smaller than 0");
            return;
        }
        Phrase phrase2 = phrase.copy(d, d2);
        Phrase phrase3 = new Phrase();
        boolean bl = false;
        int n4 = 0;
        boolean bl2 = false;
        double d3 = phrase.getStartTime() < 0.0 ? 0.0 : phrase.getStartTime();
        for (n3 = 0; n3 < phrase.size() && d3 + phrase.getNote(n3).getRhythmValue() <= d2; ++n3) {
            phrase3.addNote(phrase.getNote(n3));
            if (d3 < d && d3 + phrase.getNote(n3).getRhythmValue() > d) {
                bl = true;
                n4 = n3;
            }
            d3 += phrase.getNote(n3).getRhythmValue();
        }
        if (n3 + 1 < phrase.size() && d3 < d2 && d3 + phrase.getNote(n3 + 1).getRhythmValue() > d2) {
            bl2 = true;
            Note note = phrase.getNote(n3).copy();
            note.setDuration(note.getDuration() * d2 - d3 / note.getRhythmValue());
            note.setRhythmValue(d2 - d3);
            phrase3.addNote(note);
        }
        boolean bl3 = false;
        for (n2 = 0; n2 < n - 1; ++n2) {
            for (int i = 0; i < phrase2.size(); ++i) {
                if (bl3) continue;
                phrase3.addNote(phrase2.getNote(i));
            }
        }
        if (bl2) {
            phrase3.removeLastNote();
        }
        for (n2 = n3; n2 < phrase.size(); ++n2) {
            phrase3.addNote(phrase.getNote(n2));
        }
        phrase.setNoteList(phrase3.getNoteList());
    }

    public static void increaseDynamic(Phrase phrase, int n) {
        try {
            if (phrase == null) {
                new NullPointerException();
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.toString();
            return;
        }
        Enumeration enumeration = phrase.getNoteList().elements();
        while (enumeration.hasMoreElements()) {
            Note note = (Note)enumeration.nextElement();
            note.setDynamic(note.getDynamic() + n);
        }
    }

    public static void fadeIn(Phrase phrase, double d) {
        Note note;
        if (phrase == null || d <= 0.0) {
            return;
        }
        Enumeration enumeration = phrase.getNoteList().elements();
        for (double d2 = 0.0; enumeration.hasMoreElements() && !(d2 > d); d2 += note.getRhythmValue()) {
            note = (Note)enumeration.nextElement();
            double d3 = d2 / d;
            int n = (int)((double)note.getDynamic() * d3);
            if (n == 0) {
                n = 1;
            }
            note.setDynamic(n);
        }
    }

    public static void fadeIn(Phrase phrase, double d, double d2) {
        Note note;
        if (phrase == null || d <= 0.0 || d2 < 0.0) {
            return;
        }
        Enumeration enumeration = phrase.getNoteList().elements();
        for (double d3 = d2; enumeration.hasMoreElements() && !(d3 >= d); d3 += note.getRhythmValue()) {
            note = (Note)enumeration.nextElement();
            double d4 = d3 / d;
            int n = (int)((double)note.getDynamic() * d4);
            if (n == 0) {
                n = 1;
            }
            note.setDynamic(n);
        }
    }

    public static void fadeOut(Phrase phrase, double d) {
        if (phrase == null || d <= 0.0) {
            return;
        }
        double d2 = 0.0;
        int n = phrase.size() - 1;
        for (int i = 0; i <= n; ++i) {
            Note note = (Note)phrase.getNoteList().elementAt(n - i);
            if (d2 > d) break;
            double d3 = d2 / d;
            int n2 = (int)((double)note.getDynamic() * d3);
            if (n2 == 0) {
                n2 = 1;
            }
            note.setDynamic(n2);
            d2 += note.getRhythmValue();
        }
    }

    public static void fadeOut(Phrase phrase, double d, double d2) {
        if (phrase == null || d <= 0.0 || d2 < 0.0) {
            return;
        }
        double d3 = d2;
        int n = phrase.size() - 1;
        for (int i = 0; i <= n; ++i) {
            Note note = (Note)phrase.getNoteList().elementAt(n - i);
            if (d3 >= d) break;
            double d4 = d3 / d;
            int n2 = (int)((double)note.getDynamic() * d4);
            if (n2 == 0) {
                n2 = 1;
            }
            note.setDynamic(n2);
            d3 += note.getRhythmValue();
        }
    }

    public static void compress(Phrase phrase, double d) {
        int n;
        Note note;
        if (phrase == null) {
            return;
        }
        Enumeration enumeration = phrase.getNoteList().elements();
        int n2 = 0;
        int n3 = 127;
        while (enumeration.hasMoreElements()) {
            note = (Note)enumeration.nextElement();
            if (note.getPitch() == Integer.MIN_VALUE) continue;
            n = note.getDynamic();
            if (n > n2) {
                n2 = n;
            }
            if (n >= n3) continue;
            n3 = n;
        }
        int n4 = (n3 + n2) / 2;
        enumeration = phrase.getNoteList().elements();
        while (enumeration.hasMoreElements()) {
            note = (Note)enumeration.nextElement();
            n = (int)((double)n4 + (double)(note.getDynamic() - n4) * d);
            note.setDynamic(n);
        }
    }

    public static void append(Phrase phrase, Phrase phrase2) {
        if (phrase == null || phrase2 == null) {
            return;
        }
        Enumeration enumeration = phrase2.getNoteList().elements();
        while (enumeration.hasMoreElements()) {
            phrase.addNote(((Note)enumeration.nextElement()).copy());
        }
    }

    public static void quantize(Phrase phrase, double d) {
        Mod.quantise(phrase, d);
    }

    public static void quantise(Phrase phrase, double d) {
        if (phrase == null || d <= 0.0) {
            return;
        }
        Enumeration enumeration = phrase.getNoteList().elements();
        while (enumeration.hasMoreElements()) {
            Note note = (Note)enumeration.nextElement();
            double d2 = note.getRhythmValue();
            if (d2 % d < d / 2.0) {
                note.setRhythmValue((double)((int)(d2 / d)) * d);
                continue;
            }
            note.setRhythmValue((double)((int)(d2 / d + 1.0)) * d);
        }
    }

    public static void cycle(Phrase phrase, int n) {
        if (phrase == null) {
            return;
        }
        int n2 = phrase.size();
        if (n <= n2) {
            return;
        }
        Phrase phrase2 = new Phrase();
        for (int i = 0; i < n; ++i) {
            phrase2.addNote(phrase.getNote(i % n2).copy());
        }
        phrase.getNoteList().removeAllElements();
        Enumeration enumeration = phrase2.getNoteList().elements();
        while (enumeration.hasMoreElements()) {
            phrase.getNoteList().addElement(enumeration.nextElement());
        }
    }

    public static void cycle(Phrase phrase, double d) {
        if (phrase == null || d <= phrase.getEndTime()) {
            return;
        }
        int n = phrase.size();
        Phrase phrase2 = new Phrase();
        int n2 = 0;
        while (phrase2.getEndTime() < d) {
            phrase2.addNote(phrase.getNote(n2 % n).copy());
            ++n2;
        }
        phrase.getNoteList().removeAllElements();
        Enumeration enumeration = phrase2.getNoteList().elements();
        while (enumeration.hasMoreElements()) {
            phrase.getNoteList().addElement(enumeration.nextElement());
        }
    }

    public static void shuffle(Phrase phrase) {
        if (phrase == null) {
            return;
        }
        Phrase phrase2 = new Phrase();
        phrase2.addNote(phrase.getNote((int)(Math.random() * (double)phrase.size())));
        int n = 0;
        while (n < phrase.size() - 1) {
            Note note = phrase.getNote((int)(Math.random() * (double)phrase.size()));
            boolean bl = true;
            for (int i = 0; i < phrase2.size(); ++i) {
                if (note != phrase2.getNote(i)) continue;
                bl = false;
            }
            if (!bl) continue;
            phrase2.addNote(note);
            ++n;
        }
        phrase.getNoteList().removeAllElements();
        Enumeration enumeration = phrase2.getNoteList().elements();
        while (enumeration.hasMoreElements()) {
            phrase.getNoteList().addElement(enumeration.nextElement());
        }
    }

    public static void palindrome(Phrase phrase) {
        Mod.palindrome(phrase, true);
    }

    public static void palindrome(Phrase phrase, boolean bl) {
        if (phrase == null) {
            return;
        }
        int n = bl ? phrase.size() : phrase.size() - 1;
        for (int i = n - 1; i >= 0; --i) {
            phrase.addNote(phrase.getNote(i));
        }
    }

    public static void rotate(Phrase phrase) {
        Mod.rotate(phrase, 1);
    }

    public static void rotate(Phrase phrase, int n) {
        if (phrase == null) {
            return;
        }
        Vector vector = phrase.getNoteList();
        for (int i = 0; i < n; ++i) {
            vector.insertElementAt(vector.lastElement(), 0);
            vector.removeElementAt(vector.size() - 1);
        }
    }

    public static void retrograde(Phrase phrase) {
        if (phrase == null) {
            return;
        }
        Phrase phrase2 = new Phrase();
        for (int i = phrase.size(); i > 0; --i) {
            phrase2.addNote(phrase.getNote(i - 1));
        }
        phrase.getNoteList().removeAllElements();
        Enumeration enumeration = phrase2.getNoteList().elements();
        while (enumeration.hasMoreElements()) {
            phrase.getNoteList().addElement(enumeration.nextElement());
        }
    }

    public static void inversion(Phrase phrase) {
        if (phrase == null) {
            return;
        }
        int n = 0;
        int n2 = Integer.MIN_VALUE;
        while (n < phrase.size() && n2 == Integer.MIN_VALUE) {
            n2 = phrase.getNote(n++).getPitch();
        }
        while (n < phrase.size()) {
            phrase.getNote(n).setPitch(n2 - (phrase.getNote(n).getPitch() - n2));
            ++n;
        }
    }

    public static void changeLength(Phrase phrase, double d) {
        if (phrase == null || d <= 0.0) {
            return;
        }
        double d2 = phrase.getEndTime() - phrase.getStartTime();
        Mod.elongate(phrase, d / d2);
    }

    public static void elongate(Phrase phrase, double d) {
        if (phrase == null || d <= 0.0) {
            return;
        }
        Enumeration enumeration = phrase.getNoteList().elements();
        while (enumeration.hasMoreElements()) {
            Note note = (Note)enumeration.nextElement();
            note.setRhythmValue(note.getRhythmValue() * d);
            note.setDuration(note.getDuration() * d);
        }
    }

    public static void accents(Phrase phrase, double d) {
        double[] dArray = new double[]{0.0};
        Mod.accents(phrase, d, dArray);
    }

    public static void accents(Phrase phrase, double d, double[] dArray) {
        Mod.accents(phrase, d, dArray, 20);
    }

    public static void accents(Phrase phrase, double d, double[] dArray, int n) {
        if (phrase == null || d <= 0.0) {
            return;
        }
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] < 0.0) && !(dArray[i] >= d)) continue;
            return;
        }
        double d2 = phrase.getStartTime() < 0.0 ? 0.0 : phrase.getStartTime();
        Vector vector = phrase.getNoteList();
        for (int i = 0; i < vector.size(); ++i) {
            Note note = (Note)vector.elementAt(i);
            for (int j = 0; j < dArray.length; ++j) {
                if (d2 % d != dArray[j]) continue;
                int n2 = note.getDynamic();
                note.setDynamic(n2 += n);
            }
            d2 += note.getRhythmValue();
        }
    }

    public static void normalise(Phrase phrase) {
        if (phrase == null) {
            return;
        }
        int n = 0;
        Enumeration enumeration = phrase.getNoteList().elements();
        while (enumeration.hasMoreElements()) {
            Note note = (Note)enumeration.nextElement();
            if (note.getDynamic() <= n) continue;
            n = note.getDynamic();
        }
        if (n == 127) {
            return;
        }
        int n2 = 127 - n;
        Enumeration enumeration2 = phrase.getNoteList().elements();
        while (enumeration2.hasMoreElements()) {
            Note note = (Note)enumeration2.nextElement();
            note.setDynamic(note.getDynamic() + n2);
        }
    }

    public static void shake(Phrase phrase) {
        Mod.shake(phrase, 20);
    }

    public static void shake(Phrase phrase, int n) {
        if (phrase == null) {
            return;
        }
        Enumeration enumeration = phrase.getNoteList().elements();
        while (enumeration.hasMoreElements()) {
            int n2;
            Note note = (Note)enumeration.nextElement();
            int n3 = note.getDynamic();
            while ((n2 = n3 + (int)(Math.random() * 2.0 * (double)n - (double)n)) < 0 || n2 > 127) {
            }
            note.setDynamic(n2);
        }
    }

    public static void mutate(Phrase phrase) {
        Mod.mutate(phrase, 1, 1, CHROMATIC_SCALE, phrase.getLowestPitch(), phrase.getHighestPitch(), new double[]{0.25, 0.5, 1.0, 1.5, 2.0});
    }

    public static void mutate(Phrase phrase, int n, int[] nArray) {
        Mod.mutate(phrase, 1, 0, nArray, phrase.getLowestPitch(), phrase.getHighestPitch(), new double[0]);
    }

    public static void mutate(Phrase phrase, int n, int n2, int[] nArray, int n3, int n4, double[] dArray) {
        Note note;
        int n5;
        for (n5 = 0; n5 < n; ++n5) {
            int n6 = (int)(Math.random() * (double)(n4 - n3) + (double)n3);
            int n7 = (int)(Math.random() * (double)phrase.size());
            note = phrase.getNote(n7);
            note.setPitch(n6);
            while (!note.isScale(nArray)) {
                n6 = (int)(Math.random() * (double)(n4 - n3) + (double)n3);
                n7 = (int)(Math.random() * (double)phrase.size());
                note = phrase.getNote(n7);
            }
        }
        for (n5 = 0; n5 < n2; ++n5) {
            double d = dArray[(int)(Math.random() * (double)dArray.length)];
            note = phrase.getNote((int)(Math.random() * (double)phrase.size()));
            note.setRhythmValue(d);
            note.setDuration(d * 0.9);
        }
    }

    public static void tiePitches(Phrase phrase) {
        int n = 0;
        while (n < phrase.size() - 1) {
            Note note = phrase.getNote(n);
            Note note2 = phrase.getNote(n + 1);
            if (note.getPitch() == note2.getPitch()) {
                note.setRhythmValue(note.getRhythmValue() + note2.getRhythmValue());
                note.setDuration(note.getDuration() + note2.getDuration());
                phrase.removeNote(n + 1);
                continue;
            }
            ++n;
        }
    }

    public static void tieRests(Phrase phrase) {
        int n = 0;
        while (n < phrase.size() - 1) {
            Note note = phrase.getNote(n);
            Note note2 = phrase.getNote(n + 1);
            if (note.getPitch() == Integer.MIN_VALUE && note2.getPitch() == Integer.MIN_VALUE) {
                note.setRhythmValue(note.getRhythmValue() + note2.getRhythmValue());
                note.setDuration(note.getDuration() + note2.getDuration());
                phrase.removeNote(n + 1);
                continue;
            }
            ++n;
        }
    }

    public static void fillRests(Phrase phrase) {
        int n = 0;
        while (n < phrase.size() - 1) {
            Note note = phrase.getNote(n);
            Note note2 = phrase.getNote(n + 1);
            if (note.getPitch() != Integer.MIN_VALUE && note2.getPitch() == Integer.MIN_VALUE) {
                note.setRhythmValue(note.getRhythmValue() + note2.getRhythmValue());
                note.setDuration(note.getDuration() + note2.getDuration());
                phrase.removeNote(n + 1);
                continue;
            }
            ++n;
        }
    }

    public static void spread(Phrase phrase) {
        if (phrase == null) {
            return;
        }
        Enumeration enumeration = phrase.getNoteList().elements();
        while (enumeration.hasMoreElements()) {
            Note note = (Note)enumeration.nextElement();
            note.setPan(Math.random());
        }
    }

    public static void bounce(Phrase phrase) {
        if (phrase == null) {
            return;
        }
        boolean bl = true;
        Enumeration enumeration = phrase.getNoteList().elements();
        while (enumeration.hasMoreElements()) {
            Note note = (Note)enumeration.nextElement();
            if (bl) {
                note.setPan(0.0);
            } else {
                note.setPan(1.0);
            }
            bl = !bl;
        }
    }

    public static void varyLength(Phrase phrase, double d, double d2) {
        if (phrase == null || d2 < d) {
            return;
        }
        Enumeration enumeration = phrase.getNoteList().elements();
        while (enumeration.hasMoreElements()) {
            Note note = (Note)enumeration.nextElement();
            double d3 = Math.random() * (d2 - d) + d;
            note.setDuration(d3);
        }
    }

    public static void randomize(Phrase phrase, int n) {
        Mod.randomize(phrase, n, 0.0);
    }

    public static void randomize(Phrase phrase, int n, double d) {
        Mod.randomize(phrase, n, d, 0);
    }

    public static void randomize(Phrase phrase, int n, double d, int n2) {
        if (phrase == null) {
            return;
        }
        boolean bl = true;
        Enumeration enumeration = phrase.getNoteList().elements();
        while (enumeration.hasMoreElements()) {
            Note note = (Note)enumeration.nextElement();
            if (n > 0) {
                note.setPitch(note.getPitch() + (int)(Math.random() * (double)(n * 2) - (double)n));
            }
            if (d > 0.0) {
                double d2 = Math.random() * (d * 2.0) - d;
                note.setRhythmValue(note.getRhythmValue() + d2);
                note.setDuration(note.getDuration() + d2);
            }
            if (n2 <= 0) continue;
            note.setDynamic(note.getDynamic() + (int)(Math.random() * (double)(n2 * 2) - (double)n2));
        }
    }

    public static void slurUp(Phrase phrase) {
        Mod.slurUp(phrase, 2);
    }

    public static void slurDown(Phrase phrase) {
        Mod.slurDown(phrase, 2);
    }

    public static void slurUp(Phrase phrase, int n) {
        if (phrase == null || phrase.size() < n || n < 2) {
            System.err.println("jMusic Mod.slurUp error: Arguments not valid.");
            return;
        }
        boolean bl = false;
        int n2 = phrase.size() - n;
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            for (n4 = 0; n4 < n - 1; ++n4) {
                if (phrase.getNote(n3 + n4).getPitch() < 0 || phrase.getNote(n3 + n4).getPitch() >= phrase.getNote(n3 + n4 + 1).getPitch()) {
                    bl = false;
                    break;
                }
                bl = true;
            }
            if (bl) {
                for (n4 = 0; n4 < n - 1; ++n4) {
                    phrase.getNote(n3 + n4).setDuration(phrase.getNote(n3 + n4).getRhythmValue());
                }
                n3 += n - 1;
            } else {
                ++n3;
            }
            bl = false;
        }
    }

    public static void slurDown(Phrase phrase, int n) {
        if (phrase == null || phrase.size() < n || n < 2) {
            System.err.println("jMusic Mod.slurDown error: Arguments not valid.");
            return;
        }
        boolean bl = false;
        int n2 = phrase.size() - n;
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            for (n4 = 0; n4 < n - 1; ++n4) {
                if (phrase.getNote(n3 + n4).getPitch() < 0 || phrase.getNote(n3 + n4).getPitch() <= phrase.getNote(n3 + n4 + 1).getPitch()) {
                    bl = false;
                    break;
                }
                bl = true;
            }
            if (bl) {
                for (n4 = 0; n4 < n - 1; ++n4) {
                    phrase.getNote(n3 + n4).setDuration(phrase.getNote(n3 + n4).getRhythmValue());
                }
                n3 += n - 1;
            } else {
                ++n3;
            }
            bl = false;
        }
    }

    public static void increaseDuration(Phrase phrase, double d) {
        Enumeration enumeration = phrase.getNoteList().elements();
        while (enumeration.hasMoreElements()) {
            Note note = (Note)enumeration.nextElement();
            note.setDuration(note.getDuration() * d);
        }
    }

    public static void addToDuration(Phrase phrase, double d) {
        Enumeration enumeration = phrase.getNoteList().elements();
        while (enumeration.hasMoreElements()) {
            Note note = (Note)enumeration.nextElement();
            note.setDuration(note.getDuration() + d);
        }
    }

    public static void addToRhythmValue(Phrase phrase, double d) {
        Enumeration enumeration = phrase.getNoteList().elements();
        while (enumeration.hasMoreElements()) {
            Note note = (Note)enumeration.nextElement();
            note.setRhythmValue(note.getRhythmValue() + d);
        }
    }

    public static void addToLength(Phrase phrase, double d) {
        Enumeration enumeration = phrase.getNoteList().elements();
        double d2 = 0.0;
        while (enumeration.hasMoreElements()) {
            Note note = (Note)enumeration.nextElement();
            d2 = note.getRhythmValue() / note.getDuration();
            note.setRhythmValue(note.getRhythmValue() + d);
            note.setDuration(note.getRhythmValue() * d2);
        }
    }

    public static void expandIntervals(Phrase phrase, double d) {
        int n = phrase.size();
        if (n < 2) {
            return;
        }
        Note note = phrase.getNote(0);
        for (int i = 1; i < n; ++i) {
            Note note2 = phrase.getNote(i);
            int n2 = (int)((double)(note2.getPitch() - note.getPitch()) * d);
            note2.setPitch(note2.getPitch() + n2);
        }
    }

    public static void transpose(CPhrase cPhrase, int n) {
        if (cPhrase == null) {
            return;
        }
        Enumeration enumeration = cPhrase.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Mod.transpose((Phrase)enumeration.nextElement(), n);
        }
    }

    public static void transpose(CPhrase cPhrase, int n, int[] nArray, int n2) {
        if (cPhrase == null) {
            return;
        }
        Enumeration enumeration = cPhrase.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Mod.transpose((Phrase)enumeration.nextElement(), n, nArray, n2);
        }
    }

    public static void repeat(CPhrase cPhrase) {
        Mod.repeat(cPhrase, 2);
    }

    public static void repeat(CPhrase cPhrase, int n) {
        if (cPhrase == null) {
            return;
        }
        int n2 = cPhrase.getPhraseList().size();
        for (int i = 0; i < n - 1; ++i) {
            double d = cPhrase.getEndTime();
            for (int j = 0; j < n2; ++j) {
                Phrase phrase = (Phrase)cPhrase.getPhraseList().elementAt(j);
                Phrase phrase2 = phrase.copy();
                phrase2.setStartTime(d + phrase.getStartTime());
                cPhrase.addPhrase(phrase2);
            }
        }
    }

    public static void repeat(CPhrase cPhrase, double d, double d2) {
        Mod.repeat(cPhrase, 2, d, d2);
    }

    public static void repeat(CPhrase cPhrase, int n, double d, double d2) {
        if (cPhrase == null || d >= d2 || n < 2) {
            return;
        }
        Enumeration enumeration = cPhrase.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.repeat(phrase, n, d - cPhrase.getStartTime(), d2 - cPhrase.getStartTime());
        }
    }

    public static void fadeIn(CPhrase cPhrase, double d) {
        if (cPhrase == null || d <= 0.0) {
            return;
        }
        Enumeration enumeration = cPhrase.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.fadeIn(phrase, d, phrase.getStartTime());
        }
    }

    public static void fadeIn(CPhrase cPhrase, double d, double d2) {
        if (cPhrase == null || d < 0.0 || d2 < 0.0 || d <= d2) {
            return;
        }
        Enumeration enumeration = cPhrase.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.fadeIn(phrase, d, d2 + phrase.getStartTime());
        }
    }

    public static void fadeOut(CPhrase cPhrase, double d) {
        if (cPhrase == null || d <= 0.0) {
            return;
        }
        Enumeration enumeration = cPhrase.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.fadeOut(phrase, d, cPhrase.getEndTime() - phrase.getEndTime());
        }
    }

    public static void fadeOut(CPhrase cPhrase, double d, double d2) {
        Enumeration enumeration = cPhrase.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.fadeOut(phrase, d, d2 + cPhrase.getEndTime() - phrase.getEndTime());
        }
    }

    public static void compress(CPhrase cPhrase, double d) {
        if (cPhrase == null) {
            return;
        }
        Enumeration enumeration = cPhrase.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Mod.compress((Phrase)enumeration.nextElement(), d);
        }
    }

    public static void append(CPhrase cPhrase, CPhrase cPhrase2) {
        if (cPhrase == null || cPhrase2 == null) {
            return;
        }
        double d = cPhrase.getEndTime();
        Enumeration enumeration = cPhrase2.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            phrase.setStartTime(d + phrase.getStartTime());
            cPhrase.addPhrase(phrase);
        }
    }

    public static void merge(CPhrase cPhrase, CPhrase cPhrase2) {
        if (cPhrase == null || cPhrase2 == null) {
            return;
        }
        Enumeration enumeration = cPhrase2.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            cPhrase.addPhrase((Phrase)enumeration.nextElement());
        }
    }

    public static void quantize(CPhrase cPhrase, double d) {
        Mod.quantise(cPhrase, d);
    }

    public static void quantise(CPhrase cPhrase, double d) {
        if (cPhrase == null || d <= 0.0) {
            return;
        }
        Enumeration enumeration = cPhrase.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Mod.quantise((Phrase)enumeration.nextElement(), d);
        }
    }

    public static void shuffle(CPhrase cPhrase) {
        Enumeration enumeration = cPhrase.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Mod.shuffle((Phrase)enumeration.nextElement());
        }
    }

    public static void cycle(Part part, double d) {
        if (part == null || d <= 0.0 || d == part.getEndTime()) {
            return;
        }
        double d2 = part.getEndTime();
        if (d < d2) {
            Part part2 = part.copy(0.0, d);
            part.empty();
            part.addPhraseList(part2.getPhraseArray());
            return;
        }
        int n = 1;
        double d3 = d;
        d3 = d;
        while ((int)(d3 / d2) > 1) {
            Phrase[] phraseArray = part.getPhraseArray();
            for (int i = 0; i < phraseArray.length; ++i) {
                phraseArray[i].setStartTime(phraseArray[i].getStartTime() + (double)n * d2);
                part.addPhrase(phraseArray[i]);
            }
            ++n;
            d3 -= d2;
        }
        double d4 = d - (double)n * d2;
        if (d4 > 0.0) {
            Part part3 = part.copy(0.0, d4, true, true, false);
            Phrase[] phraseArray = part3.getPhraseArray();
            for (int i = 0; i < phraseArray.length; ++i) {
                phraseArray[i].setStartTime(phraseArray[i].getStartTime() + (double)n * d2);
                part.addPhrase(phraseArray[i]);
            }
        }
    }

    public static void elongate(CPhrase cPhrase, double d) {
        if (cPhrase == null || d <= 0.0) {
            return;
        }
        Enumeration enumeration = cPhrase.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.elongate(phrase, d);
            phrase.setStartTime(phrase.getStartTime() * d);
        }
    }

    public static void accents(CPhrase cPhrase, double d) {
        double[] dArray = new double[]{0.0};
        Mod.accents(cPhrase, d, dArray);
    }

    public static void accents(CPhrase cPhrase, double d, double[] dArray) {
        Mod.accents(cPhrase, d, dArray, 20);
    }

    public static void accents(CPhrase cPhrase, double d, double[] dArray, int n) {
        if (cPhrase == null || d <= 0.0) {
            return;
        }
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] < 0.0) && !(dArray[i] >= d)) continue;
            return;
        }
        Enumeration enumeration = cPhrase.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.accents(phrase, d, dArray, n);
        }
    }

    public static void normalise(CPhrase cPhrase) {
        Cloneable cloneable;
        Enumeration enumeration;
        if (cPhrase == null) {
            return;
        }
        int n = 0;
        Enumeration enumeration2 = cPhrase.getPhraseList().elements();
        while (enumeration2.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration2.nextElement();
            enumeration = phrase.getNoteList().elements();
            while (enumeration.hasMoreElements()) {
                cloneable = (Note)enumeration.nextElement();
                if (((Note)cloneable).getDynamic() <= n) continue;
                n = ((Note)cloneable).getDynamic();
            }
        }
        if (n == 127) {
            return;
        }
        int n2 = 127 - n;
        enumeration = cPhrase.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            cloneable = (Phrase)enumeration.nextElement();
            Enumeration enumeration3 = ((Phrase)cloneable).getNoteList().elements();
            while (enumeration3.hasMoreElements()) {
                Note note = (Note)enumeration3.nextElement();
                note.setDynamic(note.getDynamic() + n2);
            }
        }
    }

    public static void spread(CPhrase cPhrase) {
        if (cPhrase == null) {
            return;
        }
        Enumeration enumeration = cPhrase.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.spread(phrase);
        }
    }

    public static void bounce(CPhrase cPhrase) {
        if (cPhrase == null) {
            return;
        }
        Enumeration enumeration = cPhrase.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.bounce(phrase);
        }
    }

    public static void tiePitches(CPhrase cPhrase) {
        Enumeration enumeration = cPhrase.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.tiePitches(phrase);
        }
    }

    public static void tieRests(CPhrase cPhrase) {
        Enumeration enumeration = cPhrase.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.tieRests(phrase);
        }
    }

    public static void fillRests(CPhrase cPhrase) {
        Enumeration enumeration = cPhrase.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.fillRests(phrase);
        }
    }

    public static void varyLength(CPhrase cPhrase, double d, double d2) {
        if (cPhrase == null || d2 < d) {
            return;
        }
        Enumeration enumeration = cPhrase.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.varyLength(phrase, d, d2);
        }
    }

    public static void randomize(CPhrase cPhrase, int n) {
        Mod.randomize(cPhrase, n, 0.0);
    }

    public static void randomize(CPhrase cPhrase, int n, double d) {
        Mod.randomize(cPhrase, n, d, 0);
    }

    public static void randomize(CPhrase cPhrase, int n, double d, int n2) {
        if (cPhrase == null) {
            return;
        }
        boolean bl = true;
        Enumeration enumeration = cPhrase.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.randomize(phrase, n, d, n2);
        }
    }

    public static void slurUp(CPhrase cPhrase, int n) {
        if (cPhrase == null) {
            return;
        }
        Enumeration enumeration = cPhrase.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.slurUp(phrase, n);
        }
    }

    public static void slurDown(CPhrase cPhrase, int n) {
        if (cPhrase == null) {
            return;
        }
        Enumeration enumeration = cPhrase.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.slurDown(phrase, n);
        }
    }

    public static void increaseDuration(CPhrase cPhrase, double d) {
        Enumeration enumeration = cPhrase.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.increaseDuration(phrase, d);
        }
    }

    public static void addToDuration(CPhrase cPhrase, double d) {
        Enumeration enumeration = cPhrase.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.addToDuration(phrase, d);
        }
    }

    public static void addToRhythmValue(CPhrase cPhrase, double d) {
        Enumeration enumeration = cPhrase.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.addToRhythmValue(phrase, d);
        }
    }

    public static void addToLength(CPhrase cPhrase, double d) {
        Enumeration enumeration = cPhrase.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.addToLength(phrase, d);
        }
    }

    public static void expandIntervals(CPhrase cPhrase, double d) {
        Enumeration enumeration = cPhrase.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.expandIntervals(phrase, d);
        }
    }

    public static void shake(CPhrase cPhrase, int n) {
        Enumeration enumeration = cPhrase.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.shake(phrase, n);
        }
    }

    public static void repeat(Part part) {
        Mod.repeat(part, 2);
    }

    public static void repeat(Part part, int n) {
        if (part == null) {
            return;
        }
        Enumeration enumeration = part.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.repeat(phrase, n);
        }
    }

    public static void repeat(Part part, double d, double d2) {
        Mod.repeat(part, 2, d, d2);
    }

    public static void repeat(Part part, int n, double d, double d2) {
        if (part == null || d >= d2 || n < 2) {
            return;
        }
        Enumeration enumeration = part.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.repeat(phrase, n, d, d2);
        }
    }

    public static void transpose(Part part, int n) {
        if (part == null || n == 0) {
            return;
        }
        Enumeration enumeration = part.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.transpose(phrase, n);
        }
    }

    public static void transpose(Part part, int n, int[] nArray, int n2) {
        if (part == null) {
            return;
        }
        Enumeration enumeration = part.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Mod.transpose((Phrase)enumeration.nextElement(), n, nArray, n2);
        }
    }

    public static void compress(Part part, double d) {
        if (part == null) {
            return;
        }
        Enumeration enumeration = part.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.compress(phrase, d);
        }
    }

    public static void append(Part part, Part part2) {
        Mod.append(part, part2, part.getEndTime());
    }

    public static void append(Part part, Part part2, double d) {
        if (part == null || part2 == null) {
            return;
        }
        Enumeration enumeration = part2.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = ((Phrase)enumeration.nextElement()).copy();
            phrase.setStartTime(d + phrase.getStartTime());
            if (phrase.getInstrument() == part.getInstrument()) {
                phrase.setInstrument(-1);
            }
            part.addPhrase(phrase);
        }
    }

    public static void increaseDynamic(Part part, int n) {
        try {
            if (part == null) {
                new NullPointerException();
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.toString();
            return;
        }
        Enumeration enumeration = part.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.increaseDynamic(phrase, n);
        }
    }

    public static void fadeIn(Part part, double d) {
        if (part == null || d <= 0.0) {
            return;
        }
        Enumeration enumeration = part.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.fadeIn(phrase, d, phrase.getStartTime());
        }
    }

    public static void fadeIn(Part part, double d, double d2) {
        if (part == null || d <= 0.0 || d2 < 0.0) {
            return;
        }
        Enumeration enumeration = part.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.fadeIn(phrase, d, d2 + phrase.getStartTime());
        }
    }

    public static void fadeOut(Part part, double d) {
        if (part == null || d <= 0.0) {
            return;
        }
        Enumeration enumeration = part.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.fadeOut(phrase, d, part.getEndTime() - phrase.getEndTime());
        }
    }

    public static void fadeOut(Part part, double d, double d2) {
        if (part == null || d <= 0.0 || d2 < 0.0) {
            return;
        }
        Enumeration enumeration = part.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.fadeOut(phrase, d, d2 + part.getEndTime() - phrase.getEndTime());
        }
    }

    public static void merge(Part part, Part part2) {
        if (part == null || part2 == null) {
            return;
        }
        Enumeration enumeration = part2.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            part.addPhrase((Phrase)enumeration.nextElement());
        }
    }

    public static void quantize(Part part, double d) {
        Mod.quantise(part, d);
    }

    public static void quantise(Part part, double d) {
        if (part == null || d <= 0.0) {
            return;
        }
        Enumeration enumeration = part.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.quantise(phrase, d);
        }
    }

    public static void shuffle(Part part) {
        Enumeration enumeration = part.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Mod.shuffle((Phrase)enumeration.nextElement());
        }
    }

    public static void accents(Part part, double d) {
        double[] dArray = new double[]{0.0};
        Mod.accents(part, d, dArray);
    }

    public static void accents(Part part, double d, double[] dArray) {
        Mod.accents(part, d, dArray, 20);
    }

    public static void accents(Part part, double d, double[] dArray, int n) {
        if (part == null || d <= 0.0) {
            return;
        }
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] < 0.0) && !(dArray[i] >= d)) continue;
            return;
        }
        Enumeration enumeration = part.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.accents(phrase, d, dArray, n);
        }
    }

    public static void normalise(Part part) {
        Cloneable cloneable;
        Enumeration enumeration;
        if (part == null) {
            return;
        }
        int n = 0;
        Enumeration enumeration2 = part.getPhraseList().elements();
        while (enumeration2.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration2.nextElement();
            enumeration = phrase.getNoteList().elements();
            while (enumeration.hasMoreElements()) {
                cloneable = (Note)enumeration.nextElement();
                if (((Note)cloneable).getDynamic() <= n) continue;
                n = ((Note)cloneable).getDynamic();
            }
        }
        if (n == 127) {
            return;
        }
        int n2 = 127 - n;
        enumeration = part.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            cloneable = (Phrase)enumeration.nextElement();
            Enumeration enumeration3 = ((Phrase)cloneable).getNoteList().elements();
            while (enumeration3.hasMoreElements()) {
                Note note = (Note)enumeration3.nextElement();
                note.setDynamic(note.getDynamic() + n2);
            }
        }
    }

    public static void elongate(Part part, double d) {
        if (part == null || d <= 0.0) {
            return;
        }
        Enumeration enumeration = part.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.elongate(phrase, d);
        }
    }

    public static void tiePitches(Part part) {
        Enumeration enumeration = part.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.tiePitches(phrase);
        }
    }

    public static void tieRests(Part part) {
        Enumeration enumeration = part.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.tieRests(phrase);
        }
    }

    public static void fillRests(Part part) {
        Enumeration enumeration = part.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.fillRests(phrase);
        }
    }

    public static void spread(Part part) {
        if (part == null) {
            return;
        }
        Enumeration enumeration = part.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.spread(phrase);
        }
    }

    public static void bounce(Part part) {
        if (part == null) {
            return;
        }
        Enumeration enumeration = part.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.bounce(phrase);
        }
    }

    public static void varyLength(Part part, double d, double d2) {
        if (part == null || d2 < d) {
            return;
        }
        Enumeration enumeration = part.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.varyLength(phrase, d, d2);
        }
    }

    public static void randomize(Part part, int n) {
        Mod.randomize(part, n, 0.0);
    }

    public static void randomize(Part part, int n, double d) {
        Mod.randomize(part, n, d, 0);
    }

    public static void randomize(Part part, int n, double d, int n2) {
        if (part == null) {
            return;
        }
        boolean bl = true;
        Enumeration enumeration = part.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.randomize(phrase, n, d, n2);
        }
    }

    public static void slurUp(Part part, int n) {
        if (part == null) {
            return;
        }
        Enumeration enumeration = part.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.slurUp(phrase, n);
        }
    }

    public static void slurDown(Part part, int n) {
        if (part == null) {
            return;
        }
        Enumeration enumeration = part.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.slurDown(phrase, n);
        }
    }

    public static void increaseDuration(Part part, double d) {
        Enumeration enumeration = part.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.increaseDuration(phrase, d);
        }
    }

    public static void addToDuration(Part part, double d) {
        Enumeration enumeration = part.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.addToDuration(phrase, d);
        }
    }

    public static void addToRhythmValue(Part part, double d) {
        Enumeration enumeration = part.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.addToRhythmValue(phrase, d);
        }
    }

    public static void addToLength(Part part, double d) {
        Enumeration enumeration = part.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.addToLength(phrase, d);
        }
    }

    public static void expandIntervals(Part part, double d) {
        Enumeration enumeration = part.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.expandIntervals(phrase, d);
        }
    }

    public static void shake(Part part, int n) {
        Enumeration enumeration = part.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            Mod.shake(phrase, n);
        }
    }

    public static void transpose(Score score, int n) {
        if (score == null || n == 0) {
            return;
        }
        Enumeration enumeration = score.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            Mod.transpose(part, n);
        }
    }

    public static void transpose(Score score, int n, int[] nArray, int n2) {
        if (score == null) {
            return;
        }
        Enumeration enumeration = score.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Mod.transpose((Part)enumeration.nextElement(), n, nArray, n2);
        }
    }

    public static void fadeIn(Score score, double d) {
        if (score == null || d <= 0.0) {
            return;
        }
        Enumeration enumeration = score.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            Mod.fadeIn(part, d);
        }
    }

    public static void increaseDynamic(Score score, int n) {
        try {
            if (score == null) {
                new NullPointerException();
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.toString();
            return;
        }
        Enumeration enumeration = score.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            Mod.increaseDynamic(part, n);
        }
    }

    public static void fadeOut(Score score, double d) {
        if (score == null || d <= 0.0) {
            return;
        }
        Enumeration enumeration = score.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            Mod.fadeOut(part, d, score.getEndTime() - part.getEndTime());
        }
    }

    public static void compress(Score score, double d) {
        if (score == null) {
            return;
        }
        Enumeration enumeration = score.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            Mod.compress(part, d);
        }
    }

    public static void repeat(Score score) {
        Mod.repeat(score, 2);
    }

    public static void repeat(Score score, int n) {
        if (score == null || n < 2) {
            return;
        }
        double d = 0.0;
        Enumeration enumeration = score.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            if (!(d < part.getEndTime())) continue;
            d = part.getEndTime();
        }
        for (int i = 0; i < score.getPartList().size(); ++i) {
            Part part = (Part)score.getPartList().elementAt(i);
            int n2 = part.getPhraseList().size();
            for (int j = 0; j < n - 1; ++j) {
                double d2 = d * (double)(j + 1);
                for (int k = 0; k < n2; ++k) {
                    Phrase phrase = (Phrase)part.getPhraseList().elementAt(k);
                    Phrase phrase2 = phrase.copy();
                    phrase2.setStartTime(d2 + phrase.getStartTime());
                    part.addPhrase(phrase2);
                }
            }
        }
    }

    public static void append(Score score, Score score2) {
        if (score == null || score2 == null) {
            return;
        }
        score2.clean();
        if (score2.size() == 0) {
            return;
        }
        double d = score.getEndTime();
        Enumeration enumeration = score2.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            Enumeration enumeration2 = part.getPhraseList().elements();
            while (enumeration2.hasMoreElements()) {
                Phrase phrase = (Phrase)enumeration2.nextElement();
                phrase.setStartTime(phrase.getStartTime() + d);
                if (phrase.getInstrument() != 250 && phrase.getInstrument() != part.getInstrument()) {
                    phrase.setInstrument(part.getInstrument());
                }
                if (phrase.getInstrument() != part.getInstrument()) continue;
                phrase.setInstrument(-1);
            }
        }
        Mod.merge(score, score2);
    }

    public static void merge(Score score, Score score2) {
        if (score == null || score2 == null) {
            return;
        }
        boolean bl = false;
        int n = score.size();
        int n2 = score2.size();
        for (int i = 0; i < n2; ++i) {
            Part part = score2.getPart(i);
            int n3 = part.getChannel();
            for (int j = 0; j < n; ++j) {
                Part part2 = score.getPart(j);
                if (n3 != part2.getChannel()) continue;
                int n4 = part.size();
                for (int k = 0; k < n4; ++k) {
                    part2.addPhrase(part.getPhrase(k));
                }
                bl = true;
                j = n;
            }
            if (bl) continue;
            score.addPart(part);
            bl = false;
        }
    }

    public static void quantize(Score score, double d) {
        Mod.quantise(score, d);
    }

    public static void quantise(Score score, double d) {
        if (score == null || d <= 0.0) {
            return;
        }
        Enumeration enumeration = score.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            Mod.quantise(part, d);
        }
    }

    public static void shuffle(Score score) {
        Enumeration enumeration = score.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Mod.shuffle((Part)enumeration.nextElement());
        }
    }

    public static void accents(Score score, double d) {
        double[] dArray = new double[]{0.0};
        Mod.accents(score, d, dArray);
    }

    public static void accents(Score score, double d, double[] dArray) {
        Mod.accents(score, d, dArray, 20);
    }

    public static void accents(Score score, double d, double[] dArray, int n) {
        if (score == null || d <= 0.0) {
            return;
        }
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] < 0.0) && !(dArray[i] >= d)) continue;
            return;
        }
        Enumeration enumeration = score.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            Mod.accents(part, d, dArray, n);
        }
    }

    public static void normalise(Score score) {
        Cloneable cloneable;
        Enumeration enumeration;
        JMC jMC;
        Enumeration enumeration2;
        if (score == null) {
            return;
        }
        int n = 0;
        Enumeration enumeration3 = score.getPartList().elements();
        while (enumeration3.hasMoreElements()) {
            Part part = (Part)enumeration3.nextElement();
            enumeration2 = part.getPhraseList().elements();
            while (enumeration2.hasMoreElements()) {
                jMC = (Phrase)enumeration2.nextElement();
                enumeration = ((Phrase)jMC).getNoteList().elements();
                while (enumeration.hasMoreElements()) {
                    cloneable = (Note)enumeration.nextElement();
                    if (((Note)cloneable).getDynamic() <= n) continue;
                    n = ((Note)cloneable).getDynamic();
                }
            }
        }
        if (n == 127) {
            return;
        }
        int n2 = 127 - n;
        enumeration2 = score.getPartList().elements();
        while (enumeration2.hasMoreElements()) {
            jMC = (Part)enumeration2.nextElement();
            enumeration = ((Part)jMC).getPhraseList().elements();
            while (enumeration.hasMoreElements()) {
                cloneable = (Phrase)enumeration.nextElement();
                Enumeration enumeration4 = ((Phrase)cloneable).getNoteList().elements();
                while (enumeration4.hasMoreElements()) {
                    Note note = (Note)enumeration4.nextElement();
                    note.setDynamic(note.getDynamic() + n2);
                }
            }
        }
    }

    public static void consolidate(Score score) {
        if (score == null) {
            return;
        }
        for (int i = 0; i < score.size(); ++i) {
            Part part = score.getPart(i);
            int n = part.getChannel();
            int n2 = score.size();
            for (int j = n2 - 1; j > i; --j) {
                Part part2 = score.getPart(j);
                if (part2.getChannel() != n) continue;
                int n3 = part2.size();
                for (int k = 0; k < n3; ++k) {
                    Phrase phrase = part2.getPhrase(k);
                    phrase.setAppend(false);
                    part.addPhrase(phrase);
                }
                score.removePart(j);
            }
        }
    }

    public static void elongate(Score score, double d) {
        if (score == null || d <= 0.0) {
            return;
        }
        Enumeration enumeration = score.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            Mod.elongate(part, d);
        }
    }

    public static void tiePitches(Score score) {
        Enumeration enumeration = score.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            Mod.tiePitches(part);
        }
    }

    public static void tieRests(Score score) {
        Enumeration enumeration = score.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            Mod.tieRests(part);
        }
    }

    public static void fillRests(Score score) {
        Enumeration enumeration = score.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            Mod.fillRests(part);
        }
    }

    public static void spread(Score score) {
        if (score == null) {
            return;
        }
        Enumeration enumeration = score.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            Mod.spread(part);
        }
    }

    public static void bounce(Score score) {
        if (score == null) {
            return;
        }
        Enumeration enumeration = score.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            Mod.bounce(part);
        }
    }

    public static void varyLength(Score score, double d, double d2) {
        if (score == null || d2 < d) {
            return;
        }
        Enumeration enumeration = score.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            Mod.varyLength(part, d, d2);
        }
    }

    public static void randomize(Score score, int n) {
        Mod.randomize(score, n, 0.0);
    }

    public static void randomize(Score score, int n, double d) {
        Mod.randomize(score, n, d, 0);
    }

    public static void randomize(Score score, int n, double d, int n2) {
        if (score == null) {
            return;
        }
        boolean bl = true;
        Enumeration enumeration = score.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            Mod.randomize(part, n, d, n2);
        }
    }

    public static void slurUp(Score score, int n) {
        if (score == null) {
            return;
        }
        Enumeration enumeration = score.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            Mod.slurUp(part, n);
        }
    }

    public static void slurDown(Score score, int n) {
        if (score == null) {
            return;
        }
        Enumeration enumeration = score.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            Mod.slurDown(part, n);
        }
    }

    public static void increaseDuration(Score score, double d) {
        Enumeration enumeration = score.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            Mod.increaseDuration(part, d);
        }
    }

    public static void addToDuration(Score score, double d) {
        Enumeration enumeration = score.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            Mod.addToDuration(part, d);
        }
    }

    public static void addToRhythmValue(Score score, double d) {
        Enumeration enumeration = score.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            Mod.addToRhythmValue(part, d);
        }
    }

    public static void addToLength(Score score, double d) {
        Enumeration enumeration = score.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            Mod.addToLength(part, d);
        }
    }

    public static void expandIntervals(Score score, double d) {
        Enumeration enumeration = score.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            Mod.expandIntervals(part, d);
        }
    }

    public static void shake(Score score, int n) {
        Enumeration enumeration = score.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            Mod.shake(part, n);
        }
    }
}

