/*
 * Decompiled with CFR 0.152.
 */
package jm.music.tools.ga;

import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import jm.music.data.Phrase;
import jm.music.tools.NoteListException;
import jm.music.tools.PhraseAnalysis;
import jm.music.tools.QuantisationException;
import jm.music.tools.ga.FitnessEvaluater;

public class NormalDistributionFE
extends FitnessEvaluater {
    protected static String label = "Normal Distribution Fitness Evaluater";
    protected Panel panel;
    private double[] weighting = new double[]{1.0, 1.0, 1.0, 0.1, 1.0, 1.0, 0.5, 0.5, 0.5, 1.0, 0.5, 0.5, 1.0, 0.5, 1.0, 0.1, 1.0, 1.0, 1.0, 0.5, 0.1, 0.1, 0.1};
    protected Label F1Label;
    protected Label F2Label;
    protected Label F3Label;
    protected Label F4Label;
    protected Label F5Label;
    protected Label F6Label;
    protected Label F7Label;
    protected Label F8Label;
    protected Label F9Label;
    protected Label F10Label;
    protected Label F11Label;
    protected Label F12Label;
    protected Label F13Label;
    protected Label F14Label;
    protected Label F15Label;
    protected Label F16Label;
    protected Label F17Label;
    protected Label F18Label;
    protected Label F19Label;
    protected Label F20Label;
    protected Label F21Label;
    protected Label F22Label;
    protected Label F23Label;
    private double[] mean = new double[]{0.307, 0.308, 0.021, 0.669, 0.021, 0.079, 0.652, 0.545, 0.383, 0.13, 0.562, 0.411, 0.495, 0.601, 0.013, 0.252, 0.066, 0.183, 0.112, 0.538, 0.439, 0.523, 0.346};
    private double[] standardDeviation = new double[]{0.115, 0.129, 0.038, 0.318, 0.044, 0.137, 0.148, 0.166, 0.211, 0.13, 0.21, 0.139, 0.059, 0.218, 0.047, 0.399, 0.105, 0.146, 0.125, 0.227, 0.246, 0.261, 0.275};
    public static final double duration = 0.25;
    public static final int tonic = 60;
    public static final int[] scale = PhraseAnalysis.MAJOR_SCALE;

    public NormalDistributionFE() {
        this.panel = new Panel();
        this.panel.setLayout(new GridLayout(23, 3));
        this.F1Label = new Label(Integer.toString((int)(this.weighting[0] * 100.0)));
        this.panel.add(new Label("Note Density", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[0] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        NormalDistributionFE.access$100((NormalDistributionFE)1.access$000(this.this$1))[0] = (double)this.this$1.getValue() / 100.0;
                        1.access$000(this.this$1).F1Label.setText(Integer.toString(this.this$1.getValue()));
                        1.access$000(this.this$1).F1Label.repaint();
                    }
                });
            }

            static /* synthetic */ NormalDistributionFE access$000(1 var0) {
                return var0.NormalDistributionFE.this;
            }
        });
        this.panel.add(this.F1Label);
        this.F2Label = new Label(Integer.toString((int)(this.weighting[1] * 100.0)));
        this.panel.add(new Label("Pitch Variety", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[1] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        NormalDistributionFE.access$100((NormalDistributionFE)3.access$200(this.this$1))[1] = (double)this.this$1.getValue() / 100.0;
                        3.access$200(this.this$1).F2Label.setText(Integer.toString(this.this$1.getValue()));
                        3.access$200(this.this$1).F2Label.repaint();
                    }
                });
            }

            static /* synthetic */ NormalDistributionFE access$200(3 var0) {
                return var0.NormalDistributionFE.this;
            }
        });
        this.panel.add(this.F2Label);
        this.F3Label = new Label(Integer.toString((int)(this.weighting[1] * 100.0)));
        this.panel.add(new Label("Rhythmic Variety", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[2] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(this){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        NormalDistributionFE.access$100((NormalDistributionFE)5.access$300(this.this$1))[2] = (double)this.this$1.getValue() / 100.0;
                        5.access$300(this.this$1).F3Label.setText(Integer.toString(this.this$1.getValue()));
                        5.access$300(this.this$1).F3Label.repaint();
                    }
                });
            }

            static /* synthetic */ NormalDistributionFE access$300(5 var0) {
                return var0.NormalDistributionFE.this;
            }
        });
        this.panel.add(this.F3Label);
        this.F4Label = new Label(Integer.toString((int)(this.weighting[3] * 100.0)));
        this.panel.add(new Label("Climax Strength", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[3] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(this){
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        NormalDistributionFE.access$100((NormalDistributionFE)7.access$400(this.this$1))[3] = (double)this.this$1.getValue() / 100.0;
                        7.access$400(this.this$1).F4Label.setText(Integer.toString(this.this$1.getValue()));
                        7.access$400(this.this$1).F4Label.repaint();
                    }
                });
            }

            static /* synthetic */ NormalDistributionFE access$400(7 var0) {
                return var0.NormalDistributionFE.this;
            }
        });
        this.panel.add(this.F4Label);
        this.F5Label = new Label(Integer.toString((int)(this.weighting[4] * 100.0)));
        this.panel.add(new Label("Rest Density", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[4] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(this){
                    private final /* synthetic */ 9 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        NormalDistributionFE.access$100((NormalDistributionFE)9.access$500(this.this$1))[4] = (double)this.this$1.getValue() / 100.0;
                        9.access$500(this.this$1).F5Label.setText(Integer.toString(this.this$1.getValue()));
                        9.access$500(this.this$1).F5Label.repaint();
                    }
                });
            }

            static /* synthetic */ NormalDistributionFE access$500(9 var0) {
                return var0.NormalDistributionFE.this;
            }
        });
        this.panel.add(this.F5Label);
        this.F6Label = new Label(Integer.toString((int)(this.weighting[5] * 100.0)));
        this.panel.add(new Label("Tonal Deviation", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[5] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(this){
                    private final /* synthetic */ 11 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        NormalDistributionFE.access$100((NormalDistributionFE)11.access$600(this.this$1))[5] = (double)this.this$1.getValue() / 100.0;
                        11.access$600(this.this$1).F6Label.setText(Integer.toString(this.this$1.getValue()));
                        11.access$600(this.this$1).F6Label.repaint();
                    }
                });
            }

            static /* synthetic */ NormalDistributionFE access$600(11 var0) {
                return var0.NormalDistributionFE.this;
            }
        });
        this.panel.add(this.F6Label);
        this.F7Label = new Label(Integer.toString((int)(this.weighting[6] * 100.0)));
        this.panel.add(new Label("Key Centeredness", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[6] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(this){
                    private final /* synthetic */ 13 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        NormalDistributionFE.access$100((NormalDistributionFE)13.access$700(this.this$1))[6] = (double)this.this$1.getValue() / 100.0;
                        13.access$700(this.this$1).F7Label.setText(Integer.toString(this.this$1.getValue()));
                        13.access$700(this.this$1).F7Label.repaint();
                    }
                });
            }

            static /* synthetic */ NormalDistributionFE access$700(13 var0) {
                return var0.NormalDistributionFE.this;
            }
        });
        this.panel.add(this.F7Label);
        this.F8Label = new Label(Integer.toString((int)(this.weighting[7] * 100.0)));
        this.panel.add(new Label("Pitch Range", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[7] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(this){
                    private final /* synthetic */ 15 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        NormalDistributionFE.access$100((NormalDistributionFE)15.access$800(this.this$1))[7] = (double)this.this$1.getValue() / 100.0;
                        15.access$800(this.this$1).F8Label.setText(Integer.toString(this.this$1.getValue()));
                        15.access$800(this.this$1).F8Label.repaint();
                    }
                });
            }

            static /* synthetic */ NormalDistributionFE access$800(15 var0) {
                return var0.NormalDistributionFE.this;
            }
        });
        this.panel.add(this.F8Label);
        this.F9Label = new Label(Integer.toString((int)(this.weighting[8] * 100.0)));
        this.panel.add(new Label("Rhythm Range", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[8] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(this){
                    private final /* synthetic */ 17 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        NormalDistributionFE.access$100((NormalDistributionFE)17.access$900(this.this$1))[8] = (double)this.this$1.getValue() / 100.0;
                        17.access$900(this.this$1).F9Label.setText(Integer.toString(this.this$1.getValue()));
                        17.access$900(this.this$1).F9Label.repaint();
                    }
                });
            }

            static /* synthetic */ NormalDistributionFE access$900(17 var0) {
                return var0.NormalDistributionFE.this;
            }
        });
        this.panel.add(this.F9Label);
        this.F10Label = new Label(Integer.toString((int)(this.weighting[9] * 100.0)));
        this.panel.add(new Label("Repeated Pitch Density", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[9] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(this){
                    private final /* synthetic */ 19 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        NormalDistributionFE.access$100((NormalDistributionFE)19.access$1000(this.this$1))[9] = (double)this.this$1.getValue() / 100.0;
                        19.access$1000(this.this$1).F10Label.setText(Integer.toString(this.this$1.getValue()));
                        19.access$1000(this.this$1).F10Label.repaint();
                    }
                });
            }

            static /* synthetic */ NormalDistributionFE access$1000(19 var0) {
                return var0.NormalDistributionFE.this;
            }
        });
        this.panel.add(this.F10Label);
        this.F11Label = new Label(Integer.toString((int)(this.weighting[10] * 100.0)));
        this.panel.add(new Label("Repeated Rhythm Density", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[10] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(this){
                    private final /* synthetic */ 21 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        NormalDistributionFE.access$100((NormalDistributionFE)21.access$1100(this.this$1))[10] = (double)this.this$1.getValue() / 100.0;
                        21.access$1100(this.this$1).F11Label.setText(Integer.toString(this.this$1.getValue()));
                        21.access$1100(this.this$1).F11Label.repaint();
                    }
                });
            }

            static /* synthetic */ NormalDistributionFE access$1100(21 var0) {
                return var0.NormalDistributionFE.this;
            }
        });
        this.panel.add(this.F11Label);
        this.F12Label = new Label(Integer.toString((int)(this.weighting[11] * 100.0)));
        this.panel.add(new Label("Melodic Direction Stability", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[11] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(this){
                    private final /* synthetic */ 23 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        NormalDistributionFE.access$100((NormalDistributionFE)23.access$1200(this.this$1))[11] = (double)this.this$1.getValue() / 100.0;
                        23.access$1200(this.this$1).F12Label.setText(Integer.toString(this.this$1.getValue()));
                        23.access$1200(this.this$1).F12Label.repaint();
                    }
                });
            }

            static /* synthetic */ NormalDistributionFE access$1200(23 var0) {
                return var0.NormalDistributionFE.this;
            }
        });
        this.panel.add(this.F12Label);
        this.F13Label = new Label(Integer.toString((int)(this.weighting[12] * 100.0)));
        this.panel.add(new Label("Overall Pitch Direction", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[12] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(this){
                    private final /* synthetic */ 25 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        NormalDistributionFE.access$100((NormalDistributionFE)25.access$1300(this.this$1))[12] = (double)this.this$1.getValue() / 100.0;
                        25.access$1300(this.this$1).F13Label.setText(Integer.toString(this.this$1.getValue()));
                        25.access$1300(this.this$1).F13Label.repaint();
                    }
                });
            }

            static /* synthetic */ NormalDistributionFE access$1300(25 var0) {
                return var0.NormalDistributionFE.this;
            }
        });
        this.panel.add(this.F13Label);
        this.F14Label = new Label(Integer.toString((int)(this.weighting[13] * 100.0)));
        this.panel.add(new Label("Pitch Movement", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[13] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(this){
                    private final /* synthetic */ 27 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        NormalDistributionFE.access$100((NormalDistributionFE)27.access$1400(this.this$1))[13] = (double)this.this$1.getValue() / 100.0;
                        27.access$1400(this.this$1).F14Label.setText(Integer.toString(this.this$1.getValue()));
                        27.access$1400(this.this$1).F14Label.repaint();
                    }
                });
            }

            static /* synthetic */ NormalDistributionFE access$1400(27 var0) {
                return var0.NormalDistributionFE.this;
            }
        });
        this.panel.add(this.F14Label);
        this.F15Label = new Label(Integer.toString((int)(this.weighting[14] * 100.0)));
        this.panel.add(new Label("Dissonance", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[14] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(this){
                    private final /* synthetic */ 29 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        NormalDistributionFE.access$100((NormalDistributionFE)29.access$1500(this.this$1))[14] = (double)this.this$1.getValue() / 100.0;
                        29.access$1500(this.this$1).F15Label.setText(Integer.toString(this.this$1.getValue()));
                        29.access$1500(this.this$1).F15Label.repaint();
                    }
                });
            }

            static /* synthetic */ NormalDistributionFE access$1500(29 var0) {
                return var0.NormalDistributionFE.this;
            }
        });
        this.panel.add(this.F15Label);
        this.F16Label = new Label(Integer.toString((int)(this.weighting[15] * 100.0)));
        this.panel.add(new Label("Leap Compensation", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[15] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(this){
                    private final /* synthetic */ 31 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        NormalDistributionFE.access$100((NormalDistributionFE)31.access$1600(this.this$1))[15] = (double)this.this$1.getValue() / 100.0;
                        31.access$1600(this.this$1).F16Label.setText(Integer.toString(this.this$1.getValue()));
                        31.access$1600(this.this$1).F16Label.repaint();
                    }
                });
            }

            static /* synthetic */ NormalDistributionFE access$1600(31 var0) {
                return var0.NormalDistributionFE.this;
            }
        });
        this.panel.add(this.F16Label);
        this.F17Label = new Label(Integer.toString((int)(this.weighting[16] * 100.0)));
        this.panel.add(new Label("Syncopation", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[16] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(this){
                    private final /* synthetic */ 33 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        NormalDistributionFE.access$100((NormalDistributionFE)33.access$1700(this.this$1))[16] = (double)this.this$1.getValue() / 100.0;
                        33.access$1700(this.this$1).F17Label.setText(Integer.toString(this.this$1.getValue()));
                        33.access$1700(this.this$1).F17Label.repaint();
                    }
                });
            }

            static /* synthetic */ NormalDistributionFE access$1700(33 var0) {
                return var0.NormalDistributionFE.this;
            }
        });
        this.panel.add(this.F17Label);
        this.F18Label = new Label(Integer.toString((int)(this.weighting[17] * 100.0)));
        this.panel.add(new Label("Repeated Pitch Patterns of 3", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[17] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(this){
                    private final /* synthetic */ 35 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        NormalDistributionFE.access$100((NormalDistributionFE)35.access$1800(this.this$1))[17] = (double)this.this$1.getValue() / 100.0;
                        35.access$1800(this.this$1).F18Label.setText(Integer.toString(this.this$1.getValue()));
                        35.access$1800(this.this$1).F18Label.repaint();
                    }
                });
            }

            static /* synthetic */ NormalDistributionFE access$1800(35 var0) {
                return var0.NormalDistributionFE.this;
            }
        });
        this.panel.add(this.F18Label);
        this.F19Label = new Label(Integer.toString((int)(this.weighting[18] * 100.0)));
        this.panel.add(new Label("Repeated Pitch Patterns of 4", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[18] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(this){
                    private final /* synthetic */ 37 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        NormalDistributionFE.access$100((NormalDistributionFE)37.access$1900(this.this$1))[18] = (double)this.this$1.getValue() / 100.0;
                        37.access$1900(this.this$1).F19Label.setText(Integer.toString(this.this$1.getValue()));
                        37.access$1900(this.this$1).F19Label.repaint();
                    }
                });
            }

            static /* synthetic */ NormalDistributionFE access$1900(37 var0) {
                return var0.NormalDistributionFE.this;
            }
        });
        this.panel.add(this.F19Label);
        this.F20Label = new Label(Integer.toString((int)(this.weighting[19] * 100.0)));
        this.panel.add(new Label("Repeated Rhythm Patterns of 3", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[19] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(this){
                    private final /* synthetic */ 39 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        NormalDistributionFE.access$100((NormalDistributionFE)39.access$2000(this.this$1))[19] = (double)this.this$1.getValue() / 100.0;
                        39.access$2000(this.this$1).F20Label.setText(Integer.toString(this.this$1.getValue()));
                        39.access$2000(this.this$1).F20Label.repaint();
                    }
                });
            }

            static /* synthetic */ NormalDistributionFE access$2000(39 var0) {
                return var0.NormalDistributionFE.this;
            }
        });
        this.panel.add(this.F20Label);
        this.F21Label = new Label(Integer.toString((int)(this.weighting[20] * 100.0)));
        this.panel.add(new Label("Repeated Rhythm Patterns of 4", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[20] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(this){
                    private final /* synthetic */ 41 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        NormalDistributionFE.access$100((NormalDistributionFE)41.access$2100(this.this$1))[20] = (double)this.this$1.getValue() / 100.0;
                        41.access$2100(this.this$1).F21Label.setText(Integer.toString(this.this$1.getValue()));
                        41.access$2100(this.this$1).F21Label.repaint();
                    }
                });
            }

            static /* synthetic */ NormalDistributionFE access$2100(41 var0) {
                return var0.NormalDistributionFE.this;
            }
        });
        this.panel.add(this.F21Label);
        this.F22Label = new Label(Integer.toString((int)(this.weighting[21] * 100.0)));
        this.panel.add(new Label("Climax Position", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[21] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(this){
                    private final /* synthetic */ 43 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        NormalDistributionFE.access$100((NormalDistributionFE)43.access$2200(this.this$1))[21] = (double)this.this$1.getValue() / 100.0;
                        43.access$2200(this.this$1).F22Label.setText(Integer.toString(this.this$1.getValue()));
                        43.access$2200(this.this$1).F22Label.repaint();
                    }
                });
            }

            static /* synthetic */ NormalDistributionFE access$2200(43 var0) {
                return var0.NormalDistributionFE.this;
            }
        });
        this.panel.add(this.F22Label);
        this.F23Label = new Label(Integer.toString((int)(this.weighting[22] * 100.0)));
        this.panel.add(new Label("Climax Tonality", 2));
        this.panel.add(new Scrollbar(0, (int)(this.weighting[22] * 100.0), 1, 0, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(this){
                    private final /* synthetic */ 45 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        NormalDistributionFE.access$100((NormalDistributionFE)45.access$2300(this.this$1))[22] = (double)this.this$1.getValue() / 100.0;
                        45.access$2300(this.this$1).F23Label.setText(Integer.toString(this.this$1.getValue()));
                        45.access$2300(this.this$1).F23Label.repaint();
                    }
                });
            }

            static /* synthetic */ NormalDistributionFE access$2300(45 var0) {
                return var0.NormalDistributionFE.this;
            }
        });
        this.panel.add(this.F23Label);
    }

    public double[] evaluate(Phrase[] phraseArray) {
        double[] dArray = new double[phraseArray.length];
        for (int i = 0; i < phraseArray.length; ++i) {
            double d = 0.0;
            for (int j = 0; j < this.mean.length; ++j) {
                d += this.calculateFitness(this.getValue2(j, phraseArray[i]), this.mean[j], this.standardDeviation[j], this.weighting[j]);
            }
            dArray[i] = 1.0 / (d / (double)(this.weighting.length - 1) + 1.0);
        }
        return dArray;
    }

    private double calculateFitness(double d, double d2, double d3, double d4) {
        return Math.abs((d - d2) / d3) * d4;
    }

    private double getValue2(int n, Phrase phrase) {
        try {
            switch (n) {
                default: {
                    return PhraseAnalysis.noteDensity(phrase, 0.25);
                }
                case 1: {
                    return PhraseAnalysis.pitchVariety(phrase);
                }
                case 2: {
                    return PhraseAnalysis.rhythmicVariety(phrase);
                }
                case 3: {
                    return PhraseAnalysis.climaxStrength(phrase);
                }
                case 4: {
                    return PhraseAnalysis.restDensity(phrase, 0.25);
                }
                case 5: {
                    return PhraseAnalysis.tonalDeviation(phrase, 0.25, 60, scale);
                }
                case 6: {
                    return PhraseAnalysis.keyCenteredness(phrase, 0.25, 60);
                }
                case 7: {
                    return PhraseAnalysis.pitchRangePerSpan(phrase);
                }
                case 8: {
                    return PhraseAnalysis.rhythmRangePerSpan(phrase);
                }
                case 9: {
                    return PhraseAnalysis.repeatedPitchDensity(phrase);
                }
                case 10: {
                    return PhraseAnalysis.repeatedRhythmicValueDensity(phrase);
                }
                case 11: {
                    return PhraseAnalysis.melodicDirectionStability(phrase);
                }
                case 12: {
                    return PhraseAnalysis.overallPitchDirection(phrase);
                }
                case 13: {
                    return PhraseAnalysis.movementByStep(phrase, 60, scale);
                }
                case 14: {
                    return PhraseAnalysis.dissonance(phrase);
                }
                case 15: {
                    return PhraseAnalysis.leapCompensation(phrase);
                }
                case 16: {
                    return PhraseAnalysis.syncopation(phrase);
                }
                case 17: {
                    return PhraseAnalysis.repeatedPitchPatterns(phrase, 3);
                }
                case 18: {
                    return PhraseAnalysis.repeatedPitchPatterns(phrase, 4);
                }
                case 19: {
                    return PhraseAnalysis.repeatedRhythmPatterns(phrase, 3);
                }
                case 20: {
                    return PhraseAnalysis.repeatedRhythmPatterns(phrase, 4);
                }
                case 21: {
                    return PhraseAnalysis.climaxPosition(phrase);
                }
                case 22: 
            }
            return PhraseAnalysis.climaxTonality(phrase, 60, scale);
        }
        catch (NoteListException noteListException) {
            noteListException.printStackTrace();
            System.err.println(noteListException);
            System.exit(-1);
        }
        catch (QuantisationException quantisationException) {
            quantisationException.printStackTrace();
            System.err.println(quantisationException);
            System.exit(-1);
        }
        return 0.0;
    }

    public Panel getPanel() {
        return this.panel;
    }

    public String getLabel() {
        return label;
    }

    static /* synthetic */ double[] access$100(NormalDistributionFE normalDistributionFE) {
        return normalDistributionFE.weighting;
    }
}

