/*
 * Decompiled with CFR 0.152.
 */
package jm.music.tools.ga;

import jm.music.data.Phrase;
import jm.music.tools.ga.FitnessEvaluater;
import jm.music.tools.ga.Mutater;
import jm.music.tools.ga.ParentSelector;
import jm.music.tools.ga.PopulationInitialiser;
import jm.music.tools.ga.Recombiner;
import jm.music.tools.ga.SurvivorSelector;
import jm.music.tools.ga.TerminationCriteria;

public class PhrGeneticAlgorithm {
    protected Phrase[] population;
    protected double[] fitness;
    protected PopulationInitialiser populationInitialiser;
    protected FitnessEvaluater fitnessEvaluater;
    protected TerminationCriteria terminationCriteria;
    protected ParentSelector parentSelector;
    protected Recombiner recombiner;
    protected Mutater mutater;
    protected SurvivorSelector survivorSelector;
    protected int beatsPerBar;
    protected long iteration;
    protected double initialLength;
    protected int initialSize;
    protected int originalSize;
    protected boolean finished;

    public PhrGeneticAlgorithm(Phrase phrase, int n, PopulationInitialiser populationInitialiser, FitnessEvaluater fitnessEvaluater, TerminationCriteria terminationCriteria, ParentSelector parentSelector, Recombiner recombiner, Mutater mutater, SurvivorSelector survivorSelector) {
        this.beatsPerBar = n;
        this.initialLength = phrase.getEndTime();
        this.originalSize = this.initialSize = phrase.size();
        this.populationInitialiser = populationInitialiser;
        this.fitnessEvaluater = fitnessEvaluater;
        this.terminationCriteria = terminationCriteria;
        this.parentSelector = parentSelector;
        this.recombiner = recombiner;
        this.mutater = mutater;
        this.survivorSelector = survivorSelector;
        this.setUpNewPopulation(phrase);
    }

    public void setUpNewPopulation(Phrase phrase) {
        this.iteration = 0L;
        this.population = this.populationInitialiser.initPopulation(phrase, this.beatsPerBar);
        this.fitness = this.fitnessEvaluater.evaluate(this.population);
    }

    public void setBeatsPerBar(int n) {
        this.beatsPerBar = n;
    }

    public void zeroInitialSize() {
        this.originalSize = this.initialSize;
        this.initialSize = 0;
    }

    public void restoreInitialSize() {
        this.initialSize = this.originalSize;
    }

    public long getIteration() {
        return this.iteration;
    }

    public boolean iterate() {
        this.finished = this.terminationCriteria.isFinished(this.population);
        if (!this.finished) {
            ++this.iteration;
            Phrase[] phraseArray = this.parentSelector.selectParents(this.population, this.fitness);
            Phrase[] phraseArray2 = this.recombiner.recombine(phraseArray, this.fitness, this.initialLength, this.initialSize, this.beatsPerBar);
            Phrase[] phraseArray3 = this.mutater.mutate(phraseArray2, this.initialLength, this.initialSize, this.beatsPerBar);
            double[] dArray = this.fitnessEvaluater.evaluate(phraseArray3);
            this.population = this.survivorSelector.selectSurvivors(this.population, this.fitness, phraseArray3, dArray);
            this.fitness = this.fitnessEvaluater.evaluate(this.population);
            return true;
        }
        return false;
    }

    public long iterate(long l) {
        long l2 = l;
        int n = 0;
        while ((long)n < l) {
            this.iterate();
            if (this.finished) {
                l2 = n;
                break;
            }
            ++n;
        }
        return l2;
    }

    public double[] getFitness() {
        return this.fitness;
    }

    public Phrase[] getPopulation() {
        return this.population;
    }

    public Phrase[] getOrderedPopulation() {
        this.quicksort();
        return this.population;
    }

    private void quicksort() {
        this.quicksort(0, this.population.length - 1);
    }

    private void quicksort(int n, int n2) {
        if (n >= n2) {
            return;
        }
        this.swap(n, PhrGeneticAlgorithm.rand(n, n2));
        int n3 = n;
        for (int i = n + 1; i <= n2; ++i) {
            if (!(this.fitness[i] < this.fitness[n])) continue;
            this.swap(++n3, i);
        }
        this.swap(n, n3);
        this.quicksort(n, n3 - 1);
        this.quicksort(n3 + 1, n2);
    }

    private static int rand(int n, int n2) {
        return n + (int)(Math.random() * (double)(n2 - n)) + 1;
    }

    private void swap(int n, int n2) {
        Phrase phrase = this.population[n];
        this.population[n] = this.population[n2];
        this.population[n2] = phrase;
        double d = this.fitness[n];
        this.fitness[n] = this.fitness[n2];
        this.fitness[n2] = d;
    }

    public double getBestFitness() {
        double d = 0.0;
        int n = -1;
        for (int i = 0; i < this.fitness.length; ++i) {
            if (!(this.fitness[i] > d)) continue;
            d = this.fitness[i];
            n = i;
        }
        return d;
    }

    public double getAverageFitness() {
        double d = 0.0;
        for (int i = 0; i < this.fitness.length; ++i) {
            d += this.fitness[i];
        }
        return d / (double)this.fitness.length;
    }

    public double getStandardDeviation() {
        double d = this.getAverageFitness();
        double d2 = 0.0;
        for (int i = 0; i < this.fitness.length; ++i) {
            d2 += (d - this.fitness[i]) * (d - this.fitness[i]);
        }
        return Math.sqrt(d2) / (double)this.fitness.length;
    }

    public Phrase getBestIndividual() {
        double d = Double.MAX_VALUE;
        int n = -1;
        for (int i = 0; i < this.fitness.length; ++i) {
            if (!(this.fitness[i] < d)) continue;
            d = this.fitness[i];
            n = i;
        }
        return this.population[n];
    }

    public Mutater getMutater() {
        return this.mutater;
    }
}

