/*
 * Decompiled with CFR 0.152.
 */
package jm.util;

import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;
import jm.util.ConversionException;
import jm.util.XMLParser;

public class Convert {
    public static final String DEFAULT_SEPARATOR = ",";
    public static final String LEFT_BRACKET = "[";
    public static final String RIGHT_BRACKET = "]";

    private Convert() {
    }

    public static Phrase pitchAndRhythmStringToPhrase(String string) {
        StringProcessor stringProcessor = new StringProcessor(string);
        Phrase phrase = new Phrase();
        try {
            while (true) {
                phrase.addNote(new Note((int)stringProcessor.getNextRhythm(), stringProcessor.getNextRhythm()));
            }
        }
        catch (EOSException eOSException) {
            return phrase;
        }
    }

    public static String phraseToPitchAndRhythmString(Phrase phrase) {
        Note[] noteArray = phrase.getNoteArray();
        StringBuffer stringBuffer = new StringBuffer(noteArray.length * 10);
        for (int i = 0; i < noteArray.length - 1; ++i) {
            stringBuffer.append(noteArray[i].getPitch());
            stringBuffer.append(DEFAULT_SEPARATOR);
            stringBuffer.append(Convert.limitDecimalPlaces(noteArray[i].getRhythmValue(), 3));
            stringBuffer.append(DEFAULT_SEPARATOR);
        }
        if (noteArray.length > 0) {
            stringBuffer.append(noteArray[noteArray.length - 1].getPitch());
            stringBuffer.append(DEFAULT_SEPARATOR);
            stringBuffer.append(Convert.limitDecimalPlaces(noteArray[noteArray.length - 1].getRhythmValue(), 3));
        }
        return stringBuffer.toString();
    }

    public static Phrase pitchRhythmAndDynamicStringToPhrase(String string) {
        StringProcessor stringProcessor = new StringProcessor(string);
        Phrase phrase = new Phrase();
        try {
            while (true) {
                phrase.addNote(new Note((int)stringProcessor.getNextRhythm(), stringProcessor.getNextRhythm(), (int)stringProcessor.getNextRhythm()));
            }
        }
        catch (EOSException eOSException) {
            return phrase;
        }
    }

    public static String phraseToPitchRhythmAndDynamicString(Phrase phrase) {
        Note[] noteArray = phrase.getNoteArray();
        StringBuffer stringBuffer = new StringBuffer(noteArray.length * 12);
        for (int i = 0; i < noteArray.length - 1; ++i) {
            stringBuffer.append(LEFT_BRACKET);
            stringBuffer.append(noteArray[i].getPitch());
            stringBuffer.append(DEFAULT_SEPARATOR);
            stringBuffer.append(Convert.limitDecimalPlaces(noteArray[i].getRhythmValue(), 3));
            stringBuffer.append(DEFAULT_SEPARATOR);
            stringBuffer.append(noteArray[i].getDynamic());
            stringBuffer.append(RIGHT_BRACKET);
            stringBuffer.append(DEFAULT_SEPARATOR);
        }
        if (noteArray.length > 0) {
            stringBuffer.append(LEFT_BRACKET);
            stringBuffer.append(noteArray[noteArray.length - 1].getPitch());
            stringBuffer.append(DEFAULT_SEPARATOR);
            stringBuffer.append(Convert.limitDecimalPlaces(noteArray[noteArray.length - 1].getRhythmValue(), 3));
            stringBuffer.append(DEFAULT_SEPARATOR);
            stringBuffer.append(noteArray[noteArray.length - 1].getDynamic());
            stringBuffer.append(RIGHT_BRACKET);
        }
        return stringBuffer.toString();
    }

    static String limitDecimalPlaces(double d, int n) {
        String string = Double.toString(d);
        int n2 = string.lastIndexOf(".") + n + 1;
        if (n2 > string.length()) {
            n2 = string.length();
        }
        return string.substring(0, n2);
    }

    public static String scoreToXMLString(Score score) {
        return XMLParser.scoreToXMLString(score);
    }

    public static String partToXMLString(Part part) {
        return XMLParser.partToXMLString(part);
    }

    public static String phraseToXMLString(Phrase phrase) {
        return XMLParser.phraseToXMLString(phrase);
    }

    public static String noteToXMLString(Note note) {
        return XMLParser.noteToXMLString(note);
    }

    public static Score xmlStringToScore(String string) throws ConversionException {
        return XMLParser.xmlStringToScore(string);
    }

    public static Part xmlStringToPart(String string) throws ConversionException {
        return XMLParser.xmlStringToPart(string);
    }

    public static Phrase xmlStringToPhrase(String string) throws ConversionException {
        return XMLParser.xmlStringToPhrase(string);
    }

    public static Note xmlStringToNote(String string) throws ConversionException {
        return XMLParser.xmlStringToNote(string);
    }

    private static class StringProcessor {
        private int i = 0;
        private String string;

        StringProcessor(String string) {
            this.string = string;
        }

        private int getNextPitch() throws ConversionException, EOSException {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                while (!Character.isDigit(this.string.charAt(this.i++))) {
                }
                stringBuffer.append(this.string.charAt(this.i - 1));
                while (Character.isDigit(this.string.charAt(this.i++))) {
                    stringBuffer.append(this.string.charAt(this.i - 1));
                }
                if (this.string.charAt(this.i - 1) == '.') {
                    throw new ConversionException("Double value not expected");
                }
                return Integer.parseInt(stringBuffer.toString());
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (stringBuffer.length() > 0) {
                    return Integer.parseInt(stringBuffer.toString());
                }
                throw new EOSException();
            }
        }

        private double getNextRhythm() throws EOSException {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                while (!Character.isDigit(this.string.charAt(this.i++)) && this.string.charAt(this.i) != '.') {
                }
                stringBuffer.append(this.string.charAt(this.i - 1));
                while (Character.isDigit(this.string.charAt(this.i)) || this.string.charAt(this.i) == '.') {
                    stringBuffer.append(this.string.charAt(this.i));
                    ++this.i;
                }
                return Double.valueOf(stringBuffer.toString());
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (stringBuffer.length() > 0) {
                    return Double.valueOf(stringBuffer.toString());
                }
                throw new EOSException();
            }
        }
    }

    private static class EOSException
    extends Exception {
        private EOSException() {
        }
    }
}

