/*
 * Decompiled with CFR 0.152.
 */
package jm.util;

import java.applet.Applet;
import java.applet.AudioClip;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Vector;
import jm.JMC;
import jm.audio.Instrument;
import jm.audio.RTMixer;
import jm.gui.wave.WaveFileReader;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;
import jm.music.rt.RTLine;
import jm.music.rt.RTPhrase;
import jm.util.AudioRTLine;
import jm.util.PlayCycle;
import jm.util.PlayThread;
import jm.util.Read;

public class Play
implements JMC {
    private static PlayThread pt;
    private static PlayCycle pc;
    private static boolean cyclePlaying;
    private static boolean midiPlaying;
    private static Thread pauseThread;

    public static void stopCycle() {
        cyclePlaying = false;
        if (pc != null) {
            pc.stopPlayCycle();
        }
    }

    public static boolean cycleIsPlaying() {
        return cyclePlaying;
    }

    public static void waitCycle(Score score) {
        try {
            Thread.sleep((int)(60000.0 / score.getTempo() * score.getEndTime() + 2000.0));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void mid(String string) {
        Score score = new Score();
        Read.midi(score, string);
        Play.midi(score);
    }

    public static void midi(Note note) {
        Play.midi(note, true);
    }

    public static void midi(Phrase phrase) {
        Play.midi(phrase, true);
    }

    public static void midi(Part part) {
        Play.midi(part, true);
    }

    public static void midi(Score score) {
        Play.midi(score, true);
    }

    public static void midi(Note note, boolean bl) {
        Score score = new Score("One note score", 60.0);
        score.addPart(new Part(new Phrase(note)));
        Play.midi(score, bl);
    }

    public static void midi(Phrase phrase, boolean bl) {
        double d = 60.0;
        if (phrase.getTempo() != -1.0) {
            d = phrase.getTempo();
        }
        Score score = new Score(phrase.getTitle() + " score", d);
        if (phrase.getTempo() != -1.0) {
            score.setTempo(phrase.getTempo());
        }
        score.addPart(new Part(phrase));
        Play.midi(score, bl);
    }

    public static void midi(Part part, boolean bl) {
        double d = 60.0;
        if (part.getTempo() != -1.0) {
            d = part.getTempo();
        }
        Score score = new Score(part.getTitle() + " score", d);
        if (part.getTempo() != -1.0) {
            score.setTempo(part.getTempo());
        }
        score.addPart(part);
        Play.midi(score, bl);
    }

    public static void midi(Score score, boolean bl) {
        if (midiPlaying) {
            Play.stopMidi();
        }
        midiPlaying = true;
        Score score2 = score.copy();
        System.out.print("-- Constructing MIDI file from'" + score.getTitle() + "'...");
        pt = new PlayThread(score2);
        new Thread(pt).start();
        System.out.print(" Playing with JavaSound ...");
        Play.midiWait(score, bl);
    }

    private static void midiWait(final Score score, final boolean bl) {
        pauseThread = new Thread(new Runnable(){

            public void run() {
                try {
                    pauseThread;
                    Thread.sleep((int)(score.getEndTime() * 60.0 / score.getTempo() * 1000.0) + 3000);
                }
                catch (Exception exception) {
                    System.out.println("jMusic Play error in pause thread");
                }
                System.out.println(" Completed MIDI playback --------");
                if (bl) {
                    System.exit(0);
                }
            }
        });
        pauseThread.start();
    }

    public static void stopMidi() {
        if (pt != null) {
            pt.stopPlayThread();
            midiPlaying = false;
        }
    }

    public static void midiCycle(Note note) {
        Score score = new Score("One note score");
        score.addPart(new Part(new Phrase(note)));
        Play.midiCycle(score);
    }

    public static void midiCycle(Phrase phrase) {
        Score score = new Score(phrase.getTitle() + " score");
        score.addPart(new Part(phrase));
        Play.midiCycle(score);
    }

    public static void midiCycle(Part part) {
        Score score = new Score(part.getTitle() + " score");
        score.addPart(part);
        Play.midiCycle(score);
    }

    public static void midiCycle(Score score) {
        if (cyclePlaying) {
            Play.stopCycle();
        }
        cyclePlaying = true;
        pc = new PlayCycle(score);
        new Thread(pc).start();
    }

    public static void au(String string) {
        Play.au(string, true);
    }

    public static void au(String string, boolean bl) {
        WaveFileReader waveFileReader = new WaveFileReader(string);
        RTLine[] rTLineArray = new RTLine[]{new AudioRTLine(string)};
        RTMixer rTMixer = new RTMixer(rTLineArray);
        rTMixer.begin();
        System.out.println("---------- Playing '" + string + "'... Sample rate = " + waveFileReader.getSampleRate() + " Channels = " + waveFileReader.getChannels() + " ----------");
        if (bl) {
            File file = new File(string);
            try {
                int n = waveFileReader.getBits() - 1;
                Thread.sleep((int)((double)file.length() / (double)n / (double)waveFileReader.getSampleRate() / (double)waveFileReader.getChannels() * 1000.0) + 1000);
            }
            catch (InterruptedException interruptedException) {
                System.err.println("jMusic play.au error: Thread sleeping interupted");
            }
            System.out.println("-------------------- Completed Audio Playback ----------------------");
            System.exit(0);
        }
    }

    public static void audio(Phrase phrase, Instrument[] instrumentArray) {
        Play.audio(new Score(new Part(phrase)), instrumentArray);
    }

    public static void audio(Phrase phrase, Instrument instrument) {
        Part part = new Part(phrase);
        if (phrase.getTempo() != -1.0) {
            part.setTempo(phrase.getTempo());
        }
        Play.audio(part, new Instrument[]{instrument});
    }

    public static void audio(Part part, Instrument[] instrumentArray) {
        Score score = new Score(part);
        if (part.getTempo() != -1.0) {
            score.setTempo(part.getTempo());
        }
        Play.audio(score, instrumentArray);
    }

    public static void audio(Part part, Instrument instrument) {
        Play.audio(new Score(part), new Instrument[]{instrument});
    }

    public static void audio(Score score, Instrument instrument) {
        Play.audio(score, new Instrument[]{instrument});
    }

    public static void audio(Score score, Instrument[] instrumentArray) {
        System.out.print("-------- Playing Score as Audio ...");
        for (int i = 0; i < instrumentArray.length; ++i) {
            instrumentArray[i].setOutput(1);
        }
        Vector<Phrase> vector = new Vector<Phrase>();
        for (int i = 0; i < score.size(); ++i) {
            Part part = score.getPart(i);
            for (int j = 0; j < part.size(); ++j) {
                Phrase phrase = part.getPhrase(j);
                if (phrase.getInstrument() == -1) {
                    phrase.setInstrument(part.getInstrument());
                }
                if (phrase.getTempo() == -1.0) {
                    phrase.setTempo(part.getTempo());
                }
                vector.addElement(phrase);
            }
        }
        RTLine[] rTLineArray = new RTLine[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            Phrase phrase = (Phrase)vector.elementAt(i);
            rTLineArray[i] = new RTPhrase(phrase, instrumentArray[phrase.getInstrument()]);
        }
        RTMixer rTMixer = new RTMixer(rTLineArray);
        rTMixer.begin();
        Play.audioWait(score, rTMixer);
    }

    private static void audioWait(final Score score, final RTMixer rTMixer) {
        pauseThread = new Thread(new Runnable(){

            public void run() {
                try {
                    pauseThread;
                    Thread.sleep((int)(score.getEndTime() * 60.0 / score.getTempo() * 1000.0));
                }
                catch (Exception exception) {
                    System.out.println("jMusic Play error in pause thread");
                }
                System.out.println(" Completed audio playback --------");
                rTMixer.pause();
            }
        });
        pauseThread.start();
    }

    public static void audioClip(String string) {
        System.out.println("-------- Playing an audio file ----------");
        System.out.println("Loading sound into memory, please wait...");
        File file = new File(string);
        try {
            AudioClip audioClip = Applet.newAudioClip(file.toURL());
            System.out.println("Playing '" + string + "' ...");
            audioClip.play();
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("jMusic play.au error: malformed URL or filename");
        }
        try {
            Thread.sleep((int)((double)file.length() / 2.0 / 44100.0 / 2.0 * 1000.0) + 1000);
        }
        catch (InterruptedException interruptedException) {
            System.err.println("jMusic play.au error: Thread sleeping interupted");
        }
        System.out.println("-------------------- Completed Playback ----------------------");
        System.exit(0);
    }

    static {
        cyclePlaying = false;
        midiPlaying = false;
    }
}

