/*
 * Decompiled with CFR 0.152.
 */
package jm.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import jm.music.data.Score;
import jm.util.Read;
import jm.util.ReadFilenameFilter;
import jm.util.ReadListener;
import jm.util.ReadListenerLinkedList;

public class ReadFilesJButton
extends JButton {
    public static final Mode SINGLE_FILE_MODE = new Mode("Single File");
    public static final Mode MULTIPLE_FILES_MODE = new Mode("Multiple Files");
    public static final Mode FOLDER_MODE = new Mode("Folder");
    private Mode mode;
    private ReadListenerLinkedList readListenerList;
    private JFileChooser chooser = new JFileChooser();
    private Component owner;

    public ReadFilesJButton(Component component) {
        this(component, MULTIPLE_FILES_MODE);
    }

    public ReadFilesJButton(final Component component, final Mode mode) {
        this.owner = component;
        this.setMode(mode);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Runnable runnable = new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        File file;
                        ReadFilesJButton.access$200(1.access$100(this.this$1)).startedReading();
                        int n = ReadFilesJButton.access$400(1.access$100(this.this$1)).showOpenDialog(1.access$300(this.this$1));
                        ReadFilesJButton.access$400(1.access$100(this.this$1));
                        if (n != 0) {
                            return;
                        }
                        if (1.access$500(this.this$1) == SINGLE_FILE_MODE) {
                            ReadFilesJButton.access$600(1.access$100(this.this$1), ReadFilesJButton.access$400(1.access$100(this.this$1)).getSelectedFile());
                        } else if (1.access$500(this.this$1) == MULTIPLE_FILES_MODE) {
                            ReadFilesJButton.access$700(1.access$100(this.this$1), ReadFilesJButton.access$400(1.access$100(this.this$1)).getSelectedFiles());
                        } else if (1.access$500(this.this$1) == FOLDER_MODE && (file = ReadFilesJButton.access$400(1.access$100(this.this$1)).getSelectedFile()).isDirectory()) {
                            String[] stringArray = file.list(new ReadFilenameFilter());
                            for (int i = 0; i < stringArray.length; ++i) {
                                ReadFilesJButton.access$600(1.access$100(this.this$1), new File(file.getAbsolutePath(), stringArray[i]));
                            }
                        }
                        if (ReadFilesJButton.access$200(1.access$100(this.this$1)) != null) {
                            ReadFilesJButton.access$200(1.access$100(this.this$1)).finishedReading();
                        }
                    }
                };
                Thread thread = new Thread(runnable, "processThread");
                thread.start();
            }

            static /* synthetic */ ReadFilesJButton access$100(1 var0) {
                return var0.ReadFilesJButton.this;
            }

            static /* synthetic */ Component access$300(1 var0) {
                return var0.component;
            }

            static /* synthetic */ Mode access$500(1 var0) {
                return var0.mode;
            }
        });
    }

    private void processFile(File file) {
        Score score = Read.midiOrJmWithSwingMessaging(file, this.owner);
        if (score == null) {
            return;
        }
        if (this.readListenerList != null) {
            score = this.readListenerList.scoreRead(score);
        }
    }

    private void processFiles(File[] fileArray) {
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            this.processFile(fileArray[i]);
        }
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        if (mode == SINGLE_FILE_MODE) {
            this.setText("Read File");
            this.chooser.setDialogTitle("Select a MIDI or jMusic file to import");
            this.chooser.setMultiSelectionEnabled(false);
            this.chooser.setFileSelectionMode(0);
        } else if (mode == MULTIPLE_FILES_MODE) {
            this.setText("Read Files");
            this.chooser.setDialogTitle("Select MIDI and/or jMusic files to import");
            this.chooser.setMultiSelectionEnabled(true);
            this.chooser.setFileSelectionMode(0);
        } else if (mode == FOLDER_MODE) {
            this.setText("Read Folder");
            this.chooser.setDialogTitle("Select a folder of MIDI or jMusic files to import");
            this.chooser.setMultiSelectionEnabled(false);
            this.chooser.setFileSelectionMode(1);
        }
    }

    public Mode getMode() {
        return this.mode;
    }

    public void addReadListener(ReadListener readListener) {
        if (readListener == null) {
            return;
        }
        if (this.readListenerList == null) {
            this.readListenerList = new ReadListenerLinkedList(readListener);
        } else {
            this.readListenerList.add(readListener);
        }
    }

    public void removeReadListener(ReadListener readListener) {
        if (this.readListenerList == null) {
            return;
        }
        if (this.readListenerList.getListener() == readListener) {
            this.readListenerList = this.readListenerList.getNext();
        }
    }

    static /* synthetic */ ReadListenerLinkedList access$200(ReadFilesJButton readFilesJButton) {
        return readFilesJButton.readListenerList;
    }

    static /* synthetic */ JFileChooser access$400(ReadFilesJButton readFilesJButton) {
        return readFilesJButton.chooser;
    }

    static /* synthetic */ void access$600(ReadFilesJButton readFilesJButton, File file) {
        readFilesJButton.processFile(file);
    }

    static /* synthetic */ void access$700(ReadFilesJButton readFilesJButton, File[] fileArray) {
        readFilesJButton.processFiles(fileArray);
    }

    private static class Mode {
        private final String name;

        private Mode(String string) {
            this.name = string;
        }
    }
}

