/*
 * Decompiled with CFR 0.152.
 */
package jm.util;

import java.awt.Button;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import jm.music.data.Score;
import jm.util.Read;
import jm.util.ReadFilenameFilter;
import jm.util.ReadListener;
import jm.util.ReadListenerLinkedList;

public class ReadFolderButton
extends Button {
    private ReadListenerLinkedList readListenerList;

    public ReadFolderButton(final Frame frame) {
        super("Read Folder");
        final FileDialog fileDialog = new FileDialog(frame, "Select a file to read all Midi and JMusic within that file's folder", 0);
        final ReadFilenameFilter readFilenameFilter = new ReadFilenameFilter();
        fileDialog.setFilenameFilter(readFilenameFilter);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                fileDialog.show();
                String string = fileDialog.getDirectory();
                if (string == null) {
                    return;
                }
                String[] stringArray = new File(string).list(readFilenameFilter);
                for (int i = 0; i < stringArray.length; ++i) {
                    Score score = Read.midiOrJmWithAWTMessaging(string, stringArray[i], frame);
                    if (score == null || ReadFolderButton.this.readListenerList == null) continue;
                    ReadFolderButton.this.readListenerList.scoreRead(score);
                }
                if (ReadFolderButton.this.readListenerList != null) {
                    ReadFolderButton.this.readListenerList.finishedReading();
                }
            }
        });
    }

    public void addReadListener(ReadListener readListener) {
        if (readListener == null) {
            return;
        }
        if (this.readListenerList == null) {
            this.readListenerList = new ReadListenerLinkedList(readListener);
        } else {
            this.readListenerList.add(readListener);
        }
    }

    public void removeReadListener(ReadListener readListener) {
        if (this.readListenerList == null) {
            return;
        }
        if (this.readListenerList.getListener() == readListener) {
            this.readListenerList = this.readListenerList.getNext();
        }
    }
}

