/*
 * Decompiled with CFR 0.152.
 */
package jmms;

import grame.midishare.Midi;
import jm.music.data.Score;
import jm.music.data.Tempo;
import jmms.PlayTask;
import jmms.Sequence;
import jmms.Sequencer;
import jmms.TickTask;

public abstract class MPlayer {
    private Tempo tempo = new Tempo();
    private Sequencer seq = new Sequencer();
    private TickTask tickTask;

    public MPlayer() {
        this.seq.setTempo(this.tempo);
    }

    protected void setResolution(double d) {
        this.tickTask.setResolution(d);
    }

    public Sequence nextSequence() {
        return this.seq.getMSSeq(this.nextScore());
    }

    public Score nextScore() {
        System.out.println("define the music to play by overwriting the nextScore method");
        return null;
    }

    public void go() {
        PlayTask playTask = new PlayTask(Midi.NewEv((int)11));
        this.seq.ScheduleTask(playTask, Midi.GetTime());
        this.tickTask = new TickTask(this);
        this.tickTask.Execute(this.seq, Midi.GetTime());
    }

    public void stop() {
        PlayTask playTask = new PlayTask(Midi.NewEv((int)13));
        this.seq.ScheduleTask(playTask, Midi.GetTime());
        this.tickTask.stop();
        this.seq.panic();
    }

    public void close() {
        this.seq.close();
    }

    public void setTempo(Tempo tempo) {
        this.tempo = tempo;
    }

    public Tempo getTempo() {
        return this.tempo;
    }
}

