/*
 * Decompiled with CFR 0.152.
 */
package jmms;

import grame.midishare.Midi;
import grame.midishare.MidiAppl;
import grame.midishare.MidiException;
import java.util.Enumeration;
import jm.midi.MidiInputListener;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;
import jm.music.data.Tempo;
import jmms.PlayTask;
import jmms.Sequence;

public class Sequencer
extends MidiAppl {
    private int nrefnum;
    private PlayTask playTask;
    private boolean tempoFromScore = false;
    public static int[] msrefnums = new int[10];
    public static int refnumCount = 0;
    private boolean bankStylePrgChg = true;
    private MidiInputListener mil;
    private Tempo tempo;
    double midiTempo = 120.0;
    long lastClock = 0L;
    long thisClock = 0L;
    int timeDif = 0;
    int clockAt = 0;
    int recieveTimeDif = 0;
    boolean useSeq1 = true;
    Sequence sequence;
    Sequence sequence1 = new Sequence();
    Sequence sequence2 = new Sequence();
    private int[] instruments = new int[20];
    private int[] volumes = new int[20];
    int count = 0;

    public Sequencer() {
        try {
            this.Open("seq");
        }
        catch (MidiException midiException) {
            System.out.println((Object)midiException);
        }
        Sequencer.msrefnums[Sequencer.refnumCount++] = this.refnum;
        Midi.Connect((int)this.refnum, (int)0, (int)1);
        Midi.Connect((int)0, (int)this.refnum, (int)1);
    }

    public void setTempo(Tempo tempo) {
        this.tempo = tempo;
    }

    public void close() {
        Midi.Close((int)this.refnum);
    }

    public double getMidiTempo() {
        return this.midiTempo;
    }

    public int getMidiClockAt() {
        return this.clockAt;
    }

    public boolean isRecievingClock() {
        this.recieveTimeDif = (int)((long)Midi.GetTime() - this.thisClock);
        return this.recieveTimeDif < 2000;
    }

    public void ReceiveAlarm(int n) {
        switch (Midi.GetType((int)n)) {
            case 4: {
                break;
            }
            case 1: 
            case 2: 
            case 10: {
                this.lastClock = this.thisClock;
                this.thisClock = Midi.GetTime();
                this.timeDif = (int)(this.thisClock - this.lastClock);
                this.timeDif *= 6;
                if (this.timeDif != 0) {
                    this.midiTempo = 15000 / this.timeDif;
                }
                ++this.clockAt;
            }
            default: {
                Midi.FreeEv((int)n);
            }
        }
    }

    public void panic() {
        for (int i = 0; i < 16; ++i) {
            int n = Midi.NewEv((int)4);
            Midi.SetChan((int)n, (int)i);
            Midi.SetData0((int)n, (int)123);
            Midi.SendIm((int)this.refnum, (int)n);
            int n2 = 0;
            while (i < 128) {
                int n3 = Midi.NewEv((int)2);
                Midi.SetChan((int)n3, (int)i);
                Midi.SetData0((int)n3, (int)n2);
                Midi.SendIm((int)this.refnum, (int)n3);
                ++i;
            }
            n2 = Midi.NewEv((int)4);
            Midi.SetChan((int)n2, (int)i);
            Midi.SetData0((int)n2, (int)122);
            Midi.SendIm((int)this.refnum, (int)n2);
        }
    }

    public Sequence getMSSeq(Score score) {
        if (score == null) {
            System.out.println("score is null");
            return null;
        }
        if (this.tempoFromScore) {
            this.tempo.setTempo(score.getTempo());
        }
        this.sequence = this.useSeq1 ? this.sequence1 : this.sequence2;
        this.sequence.reset();
        Enumeration enumeration = score.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            this.partIntoSeq(part, this.sequence);
        }
        this.useSeq1 = !this.useSeq1;
        return this.sequence;
    }

    private void partIntoSeq(Part part, Sequence sequence) {
        try {
            if (part == null) {
                new NullPointerException();
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.toString();
            return;
        }
        if (this.instruments[part.getChannel()] != part.getInstrument()) {
            if (this.bankStylePrgChg) {
                Sequencer.sendPrgChng(part.getInstrument(), part.getChannel(), refnumCount - 1);
            } else {
                Sequencer.sendPrgChng(part.getInstrument(), part.getChannel(), refnumCount);
            }
            this.instruments[part.getChannel()] = part.getInstrument();
        }
        Enumeration enumeration = part.getPhraseList().elements();
        while (enumeration.hasMoreElements()) {
            Phrase phrase = (Phrase)enumeration.nextElement();
            this.phraseIntoSeq(phrase, part.getChannel(), sequence);
        }
    }

    private void phraseIntoSeq(Phrase phrase, int n, Sequence sequence) {
        try {
            if (phrase == null) {
                new NullPointerException();
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.toString();
            return;
        }
        int n2 = 0;
        int n3 = 0;
        Enumeration enumeration = phrase.getNoteList().elements();
        double d = 0.0;
        double d2 = phrase.getStartTime();
        while (enumeration.hasMoreElements()) {
            n2 = this.inMillis(d + d2, this.tempo.getPerMinute());
            Note note = (Note)enumeration.nextElement();
            double d3 = note.getDuration();
            int n4 = this.inMillis(d3, this.tempo.getPerMinute());
            n3 = this.makeMSNote(note.getPitch(), note.getDynamic(), this.inMillis(note.getDuration(), this.tempo.getPerMinute()), n2, n);
            sequence.addMidishareEvent(n3);
            d += note.getRhythmValue();
        }
    }

    public void sendPrgChng(int n, int n2) {
        int n3 = Midi.NewEv((int)5);
        if (n3 != 0) {
            Midi.SetChan((int)n3, (int)n2);
            Midi.SetField((int)n3, (int)0, (int)n);
            Midi.SetDate((int)n3, (int)0);
        }
        Midi.SendIm((int)this.refnum, (int)n3);
    }

    public static void sendPrgChng(int n, int n2, int n3) {
        int n4;
        Integer n5 = null;
        int n6 = n;
        int n7 = Midi.NewEv((int)5);
        if (n7 != 0) {
            Midi.SetChan((int)n7, (int)n2);
            if (n > 999999) {
                n6 = n % 1000;
                n4 = n / 1000;
                int n8 = n / 1000000;
                Sequencer.sendControllerData(n2, 0, n8, msrefnums[n3]);
                Sequencer.sendControllerData(n2, 32, n4 %= 1000, msrefnums[n3]);
            } else if (n > 99) {
                n5 = new Integer(100 + n / 100);
                n6 = n % 100;
            }
            Midi.SetField((int)n7, (int)0, (int)n6);
            Midi.SetDate((int)n7, (int)0);
        }
        if (n5 != null) {
            n4 = Midi.NewEv((int)5);
            Midi.SetChan((int)n4, (int)n2);
            Midi.SetField((int)n4, (int)0, (int)n5);
            Midi.SetDate((int)n4, (int)0);
            Midi.SendIm((int)msrefnums[n3], (int)n4);
            Midi.SetDate((int)n7, (int)2000);
        }
        Midi.SendIm((int)msrefnums[n3], (int)n7);
    }

    public void sendVol(int n, int n2) {
        int n3 = Midi.NewEv((int)4);
        if (n3 != 0) {
            Midi.SetChan((int)n3, (int)n);
            Midi.SetField((int)n3, (int)0, (int)7);
            Midi.SetField((int)n3, (int)1, (int)n2);
            Midi.SetDate((int)n3, (int)0);
        }
        Midi.SendIm((int)this.refnum, (int)n3);
    }

    public static void sendVol(int n, int n2, int n3) {
        int n4 = Midi.NewEv((int)4);
        if (n4 != 0) {
            Midi.SetChan((int)n4, (int)n);
            Midi.SetField((int)n4, (int)0, (int)7);
            Midi.SetField((int)n4, (int)1, (int)n2);
            Midi.SetDate((int)n4, (int)0);
        }
        Midi.SendIm((int)msrefnums[n3], (int)n4);
    }

    public static void sendControllerData(int n, int n2, int n3, int n4) {
        int n5 = Midi.NewEv((int)4);
        if (n5 != 0) {
            Midi.SetChan((int)n5, (int)n);
            Midi.SetField((int)n5, (int)0, (int)n2);
            Midi.SetField((int)n5, (int)1, (int)n3);
            Midi.SetDate((int)n5, (int)0);
        }
        Midi.SendIm((int)msrefnums[n4], (int)n5);
    }

    public void setTempoFromScore(boolean bl) {
        this.tempoFromScore = bl;
    }

    private int inMillis(double d, double d2) {
        double d3 = d * 60000.0 / d2;
        return (int)(d3 + 0.5);
    }

    private int makeMSNote(int n, int n2, int n3, int n4, int n5) {
        int n6 = Midi.NewEv((int)0);
        if (n6 != 0) {
            this.p("setting parameters");
            Midi.SetChan((int)n6, (int)n5);
            Midi.SetField((int)n6, (int)0, (int)n);
            Midi.SetField((int)n6, (int)1, (int)n2);
            Midi.SetField((int)n6, (int)2, (int)n3);
            Midi.SetDate((int)n6, (int)n4);
        }
        return n6;
    }

    public void setMidiInput(MidiInputListener midiInputListener) {
        this.mil = midiInputListener;
    }

    private void p(String string) {
    }
}

