/*
 * Decompiled with CFR 0.152.
 */
package jmqt;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jm.JMC;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;
import jmqt.QTUtil;
import quicktime.QTException;
import quicktime.QTSession;
import quicktime.app.time.Ticklish;
import quicktime.app.time.Timer;

public final class QTCycle
implements JMC,
ChangeListener,
ActionListener,
Ticklish {
    private Thread myThread;
    private QTUtil qtu1;
    private Object obj;
    private Score score = new Score();
    private double tempo = 60.0;
    private double nextTempo = 0.0;
    private double scoreLength = 1.0;
    private double waitTime;
    private double anticipationAmt = 0.0;
    private int cycleCount = 0;
    private double time;
    private JSlider tempoSlider;
    private JSlider sleepSlider;
    private JSlider gapSlider;
    private JLabel tempoNumber;
    private JLabel sleepNumber;
    private JLabel gapNumber;
    private JButton startButton;
    private JButton stopButton;
    private boolean newScoreFlag = true;
    private Timer timer;

    public QTCycle() {
        this(new Score(new Part(new Phrase(new Note(Integer.MIN_VALUE, 0.125)))));
    }

    public QTCycle(Score score) {
        this.obj = this.obj;
        this.score = score;
        this.scoreLength = score.getEndTime();
        this.tempo = score.getTempo();
        this.qtu1 = new QTUtil(this.score);
        try {
            QTSession.open();
            int n = (int)(1000.0 * this.scoreLength * 60.0 / this.tempo);
            this.timer = new Timer(1000, n, (Ticklish)this);
            this.timer.setRate(1.0f);
        }
        catch (QTException qTException) {
            System.out.println("Timer error");
        }
    }

    public void startPlayback() {
        try {
            this.timer.setActive(true);
        }
        catch (QTException qTException) {
            System.out.println("Timer playback error");
        }
    }

    private void playCycle() {
        this.updateTempo();
        this.qtu1.setSpeed(this.tempo / 60.0);
        if (this.newScoreFlag) {
            this.qtu1.playback(this.score);
            this.newScoreFlag = false;
        } else {
            this.qtu1.replay();
        }
        ++this.cycleCount;
    }

    public void setScoreLength(double d) {
        if (d > 0.0) {
            this.scoreLength = d;
        }
        int n = (int)(1000.0 * this.scoreLength * 60.0 / this.tempo);
        try {
            this.timer = new Timer(1000, n, (Ticklish)this);
            this.timer.setRate(1.0f);
        }
        catch (QTException qTException) {
            System.out.println("Timer error");
        }
    }

    public double getScoreLength() {
        return this.scoreLength;
    }

    public void setScore(Score score) {
        this.score = score.copy();
        this.scoreLength = score.getEndTime();
        this.tempo = score.getTempo();
        this.newScoreFlag = true;
    }

    public void setTempo(double d) {
        if (d > 0.0) {
            this.tempo = d;
        }
    }

    public double getTempo() {
        return this.tempo;
    }

    public void setNextTempo(double d) {
        if (d > 0.0) {
            this.nextTempo = d;
        }
    }

    public void updateTempo() {
        if (this.nextTempo != 0.0) {
            this.tempo = this.nextTempo;
            this.nextTempo = 0.0;
        }
    }

    public void setThreadPriority(int n) {
        this.myThread.setPriority(n);
    }

    public void setCycleCount(int n) {
        this.cycleCount = n;
    }

    public int getCycleCount() {
        return this.cycleCount;
    }

    public QTUtil getQTUtil() {
        return this.qtu1;
    }

    public void resumePlayback() {
        try {
            this.timer.setActive(true);
        }
        catch (QTException qTException) {
            System.out.println("Timer resume error");
        }
    }

    public void suspendPlayback() {
        try {
            this.timer.setActive(false);
        }
        catch (QTException qTException) {
            System.out.println("Timer error");
        }
    }

    public void setAnticipationAmt(double d) {
        this.anticipationAmt = d;
    }

    public double getAnticipationAmt() {
        return this.anticipationAmt;
    }

    public void settings() {
        JFrame jFrame = new JFrame("Thread GUI");
        jFrame.setSize(400, 200);
        Box box = new Box(0);
        Box box2 = new Box(1);
        JLabel jLabel = new JLabel("Tempo");
        box2.add(jLabel);
        this.tempoSlider = new JSlider(1, 20, 200, 120);
        this.tempoSlider.addChangeListener(this);
        box2.add(this.tempoSlider);
        this.tempoNumber = new JLabel("120");
        box2.add(this.tempoNumber);
        box.add(box2);
        Box box3 = new Box(1);
        JLabel jLabel2 = new JLabel("Anticipation");
        box3.add(jLabel2);
        this.gapSlider = new JSlider(1, 0, 100, (int)this.anticipationAmt);
        this.gapSlider.addChangeListener(this);
        box3.add(this.gapSlider);
        this.gapNumber = new JLabel(Double.toString(this.anticipationAmt));
        box3.add(this.gapNumber);
        box.add(box3);
        Box box4 = new Box(1);
        this.startButton = new JButton("Start");
        this.startButton.addActionListener(this);
        box4.add(this.startButton);
        this.stopButton = new JButton("Stop");
        this.stopButton.addActionListener(this);
        box4.add(this.stopButton);
        box.add(box4);
        jFrame.getContentPane().add(box);
        jFrame.setVisible(true);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.tempoSlider) {
            this.changeTempo();
        }
        if (changeEvent.getSource() == this.gapSlider) {
            this.changeGap();
        }
    }

    private void changeTempo() {
        this.tempo = this.tempoSlider.getValue();
        this.tempoNumber.setText(Integer.toString(this.tempoSlider.getValue()));
    }

    private void changeGap() {
        this.anticipationAmt = this.gapSlider.getValue();
        this.gapNumber.setText(Integer.toString(this.gapSlider.getValue()));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.startButton) {
            this.resumePlayback();
        }
        if (actionEvent.getSource() == this.stopButton) {
            this.suspendPlayback();
        }
    }

    public boolean tickle(float f, int n) {
        this.playCycle();
        return true;
    }

    public void timeChanged(int n) {
    }
}

