/*
 * Decompiled with CFR 0.152.
 */
package jmqt;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import jm.JMC;
import jm.audio.Instrument;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;
import jm.util.View;
import jm.util.Write;
import jmqt.QTUtil;

public class QTHelperGUI
extends Frame
implements JMC,
ActionListener,
AdjustmentListener {
    protected Score score = new Score();
    private Button composeBtn;
    private Button playBtn;
    private Button stopBtn;
    private Button showBtn;
    private Button printBtn;
    private Button saveBtn;
    private Button renderBtn;
    private TextField midiName;
    private TextField audioName;
    private Scrollbar sliderA;
    private Scrollbar sliderB;
    private Scrollbar sliderC;
    private Scrollbar sliderD;
    private Scrollbar sliderE;
    private Label labelA;
    private Label labelB;
    private Label labelC;
    private Label labelD;
    private Label labelE;
    private QTUtil qtu = new QTUtil();
    protected Instrument[] insts;
    protected int variableA;
    protected int variableB;
    protected int variableC;
    protected int variableD;
    protected int variableE;

    public QTHelperGUI() {
        super("jMusic Helper Interface");
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(7, 1));
        this.add((Component)panel, "North");
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(6, 1));
        this.add((Component)panel2, "Center");
        Panel panel3 = new Panel();
        Panel panel4 = new Panel();
        Panel panel5 = new Panel();
        Panel panel6 = new Panel();
        Label label = new Label("Create and Review");
        label.setAlignment(1);
        panel.add(label);
        panel.add(panel3);
        panel.add(panel4);
        Label label2 = new Label("Save as...");
        label2.setAlignment(1);
        panel.add(label2);
        panel.add(panel5);
        panel.add(panel6);
        Label label3 = new Label("Control compositional parameters");
        label3.setAlignment(1);
        panel.add(label3);
        this.composeBtn = new Button("Compose");
        this.composeBtn.addActionListener(this);
        panel3.add(this.composeBtn);
        this.playBtn = new Button("QT Play");
        this.playBtn.addActionListener(this);
        this.playBtn.setEnabled(false);
        panel3.add(this.playBtn);
        this.stopBtn = new Button("QT Stop");
        this.stopBtn.addActionListener(this);
        this.stopBtn.setEnabled(false);
        panel3.add(this.stopBtn);
        this.showBtn = new Button("View.show()");
        this.showBtn.addActionListener(this);
        this.showBtn.setEnabled(false);
        panel4.add(this.showBtn);
        this.printBtn = new Button("View.print()");
        this.printBtn.addActionListener(this);
        this.printBtn.setEnabled(false);
        panel4.add(this.printBtn);
        this.saveBtn = new Button("Write.midi()");
        this.saveBtn.addActionListener(this);
        this.saveBtn.setEnabled(false);
        panel5.add(this.saveBtn);
        this.midiName = new TextField("FileName.mid", 20);
        panel5.add(this.midiName);
        this.renderBtn = new Button("Write.au()");
        this.renderBtn.addActionListener(this);
        this.renderBtn.setEnabled(false);
        panel6.add(this.renderBtn);
        this.audioName = new TextField("FileName.au", 20);
        panel6.add(this.audioName);
        Panel panel7 = new Panel(new BorderLayout());
        this.labelA = new Label(" variableA = 0     ");
        panel7.add((Component)this.labelA, "West");
        this.sliderA = new Scrollbar(0, 0, 15, 0, 142);
        this.sliderA.addAdjustmentListener(this);
        panel7.add((Component)this.sliderA, "Center");
        panel2.add(panel7);
        Panel panel8 = new Panel(new BorderLayout());
        this.labelB = new Label(" variableB = 0     ");
        panel8.add((Component)this.labelB, "West");
        this.sliderB = new Scrollbar(0, 0, 15, 0, 142);
        this.sliderB.addAdjustmentListener(this);
        panel8.add((Component)this.sliderB, "Center");
        panel2.add(panel8);
        Panel panel9 = new Panel(new BorderLayout());
        this.labelC = new Label(" variableC = 0     ");
        panel9.add((Component)this.labelC, "West");
        this.sliderC = new Scrollbar(0, 0, 15, 0, 142);
        this.sliderC.addAdjustmentListener(this);
        panel9.add((Component)this.sliderC, "Center");
        panel2.add(panel9);
        Panel panel10 = new Panel(new BorderLayout());
        this.labelD = new Label(" variableD = 0     ");
        panel10.add((Component)this.labelD, "West");
        this.sliderD = new Scrollbar(0, 0, 15, 0, 142);
        this.sliderD.addAdjustmentListener(this);
        panel10.add((Component)this.sliderD, "Center");
        panel2.add(panel10);
        Panel panel11 = new Panel(new BorderLayout());
        this.labelE = new Label(" variableE = 0     ");
        panel11.add((Component)this.labelE, "West");
        this.sliderE = new Scrollbar(0, 0, 15, 0, 142);
        this.sliderE.addAdjustmentListener(this);
        panel11.add((Component)this.sliderE, "Center");
        panel2.add(panel11);
        Label label4 = new Label(" ");
        panel2.add(label4);
        this.pack();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.composeBtn) {
            this.composeScore();
        }
        if (actionEvent.getSource() == this.playBtn) {
            this.playScore();
        }
        if (actionEvent.getSource() == this.stopBtn) {
            this.stopScore();
        }
        if (actionEvent.getSource() == this.showBtn) {
            this.showScore();
        }
        if (actionEvent.getSource() == this.printBtn) {
            this.printScore();
        }
        if (actionEvent.getSource() == this.saveBtn) {
            this.saveScore();
        }
        if (actionEvent.getSource() == this.renderBtn) {
            this.renderScore();
        }
    }

    private void composeScore() {
        this.playBtn.setEnabled(true);
        this.stopBtn.setEnabled(true);
        this.showBtn.setEnabled(true);
        this.printBtn.setEnabled(true);
        this.saveBtn.setEnabled(true);
        this.renderBtn.setEnabled(true);
        this.score = this.compose();
    }

    protected Score compose() {
        Phrase phrase = new Phrase();
        Score score = new Score(new Part(phrase));
        Note note = new Note(48 + (int)(Math.random() * (double)this.variableA), 0.5 + (double)this.variableB * 0.25);
        phrase.addNote(note);
        return score;
    }

    private void playScore() {
        this.qtu.stopPlayback();
        this.qtu.playback(this.score);
    }

    private void stopScore() {
        this.qtu.stopPlayback();
    }

    private void showScore() {
        View.show(this.score, this.getSize().width + 15, 0);
    }

    private void printScore() {
        View.print(this.score);
    }

    private void saveScore() {
        String string = this.midiName.getText().trim();
        if (string != null) {
            Write.midi(this.score, string);
        } else {
            Write.midi(this.score);
        }
    }

    private void renderScore() {
        String string = this.audioName.getText().trim();
        if (string != null) {
            Write.au(this.score, string, this.insts);
        } else {
            Write.au(this.score, "RenderedFile.au", this.insts);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getSource() == this.sliderA) {
            this.labelA.setText(" variableA = " + this.sliderA.getValue());
            this.variableA = new Integer(this.sliderA.getValue());
        }
        if (adjustmentEvent.getSource() == this.sliderB) {
            this.labelB.setText(" variableB = " + this.sliderB.getValue());
            this.variableB = new Integer(this.sliderB.getValue());
        }
        if (adjustmentEvent.getSource() == this.sliderC) {
            this.labelC.setText(" variableC = " + this.sliderC.getValue());
            this.variableC = new Integer(this.sliderC.getValue());
        }
        if (adjustmentEvent.getSource() == this.sliderD) {
            this.labelD.setText(" variableD = " + this.sliderD.getValue());
            this.variableD = new Integer(this.sliderD.getValue());
        }
        if (adjustmentEvent.getSource() == this.sliderE) {
            this.labelE.setText(" variableE = " + this.sliderE.getValue());
            this.variableE = new Integer(this.sliderE.getValue());
        }
    }
}

