/*
 * Decompiled with CFR 0.152.
 */
package jmqt;

import jm.JMC;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;
import quicktime.QTException;
import quicktime.QTSession;
import quicktime.sound.SoundConstants;
import quicktime.std.StdQTConstants;
import quicktime.std.StdQTException;
import quicktime.std.music.MusicData;
import quicktime.std.music.MusicMIDIPacket;
import quicktime.std.music.NoteAllocator;
import quicktime.std.music.NoteChannel;
import quicktime.std.music.ToneDescription;
import quicktime.std.music.TunePlayer;

public class QTUtil
implements JMC,
StdQTConstants,
SoundConstants {
    private TunePlayer tunePlayer1;
    private MusicData tune1;
    private boolean usingTuneOne = true;
    private Score score;
    private NoteChannel[] nc1 = new NoteChannel[16];
    private double speed = 1.0;
    private ToneDescription td;
    private double tempoMultiplier = 600.0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QTUtil() {
        try {
            QTSession.open();
            this.tunePlayer1 = new TunePlayer();
            this.setupNoteChannels();
            this.tunePlayer1.setNoteChannels(this.nc1);
            this.td = new ToneDescription(1);
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
        }
    }

    public QTUtil(Score score) {
        try {
            QTSession.open();
            this.tunePlayer1 = new TunePlayer();
            this.setupNoteChannels();
            this.tunePlayer1.setNoteChannels(this.nc1);
            this.setScore(score);
            this.td = new ToneDescription(1);
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
        }
    }

    public void setScore(Score score) {
        this.score = score;
        try {
            this.usingTuneOne = !this.usingTuneOne;
            this.setUp();
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
        }
    }

    public Score getScore() {
        return this.score;
    }

    private void setUp() throws QTException {
        if (this.score == null) {
            System.err.println("jMusic QTtil error: The score is null. Please initialise before using.");
        }
        this.score.clean();
        if (this.totalNotesInScore() < 1) {
            System.err.println(new Exception("jMusic EXCEPTION: QTUtil Error: The Score is empty!"));
            new Exception().printStackTrace();
        }
        this.speed = this.score.getTempo() / 60.0;
        this.setGMInstruments();
        int n = this.totalNotesInScore();
        double[][] dArray = new double[n][4];
        dArray = this.sortNotes(this.score, n);
        int n2 = (n * 2 + 1) * 4;
        this.tune1 = this.convertFromScore(this.score, dArray, n2);
    }

    private void setupNoteChannels() throws QTException {
        int n = 16385;
        for (int i = 0; i < 16; ++i) {
            if (i != 9) {
                this.nc1[i] = new NoteChannel(1, 6);
                continue;
            }
            this.nc1[9] = new NoteChannel(n, 8);
        }
    }

    private void setGMInstruments() throws StdQTException {
        int n = this.score.size();
        for (int i = 0; i < n; ++i) {
            Part part = this.score.getPart(i);
            if (part.getInstrument() == 250) continue;
            if (part.getChannel() != 9) {
                this.nc1[part.getChannel()].setInstrumentNumber(part.getInstrument() + 1);
                continue;
            }
            this.nc1[9].setInstrumentNumber(part.getInstrument() + 16385);
        }
    }

    private int totalNotesInScore() {
        int n = 0;
        int n2 = this.score.size();
        for (int i = 0; i < n2; ++i) {
            Part part = this.score.getPart(i);
            int n3 = part.size();
            for (int j = 0; j < n3; ++j) {
                n += part.getPhrase(j).size();
            }
        }
        return n;
    }

    private double[][] sortNotes(Score score, int n) {
        double[][] dArray = new double[n][4];
        int n2 = 0;
        int n3 = score.size();
        for (int i = 0; i < n3; ++i) {
            Part part = score.getPart(i);
            int n4 = part.size();
            for (int j = 0; j < n4; ++j) {
                Phrase phrase = part.getPhrase(j);
                double d = phrase.getStartTime();
                for (int k = 0; k < phrase.size(); ++k) {
                    if (k == 0 && (d += phrase.getNote(k).getOffset()) < 0.0) {
                        d = 0.0;
                        Note note = phrase.getNote(k);
                        note.setRhythmValue(note.getRhythmValue() + note.getOffset());
                    }
                    dArray[n2][0] = d;
                    dArray[n2][1] = i;
                    dArray[n2][2] = j;
                    dArray[n2][3] = k;
                    d += phrase.getNote(k).getRhythmValue();
                    if (k > 0) {
                        d = d - phrase.getNote(k - 1).getOffset() + phrase.getNote(k).getOffset();
                    }
                    if (d < 0.0) {
                        d = 0.0;
                    }
                    ++n2;
                }
            }
        }
        this.quickSort(dArray, 0, dArray.length - 1);
        return dArray;
    }

    private void quickSort(double[][] dArray, int n, int n2) {
        if (n >= n2) {
            return;
        }
        QTUtil.swap(dArray, n, (int)(Math.random() * (double)(n2 - n)) + n);
        int n3 = n;
        for (int i = n + 1; i <= n2; ++i) {
            if (!(dArray[i][0] <= dArray[n][0])) continue;
            QTUtil.swap(dArray, ++n3, i);
        }
        QTUtil.swap(dArray, n, n3);
        this.quickSort(dArray, n, n3 - 1);
        this.quickSort(dArray, n3 + 1, n2);
    }

    static void swap(double[][] dArray, int n, int n2) {
        for (int i = 0; i < 4; ++i) {
            double d = dArray[n][i];
            dArray[n][i] = dArray[n2][i];
            dArray[n2][i] = d;
        }
    }

    private MusicData convertFromScore(Score score, double[][] dArray, int n) throws QTException {
        MusicData musicData = new MusicData(n * 3);
        double d = 0.0;
        double d2 = 0.0;
        int n2 = 0;
        if (dArray[0][0] > 0.0) {
            musicData.setMusicEvent(n2, MusicData.stuffRestEvent((int)((int)(dArray[0][0] * this.tempoMultiplier))));
            ++n2;
            d = dArray[0][0];
        }
        for (int i = 0; i < dArray.length - 1; ++i) {
            Note note = score.getPart((int)dArray[i][1]).getPhrase((int)dArray[i][2]).getNote((int)dArray[i][3]);
            d2 = dArray[i + 1][0] * this.tempoMultiplier - d;
            double d3 = 0.5;
            if (note.getPitch() < 0) {
                musicData.setMusicEvent(n2, MusicData.stuffRestEvent((int)((int)d2)));
                ++n2;
            } else {
                if (note.getPan() != d3) {
                    musicData.setMusicEvent(n2, MusicData.stuffControlEvent((int)(score.getPart((int)dArray[i][1]).getChannel() + 1), (int)10, (int)((int)(note.getPan() * 256.0) + 256)));
                    ++n2;
                    d3 = note.getPan();
                }
                musicData.setXMusicEvent(n2, MusicData.stuffXNoteEvent((int)(score.getPart((int)dArray[i][1]).getChannel() + 1), (int)(note.getPitch() * 256), (int)note.getDynamic(), (int)((int)(note.getDuration() * this.tempoMultiplier))));
                musicData.setMusicEvent(n2 += 2, MusicData.stuffRestEvent((int)((int)d2)));
                ++n2;
            }
            d += d2;
        }
        Note note = score.getPart((int)dArray[dArray.length - 1][1]).getPhrase((int)dArray[dArray.length - 1][2]).getNote((int)dArray[dArray.length - 1][3]);
        if (note.getPitch() < 0) {
            musicData.setMusicEvent(n2, MusicData.stuffRestEvent((int)((int)(note.getRhythmValue() * this.tempoMultiplier))));
            ++n2;
        } else {
            musicData.setMusicEvent(n2, MusicData.stuffControlEvent((int)(score.getPart((int)dArray[dArray.length - 1][1]).getChannel() + 1), (int)10, (int)((int)(note.getPan() * 256.0) + 256)));
            musicData.setXMusicEvent(++n2, MusicData.stuffXNoteEvent((int)(score.getPart((int)dArray[dArray.length - 1][1]).getChannel() + 1), (int)(note.getPitch() * 256), (int)note.getDynamic(), (int)((int)(note.getDuration() * this.tempoMultiplier))));
            n2 += 2;
        }
        return musicData;
    }

    public void playback(Score score) {
        this.setScore(score);
        this.replay();
    }

    public void replay() {
        try {
            if (this.tunePlayer1 != null) {
                this.tunePlayer1.queue(this.tune1, (float)this.speed, 0, Integer.MAX_VALUE, 0);
            } else {
                System.out.println("jMusic QTUtil error: Woops! No score to play.");
            }
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
        }
    }

    public void stopPlayback() {
        try {
            if (this.tunePlayer1 != null) {
                this.tunePlayer1.stop();
            }
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
        }
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double d) {
        this.speed = d;
    }

    public void playOneNote(Note note, int n) {
        int n2 = note.getPitch();
        try {
            NoteChannel noteChannel = this.nc1[n];
            noteChannel.playNote((float)n2, note.getDynamic());
            try {
                Thread.sleep((long)(note.getDuration() * 1000.0));
            }
            catch (InterruptedException interruptedException) {
                System.out.println("jMusic QTUtil ERROR: Problem sleeping single note playback thread");
                noteChannel.playNote((float)n2, 0);
            }
            noteChannel.playNote((float)n2, 0);
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
        }
    }

    public void sendMIDIControlChange(int n, int n2, int n3) {
        int[] nArray = new int[]{n2, n3};
        this.sendMIDIMessage(176, n, nArray);
    }

    public void sendMIDIMessage(int n, int n2, int[] nArray) {
        NoteChannel noteChannel = this.nc1[n2];
        byte[] byArray = new byte[nArray.length + 1];
        MusicMIDIPacket musicMIDIPacket = new MusicMIDIPacket(byArray);
        musicMIDIPacket.setDataByte(0, n + n2);
        for (int i = 0; i < nArray.length; ++i) {
            musicMIDIPacket.setDataByte(i + 1, nArray[i]);
        }
        try {
            noteChannel.sendMIDI(musicMIDIPacket);
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
        }
    }

    public void setNoteInstrument() {
        try {
            this.td.pickInstrument(NoteAllocator.getDefault(), "Choose an Instrument...", 0);
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
        }
    }

    public void finalize() {
        QTSession.close();
    }
}

