#
# Set a bunch of things to hardcoded paths so that we don't accidently
# pick up a user's own version of some utility and hose ourselves.
#
BINDIR=			${PREFIX}/bin
MANDIR=			${PREFIX}/man/ja/man
EMANDIR=		${PREFIX}/man/man
libdir=			${PREFIX}/etc
libexecdir=		${PREFIX}/libexec
bindir=			${BINDIR}
pager=			jless -s
manpath_config_file=	/etc/manpath.config
troff=			${bindir}/groff -S -mandoc
nroff=                  ${bindir}/groff -S -Wall -Tnippon -mtty-char -mandoc
apropos=		${bindir}/japropos
whatis=			${bindir}/jwhatis
neqn=                   ${bindir}/geqn -Tascii
tbl=			${bindir}/gtbl
col=
vgrind=
refer=			${bindir}/refer
grap=			# no grap
pic=			${bindir}/gpic
zcat=			${GZCAT}
compress=		${GZIP_CMD}
compext=		.gz

.if exists(${.OBJDIR}/../lib)
LIBDESTDIR=            ${.OBJDIR}/../lib
.else
LIBDESTDIR=            ${.CURDIR}/../lib
.endif

LIBMAN=        ${LIBDESTDIR}/libman.a
