require 'rpdf/crossreftable'
require 'rpdf/documentcatalog'
require 'rpdf/pagetree'
require 'rpdf/trailer'
require 'rpdf/version'

module RPDF
  class Document
    attr_reader :pdf_version, :pagetree, :root, :xrefs

    def initialize(pdf, pdf_version = VERSION_DEFAULT)
	  @pdf = pdf
      @pdf_version = pdf_version
      @objects = Array.new
      @pagetree = PageTree.new(self)
      @root = DocumentCatalog.new(self)
      @xrefs = CrossRefTable.new
	  
	  # File Header [PDFRef15 p68]
      bytes = @pdf_version.to_pdf
      bytes << "\n"  # Ensure file transfer applications detect the file as binary. [PDFRef15 p69]
	  @numwritten = bytes.size
	  @pdf.write(bytes)
	  
    end

    def new_id(object)
      @objects << object
      @objects.size
    end

    def size
      @objects.size
    end

    def write(object)
	  objectbytes = object.to_pdf
	  @xrefs.addUsedEntry(@numwritten, object.object_number) # position of the next object in the PDF file
	  @pdf.write(objectbytes)
	  @numwritten = @numwritten + objectbytes.size
	end

    def close_pdf
      trailer = Trailer.new(self)
	  bytes = String.new
         
      # File Body [PDFRef15 p69]
      @objects.each { |object|
		  object.invalidate	unless object.invalidated?
      }

      trailer.startxref = @numwritten

      # Cross-Reference Table [PDFRef15 p69]
      @pdf.write(@xrefs.to_pdf)

      # File Trailer [PDFRef15 p72]
      @pdf.write(trailer.to_pdf)
    end
  end
end
