require 'rpdf/pdfobject'
require 'rpdf/util'

module RPDF

  # Dictionary Object
  # [PDFRef15 p35]
  class PDFDictionary < PDFObject
    attr_reader :dict
 
    def initialize(dict, document=nil)
      raise Exception.new("PDFDictionary is not a hash") unless dict.kind_of?(Hash)
      @dict = Hash.new
      dict.each { |key, value|
        pdfkey = RPDF.topdfobject(key)
        pdfvalue = RPDF.topdfobject(value)
        raise Exception.new("PDFDictionary key must be a name") unless pdfkey.kind_of?(PDFName)
        @dict[pdfkey] = pdfvalue
      }
      super(document)
    end

    def [](key)
      pdfkey = RPDF.topdfobject(key)
      raise Exception.new("PDFDictionary key must be a name") unless pdfkey.kind_of?(PDFName)
      @dict[pdfkey]
    end

    def []=(key, value)
      pdfkey = RPDF.topdfobject(key)
      pdfvalue = RPDF.topdfobject(value)
      raise Exception.new("PDFDictionary key must be a name") unless pdfkey.kind_of?(PDFName)
      @dict[pdfkey] = pdfvalue
    end

    # Update dictionary with other dictionary
    def update(other)
      @dict.update(other.dict)
    end

    def to_s
      bytes = "<< "
      @dict.each { |key, value|
        bytes << "#{key.to_s} #{value.to_ref}\n" # to_ref -> reference to indirect object
      }
      bytes << ">>\n"
    end

  end

end
