require 'rpdf/pdfobject'
require 'rpdf/util'

module RPDF

  # Name Object
  # [PDFRef15 p32]
  class PDFName < PDFObject
    attr_reader :value
 
    def initialize(value, document=nil)
      raise Exception.new("PDFName is not a string") unless value.kind_of?(String)
      raise Exception.new("PDFName has whitespace") if RPDF.includes_whitespace?(value)
      raise Exception.new("PDFName has delimiter") if RPDF.includes_delimiter?(value)
      @value = value
      super(document)
    end

    def hash
      @value.hash
    end

    # To make PDFName possible to use as a key in a PDFDictionary
    def eql?(other)
      @value.eql?(other.value)
    end

    # TODO: 2-digit hexadecimal code for characters outside the range 33 (!) to 126 (~) [PDFRef15 p33]
    def to_s
      "/#{@value}"
    end

  end

end
