require 'rpdf/pdfobject'

module RPDF

  # Numeric Object
  # [PDFRef15 p28]
  class PDFNumeric < PDFObject
    include Comparable

    attr_reader :value

    def initialize(value, document=nil)
      raise Exception.new("PDFNumeric is not a number") unless value.kind_of?(Numeric)
      @value = value
      super(document)
    end

    def <=>(other)
      @value <=> other.value
    end

    def to_s
      @value.to_s
    end

  end

end
