require 'rpdf/pdfdictionary'
require 'rpdf/pdfobject'

module RPDF

  # Stream Object
  # TODO: stream dictionary
  # [PDFRef15 p36]
  class PDFStream < PDFObject
    attr_reader :data, :dict
 
    def initialize(data, document=nil)
      @data = data
      @dict = PDFDictionary.new({ :Length => data.size })
      super(document)
    end

    def invalidate
	  super
	  @data = nil
	end

    def to_s
      bytes = @dict.to_pdf
      bytes << "stream\n"
      bytes << data
      bytes << "\nendstream"
    end

  end

end
