module RPDF

  EOL = "\r\n"

  # [PDFRef15 p26]
  def includes_whitespace?(string)
    string =~ /[\0\t\r\n\f ]/ ? true : false
  end

  def includes_delimiter?(string)
    string =~ /[\(\)<>\[\]{}\/%]/ ? true : false
  end

  # convert basic object to PDF Object
  def topdfobject(object, document=nil)
    if object.kind_of?(TrueClass) or object.kind_of?(FalseClass)
      PDFBoolean.new(object, document)
    elsif object.kind_of?(Integer)
      PDFInteger.new(object, document)
    elsif object.kind_of?(Numeric)
      PDFNumeric.new(object, document)
    elsif object.kind_of?(String)
      PDFString.new(object, document)
    elsif object.kind_of?(Symbol)
      PDFName.new(object.to_s, document)
    elsif object.kind_of?(Array)
      PDFArray.new(object, document)
    elsif object.kind_of?(Hash)
      PDFDictionary.new(object, document)
    elsif object.kind_of?(NilClass)
      PDFNull.new
    elsif object.kind_of?(PDFObject)
      object
    else
      raise Exception.new("Cannot convert #{object.class} to PDF object")
    end 
  end

  module_function :includes_whitespace?, :includes_delimiter?, :topdfobject

end
