module RPDF

  # class describing a PDF version. 
  # Don't use this class directly, but use the constants defined in this file.
  # [PDFRef15 p68]
  class PDFVersion
    include Comparable

    attr_reader :value

    def initialize(version_string)
      @value = version_string
    end

    def <=>(other_version)
      @value <=> other_version.value
    end

    def to_pdf
      "%PDF-#{@value}\n"
    end
  end

  VERSION_10 = PDFVersion.new("1.0")
  VERSION_11 = PDFVersion.new("1.1")
  VERSION_12 = PDFVersion.new("1.2")
  VERSION_13 = PDFVersion.new("1.3")
  VERSION_14 = PDFVersion.new("1.4")
  VERSION_15 = PDFVersion.new("1.5")
  VERSION_DEFAULT = VERSION_14
end
