module RPDF

  # Cross-Reference Table
  # This implementation uses only one cross-reference section
  # and no free entries.
  # [PDFRef15 p69]
  class CrossRefTable

    def initialize
      @hash = Hash.new
    end

    def addUsedEntry(position, objectnumber)
      @hash[objectnumber] = position
    end

    def size
      @hash.size + 1
    end

    def to_pdf
      bytes = "xref\n"
      bytes << "0 #{size}\n"
      bytes << "0000000000 65535 f \n"
      @hash.keys.sort.each { |objectnumber|
        bytes << ("%010d" % @hash[objectnumber]) << " 00000 n \n"
      }
      bytes << "\n"
    end

  end

end
