require 'rpdf/pdfdictionary'

module RPDF

  # Image Dictionary Object
  # [PDFRef15 p303]
  class ImageDictionary < PDFDictionary
 
    # colorspace: :DeviceGrey, :DeviceRGB or :DeviceCMYK
	# bpc: 8, 12 or 16
    def initialize(width, height, colorspace, bpc, document=nil)
      super({ :Type => :XObject,
              :Subtype => :Image,
              :Width => width,
              :Height => height,
              :ColorSpace => colorspace,
              :BitsPerComponent => bpc }, 
            document)
    end

  end

end
