require 'rpdf/pdfdictionary'

module RPDF

  # Page Object
  # [PDFRef15 p118]
  class Page < PDFDictionary
 
    def initialize(document, parent)
      super({ :Type => :Page,
              :Parent => parent,
              :Resources => {},
              :MediaBox => Rectangle.new(0, 0, 612, 792) }, 
            document)

      parent.add_page(self)
    end

  end

end
