require 'rpdf/pdfdictionary'

module RPDF

  # Page Tree Object
  # [PDFRef15 p116]
  class PageTree < PDFDictionary
 
    def initialize(document, parent=nil)
      super({ :Type => :Pages,
              :Parent => parent,
              :Kids => [],
              :Count => 0 }, 
            document)
    end

    def add_page(page)
      self[:Kids] << page
      self[:Count] = self[:Count].value + 1
    end

  end

end
