require 'rpdf/pdfobject'
require 'rpdf/util'

module RPDF

  # Array Object
  # [PDFRef15 p34]
  class PDFArray < PDFObject
    attr_reader :array
 
    def initialize(array, document=nil)
      raise Exception.new("PDFArray is not an array") unless array.kind_of?(Array)
      @array = Array.new
      array.each { |object|
        @array << RPDF.topdfobject(object, document)
      }
      super(document)
    end

    def <<(element)
      @array << RPDF.topdfobject(element)
    end

    def to_s
      bytes = "[ "
      @array.each { |element|
        bytes << element.to_ref # to_ref -> reference to indirect object
        bytes << " "
      }
      bytes << "]"
    end

  end

end
