require 'rpdf/pdfobject'

module RPDF

  # Boolean Object: true or false
  # [PDFRef15 p28]
  class PDFBoolean < PDFObject
    include Comparable

    attr_reader :value

    def initialize(value, document=nil)
      raise Exception.new("PDFBoolean not true nor false") unless (value.kind_of?(TrueClass) or value.kind_of?(FalseClass))
      @value = value
      super(document)
    end

    def <=>(other)
      @value <=> other.value
    end

    def to_s
      @value.to_s
    end

  end

end
