require 'rpdf/pdfnumeric'

module RPDF

  # Integer Object
  # This is not a real PDF Object, as PDF knows only Numerics.
  # [PDFRef15 p28]
  class PDFInteger < PDFNumeric

    def initialize(value, document=nil)
      raise Exception.new("PDFInteger is not an integer") unless value.kind_of?(Integer)
      super
    end

  end

end
