module RPDF

  # An object which is a part of a PDF document. [PDFRef15 p27]
  class PDFObject

    attr_reader :object_number, :generation_number

    # Make an indirect object if a document is passed, otherwise a direct object.
    def initialize(document=nil)
      if document
        @object_number = document.new_id(self)
        @document = document
      else
        @object_number = 0 # The object number of an indirect object should be positive
      end
      @generation_number = 0
      @invalidated = false
    end

    def indirect?
      @object_number > 0
    end
	
	# Subclasses has to call this in their invalidate method if they override it
	def invalidate
	  @document.write(self)
          @invalidated = true
	end
	
	# true if the object has already been written to the PDF stream
	def invalidated?
	  @invalidated
	end

    # Return a representation suitable to write to a PDF file
    # [PDFRef15 p39]
    def to_pdf
      if indirect?
        bytes = "#{@object_number} #{@generation_number} obj\n"
        bytes << to_s << "\n"
        bytes << "endobj\n\n"
      else
        to_s
      end
    end

    # Return an indirect reference to this object if it's indirect,
    # return the bytestream otherwise.
    # [PDFRef15 p39]
    def to_ref
      if indirect?
        "#{@object_number} #{@generation_number} R"
      else
        to_s
      end
    end

  end

end
