require 'rpdf/pdfobject'

module RPDF

  # String Object
  # [PDFRef15 p29]
  class PDFString < PDFObject
    attr_reader :value
 
    attr_accessor :hexadecimal

    def initialize(value, document=nil)
      raise Exception.new("PDFString is not a string") unless value.kind_of?(String)
      @value = value
      @hexadecimal = false
      super(document)
    end

    def ==(other)
      @value == other.value
    end

    def to_s
      if @hexadecimal
        # [PDFRef15 p32]
        hexval = String.new
        @value.each_byte { |byte|
          hexval << "%02X" % byte
        }
        "<#{hexval}>"
      else
        "(#{@value.dump})" # nonprinting characters should be replaced by \nnn and special characters escaped
      end
    end

  end

end
