require 'rpdf/document'
require 'rpdf/pdfdictionary'
require 'rpdf/pdfinteger'
require 'rpdf/pdfname'

module RPDF

  # File Trailer [PDFRef15 p72]
  class Trailer

    attr_accessor :startxref

    def initialize(document)
      @document = document
    end

    def to_pdf
      dict = PDFDictionary.new({ :Size => @document.size + 1,
                                 :Root => @document.root })

      bytes = "trailer\n"
      bytes << dict.to_pdf
      bytes << "\nstartxref\n"
      bytes << startxref.to_s << "\n"
      bytes << "%%EOF\n" 
    end

  end

end
