/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Toolkit;
import java.awt.peer.FontPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Font
implements Serializable {
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    private transient int pData;
    private transient String family;
    protected String name;
    protected int style;
    protected int size;
    transient FontPeer peer;
    private static final long serialVersionUID = -4206021311591459213L;
    private int fontSerializedDataVersion = 1;

    public FontPeer getPeer() {
        return this.peer;
    }

    private void initializeFont() {
        this.family = System.getProperty("awt.font." + this.name.toLowerCase(), this.name);
        this.peer = Toolkit.getDefaultToolkit().getFontPeer(this.name, this.style);
    }

    public Font(String string, int n, int n2) {
        this.name = string;
        this.style = n;
        this.size = n2;
        this.initializeFont();
    }

    public String getFamily() {
        return this.family;
    }

    public String getName() {
        return this.name;
    }

    public int getStyle() {
        return this.style;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isPlain() {
        return this.style == 0;
    }

    public boolean isBold() {
        return (this.style & 1) != 0;
    }

    public boolean isItalic() {
        return (this.style & 2) != 0;
    }

    public static Font getFont(String string) {
        return Font.getFont(string, null);
    }

    public static Font decode(String string) {
        String string2 = string;
        int n = 12;
        int n2 = 0;
        int n3 = string.indexOf(45);
        if (n3 >= 0) {
            string2 = string.substring(0, n3);
            if ((n3 = (string = string.substring(n3 + 1)).indexOf(45)) >= 0) {
                if (string.startsWith("bold-")) {
                    n2 = 1;
                } else if (string.startsWith("italic-")) {
                    n2 = 2;
                } else if (string.startsWith("bolditalic-")) {
                    n2 = 3;
                }
                string = string.substring(n3 + 1);
            }
            try {
                n = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return new Font(string2, n2, n);
    }

    public static Font getFont(String string, Font font) {
        String string2 = System.getProperty(string);
        if (string2 == null) {
            return font;
        }
        return Font.decode(string2);
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.style ^ this.size;
    }

    public boolean equals(Object object) {
        if (object instanceof Font) {
            Font font = (Font)object;
            return this.size == font.size && this.style == font.style && this.name.equals(font.name);
        }
        return false;
    }

    public String toString() {
        String string = this.isBold() ? (this.isItalic() ? "bolditalic" : "bold") : (this.isItalic() ? "italic" : "plain");
        return String.valueOf(this.getClass().getName()) + "[family=" + this.family + ",name=" + this.name + ",style=" + string + ",size=" + this.size + "]";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws ClassNotFoundException, IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.initializeFont();
    }
}

