/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;

public class IndexedPropertyDescriptor
extends PropertyDescriptor {
    private Class indexedPropertyType;
    private Method indexedReadMethod;
    private Method indexedWriteMethod;

    public IndexedPropertyDescriptor(String string, Class clazz) throws IntrospectionException {
        this(string, clazz, "get" + IndexedPropertyDescriptor.capitalize(string), "set" + IndexedPropertyDescriptor.capitalize(string), "get" + IndexedPropertyDescriptor.capitalize(string), "set" + IndexedPropertyDescriptor.capitalize(string));
    }

    public IndexedPropertyDescriptor(String string, Class clazz, String string2, String string3, String string4, String string5) throws IntrospectionException {
        super(string, clazz, string2, string3);
        this.indexedReadMethod = Introspector.findMethod(clazz, string4, 1);
        this.indexedWriteMethod = Introspector.findMethod(clazz, string5, 2);
        this.findIndexedPropertyType();
    }

    public IndexedPropertyDescriptor(String string, Method method, Method method2, Method method3, Method method4) throws IntrospectionException {
        super(string, method, method2);
        this.indexedReadMethod = method3;
        this.indexedWriteMethod = method4;
        this.findIndexedPropertyType();
    }

    public Method getIndexedReadMethod() {
        return this.indexedReadMethod;
    }

    public Method getIndexedWriteMethod() {
        return this.indexedWriteMethod;
    }

    public Class getIndexedPropertyType() {
        return this.indexedPropertyType;
    }

    private void findIndexedPropertyType() throws IntrospectionException {
        Object object;
        this.indexedPropertyType = null;
        if (this.indexedReadMethod != null) {
            object = this.indexedReadMethod.getParameterTypes();
            if (((Class[])object).length != 1) {
                throw new IntrospectionException("bad indexed read method arg count");
            }
            if (object[0] != Integer.TYPE) {
                throw new IntrospectionException("non int index to indexed read method");
            }
            this.indexedPropertyType = this.indexedReadMethod.getReturnType();
            if (this.indexedPropertyType == Void.TYPE) {
                throw new IntrospectionException("indexed read method returns void");
            }
        }
        if (this.indexedWriteMethod != null) {
            object = this.indexedWriteMethod.getParameterTypes();
            if (((Class[])object).length != 2) {
                throw new IntrospectionException("bad indexed write method arg count");
            }
            if (object[0] != Integer.TYPE) {
                throw new IntrospectionException("non int index to indexed write method");
            }
            if (this.indexedPropertyType != null && this.indexedPropertyType != object[1]) {
                throw new IntrospectionException("type mismatch between indexed read and indexed write methods");
            }
            this.indexedPropertyType = object[1];
        }
        if (this.indexedPropertyType == null) {
            throw new IntrospectionException("no indexed getter or setter");
        }
        object = this.getPropertyType();
        if (!(object == null || ((Class)object).isArray() && ((Class)object).getComponentType() == this.indexedPropertyType)) {
            throw new IntrospectionException("type mismatch between indexed and non-indexed methods");
        }
    }

    IndexedPropertyDescriptor(PropertyDescriptor propertyDescriptor, PropertyDescriptor propertyDescriptor2) {
        super(propertyDescriptor, propertyDescriptor2);
        IndexedPropertyDescriptor indexedPropertyDescriptor;
        if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
            indexedPropertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptor;
            this.indexedReadMethod = indexedPropertyDescriptor.indexedReadMethod;
            this.indexedWriteMethod = indexedPropertyDescriptor.indexedWriteMethod;
            this.indexedPropertyType = indexedPropertyDescriptor.indexedPropertyType;
        }
        if (propertyDescriptor2 instanceof IndexedPropertyDescriptor) {
            indexedPropertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptor2;
            if (indexedPropertyDescriptor.indexedReadMethod != null) {
                this.indexedReadMethod = indexedPropertyDescriptor.indexedReadMethod;
            }
            if (indexedPropertyDescriptor.indexedWriteMethod != null) {
                this.indexedWriteMethod = indexedPropertyDescriptor.indexedWriteMethod;
            }
            this.indexedPropertyType = indexedPropertyDescriptor.indexedPropertyType;
        }
    }

    private static String capitalize(String string) {
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toUpperCase(cArray[0]);
        return new String(cArray);
    }
}

