/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.PrintStream;
import sun.misc.VM;

public class ThreadGroup {
    ThreadGroup parent;
    String name;
    int maxPriority;
    boolean destroyed;
    boolean daemon;
    boolean vmAllowSuspension;
    int nthreads;
    Thread[] threads;
    int ngroups;
    ThreadGroup[] groups;

    private ThreadGroup() {
        this.name = "system";
        this.maxPriority = 10;
    }

    public ThreadGroup(String string) {
        this(Thread.currentThread().getThreadGroup(), string);
    }

    public ThreadGroup(ThreadGroup threadGroup, String string) {
        if (threadGroup == null) {
            throw new NullPointerException();
        }
        threadGroup.checkAccess();
        this.name = string;
        this.maxPriority = threadGroup.maxPriority;
        this.daemon = threadGroup.daemon;
        this.vmAllowSuspension = threadGroup.vmAllowSuspension;
        this.parent = threadGroup;
        threadGroup.add(this);
    }

    public final String getName() {
        return this.name;
    }

    public final ThreadGroup getParent() {
        this.checkAccess();
        return this.parent;
    }

    public final int getMaxPriority() {
        return this.maxPriority;
    }

    public final boolean isDaemon() {
        return this.daemon;
    }

    public synchronized boolean isDestroyed() {
        return this.destroyed;
    }

    public final void setDaemon(boolean bl) {
        this.checkAccess();
        this.daemon = bl;
    }

    public final void setMaxPriority(int n) {
        ThreadGroup[] threadGroupArray;
        int n2;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            this.checkAccess();
            if (n < 1) {
                this.maxPriority = 1;
            } else if (n < this.maxPriority) {
                this.maxPriority = n;
            }
            n2 = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n2];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n2);
            } else {
                threadGroupArray = null;
            }
        }
        int n3 = 0;
        while (n3 < n2) {
            threadGroupArray[n3].setMaxPriority(n);
            ++n3;
        }
    }

    public final boolean parentOf(ThreadGroup threadGroup) {
        while (threadGroup != null) {
            if (threadGroup == this) {
                return true;
            }
            threadGroup = threadGroup.parent;
        }
        return false;
    }

    public final void checkAccess() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkAccess(this);
        }
    }

    public int activeCount() {
        ThreadGroup[] threadGroupArray;
        int n;
        int n2;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                int n3 = 0;
                Object var6_4 = null;
                return n3;
            }
            n2 = this.nthreads;
            n = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n);
            } else {
                threadGroupArray = null;
            }
        }
        int n4 = 0;
        while (n4 < n) {
            n2 += threadGroupArray[n4].activeCount();
            ++n4;
        }
        return n2;
    }

    public int enumerate(Thread[] threadArray) {
        return this.enumerate(threadArray, 0, true);
    }

    public int enumerate(Thread[] threadArray, boolean bl) {
        return this.enumerate(threadArray, 0, bl);
    }

    private int enumerate(Thread[] threadArray, int n, boolean bl) {
        int n2 = 0;
        ThreadGroup[] threadGroupArray = null;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                int n3 = 0;
                Object var8_9 = null;
                return n3;
            }
            int n4 = this.nthreads;
            if (n4 > threadArray.length - n) {
                n4 = threadArray.length - n;
            }
            if (n4 > 0) {
                System.arraycopy(this.threads, 0, threadArray, n, n4);
                n += n4;
            }
            if (bl) {
                n2 = this.ngroups;
                if (this.groups != null) {
                    threadGroupArray = new ThreadGroup[n2];
                    System.arraycopy(this.groups, 0, threadGroupArray, 0, n2);
                } else {
                    threadGroupArray = null;
                }
            }
        }
        if (bl) {
            int n5 = 0;
            while (n5 < n2) {
                n = threadGroupArray[n5].enumerate(threadArray, n, true);
                ++n5;
            }
        }
        return n;
    }

    public int activeGroupCount() {
        ThreadGroup[] threadGroupArray;
        int n;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                int n2 = 0;
                Object var5_5 = null;
                return n2;
            }
            n = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n);
            } else {
                threadGroupArray = null;
            }
        }
        int n3 = n;
        int n4 = 0;
        while (n4 < n) {
            n3 += threadGroupArray[n4].activeGroupCount();
            ++n4;
        }
        return n3;
    }

    public int enumerate(ThreadGroup[] threadGroupArray) {
        return this.enumerate(threadGroupArray, 0, true);
    }

    public int enumerate(ThreadGroup[] threadGroupArray, boolean bl) {
        return this.enumerate(threadGroupArray, 0, bl);
    }

    private int enumerate(ThreadGroup[] threadGroupArray, int n, boolean bl) {
        int n2 = 0;
        ThreadGroup[] threadGroupArray2 = null;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                int n3 = 0;
                Object var8_9 = null;
                return n3;
            }
            int n4 = this.ngroups;
            if (n4 > threadGroupArray.length - n) {
                n4 = threadGroupArray.length - n;
            }
            if (n4 > 0) {
                System.arraycopy(this.groups, 0, threadGroupArray, n, n4);
                n += n4;
            }
            if (bl) {
                n2 = this.ngroups;
                if (this.groups != null) {
                    threadGroupArray2 = new ThreadGroup[n2];
                    System.arraycopy(this.groups, 0, threadGroupArray2, 0, n2);
                } else {
                    threadGroupArray2 = null;
                }
            }
        }
        if (bl) {
            int n5 = 0;
            while (n5 < n2) {
                n = threadGroupArray2[n5].enumerate(threadGroupArray, n, true);
                ++n5;
            }
        }
        return n;
    }

    public final void stop() {
        if (this.stopOrSuspend(false)) {
            Thread.currentThread().stop();
        }
    }

    public final void suspend() {
        if (this.stopOrSuspend(true)) {
            Thread.currentThread().suspend();
        }
    }

    private boolean stopOrSuspend(boolean bl) {
        int n;
        boolean bl2 = false;
        Thread thread = Thread.currentThread();
        ThreadGroup[] threadGroupArray = null;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            this.checkAccess();
            int n2 = 0;
            while (n2 < this.nthreads) {
                if (this.threads[n2] == thread) {
                    bl2 = true;
                } else if (bl) {
                    this.threads[n2].suspend();
                } else {
                    this.threads[n2].stop();
                }
                ++n2;
            }
            n = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n);
            }
        }
        int n3 = 0;
        while (n3 < n) {
            bl2 = threadGroupArray[n3].stopOrSuspend(bl) || bl2;
            ++n3;
        }
        return bl2;
    }

    public final void resume() {
        ThreadGroup[] threadGroupArray;
        int n;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            this.checkAccess();
            int n2 = 0;
            while (n2 < this.nthreads) {
                this.threads[n2].resume();
                ++n2;
            }
            n = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n);
            } else {
                threadGroupArray = null;
            }
        }
        int n3 = 0;
        while (n3 < n) {
            threadGroupArray[n3].resume();
            ++n3;
        }
    }

    public final void destroy() {
        ThreadGroup[] threadGroupArray;
        int n;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            this.checkAccess();
            if (this.destroyed || this.nthreads > 0) {
                throw new IllegalThreadStateException();
            }
            n = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n);
            } else {
                threadGroupArray = null;
            }
            if (this.parent != null) {
                this.destroyed = true;
                this.ngroups = 0;
                this.groups = null;
                this.nthreads = 0;
                this.threads = null;
            }
        }
        int n2 = 0;
        while (n2 < n) {
            threadGroupArray[n2].destroy();
            ++n2;
        }
        if (this.parent != null) {
            this.parent.remove(this);
        }
    }

    private final void add(ThreadGroup threadGroup) {
        ThreadGroup threadGroup2 = this;
        synchronized (threadGroup2) {
            if (this.destroyed) {
                throw new IllegalThreadStateException();
            }
            if (this.groups == null) {
                this.groups = new ThreadGroup[4];
            } else if (this.ngroups == this.groups.length) {
                ThreadGroup[] threadGroupArray = new ThreadGroup[this.ngroups * 2];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, this.ngroups);
                this.groups = threadGroupArray;
            }
            this.groups[this.ngroups] = threadGroup;
            ++this.ngroups;
            return;
        }
    }

    private void remove(ThreadGroup threadGroup) {
        ThreadGroup threadGroup2 = this;
        synchronized (threadGroup2) {
            if (this.destroyed) {
                Object var3_3 = null;
                return;
            }
            int n = 0;
            while (n < this.ngroups) {
                if (this.groups[n] == threadGroup) {
                    --this.ngroups;
                    System.arraycopy(this.groups, n + 1, this.groups, n, this.ngroups - n);
                    this.groups[this.ngroups] = null;
                    break;
                }
                ++n;
            }
            if (this.nthreads == 0) {
                this.notifyAll();
            }
            if (this.daemon && this.nthreads == 0 && this.ngroups == 0) {
                this.destroy();
            }
            return;
        }
    }

    void add(Thread thread) {
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                throw new IllegalThreadStateException();
            }
            if (this.threads == null) {
                this.threads = new Thread[4];
            } else if (this.nthreads == this.threads.length) {
                Thread[] threadArray = new Thread[this.nthreads * 2];
                System.arraycopy(this.threads, 0, threadArray, 0, this.nthreads);
                this.threads = threadArray;
            }
            this.threads[this.nthreads] = thread;
            ++this.nthreads;
            return;
        }
    }

    void remove(Thread thread) {
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            if (this.destroyed) {
                Object var3_3 = null;
                return;
            }
            int n = 0;
            while (n < this.nthreads) {
                if (this.threads[n] == thread) {
                    System.arraycopy(this.threads, n + 1, this.threads, n, --this.nthreads - n);
                    this.threads[this.nthreads] = null;
                    break;
                }
                ++n;
            }
            if (this.nthreads == 0) {
                this.notifyAll();
            }
            if (this.daemon && this.nthreads == 0 && this.ngroups == 0) {
                this.destroy();
            }
            return;
        }
    }

    public void list() {
        this.list(System.out, 0);
    }

    void list(PrintStream printStream, int n) {
        ThreadGroup[] threadGroupArray;
        int n2;
        ThreadGroup threadGroup = this;
        synchronized (threadGroup) {
            int n3 = 0;
            while (n3 < n) {
                printStream.print(" ");
                ++n3;
            }
            printStream.println(this);
            n += 4;
            int n4 = 0;
            while (n4 < this.nthreads) {
                int n5 = 0;
                while (n5 < n) {
                    printStream.print(" ");
                    ++n5;
                }
                printStream.println(this.threads[n4]);
                ++n4;
            }
            n2 = this.ngroups;
            if (this.groups != null) {
                threadGroupArray = new ThreadGroup[n2];
                System.arraycopy(this.groups, 0, threadGroupArray, 0, n2);
            } else {
                threadGroupArray = null;
            }
        }
        int n6 = 0;
        while (n6 < n2) {
            threadGroupArray[n6].list(printStream, n);
            ++n6;
        }
    }

    public void uncaughtException(Thread thread, Throwable throwable) {
        if (this.parent != null) {
            this.parent.uncaughtException(thread, throwable);
            return;
        }
        if (!(throwable instanceof ThreadDeath)) {
            throwable.printStackTrace(System.err);
        }
    }

    public boolean allowThreadSuspension(boolean bl) {
        this.vmAllowSuspension = bl;
        if (!bl) {
            VM.unsuspendSomeThreads();
        }
        return true;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[name=" + this.name + ",maxpri=" + this.maxPriority + "]";
    }
}

