/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.ParseException;
import java.text.PatternEntry;
import java.util.Vector;

final class MergeCollation {
    Vector patterns = new Vector();
    PatternEntry lastEntry;
    private byte[] statusArray = new byte[8192];
    private PatternEntry saveEntry;
    private int lastIndex = -1;
    private Vector extList;
    private final byte BITARRAYMASK = 1;
    private final int BYTEPOWER = 3;
    private final int BYTEMASK = 7;

    public MergeCollation(String string) throws ParseException {
        int n = 0;
        while (n < this.statusArray.length) {
            this.statusArray[n] = 0;
            ++n;
        }
        this.setPattern(string);
    }

    public String getPattern() {
        return this.getPattern(true);
    }

    public String getPattern(boolean bl) {
        PatternEntry patternEntry;
        StringBuffer stringBuffer = new StringBuffer();
        PatternEntry patternEntry2 = null;
        int n = 0;
        while (n < this.patterns.size()) {
            patternEntry = (PatternEntry)this.patterns.elementAt(n);
            if (patternEntry.extension.length() != 0) {
                if (this.extList == null) {
                    this.extList = new Vector();
                }
                this.extList.insertElementAt(patternEntry, this.extList.size());
            } else {
                if (this.extList != null) {
                    PatternEntry patternEntry3 = this.findLastWithNoExtension(n - 1);
                    int n2 = this.extList.size() - 1;
                    while (n2 >= 0) {
                        patternEntry2 = (PatternEntry)this.extList.elementAt(n2);
                        patternEntry2.addToBuffer(stringBuffer, false, bl, patternEntry3);
                        --n2;
                    }
                    this.extList = null;
                }
                patternEntry.addToBuffer(stringBuffer, false, bl, null);
            }
            ++n;
        }
        if (this.extList != null) {
            patternEntry = this.findLastWithNoExtension(n - 1);
            int n3 = this.extList.size() - 1;
            while (n3 >= 0) {
                patternEntry2 = (PatternEntry)this.extList.elementAt(n3);
                patternEntry2.addToBuffer(stringBuffer, false, bl, patternEntry);
                --n3;
            }
            this.extList = null;
        }
        return stringBuffer.toString();
    }

    public String emitPattern() {
        return this.emitPattern(true);
    }

    public String emitPattern(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.patterns.size()) {
            PatternEntry patternEntry = (PatternEntry)this.patterns.elementAt(n);
            if (patternEntry != null) {
                patternEntry.addToBuffer(stringBuffer, true, bl, null);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void setPattern(String string) throws ParseException {
        this.patterns.removeAllElements();
        this.addPattern(string);
    }

    public void addPattern(String string) throws ParseException {
        PatternEntry patternEntry;
        if (string == null) {
            return;
        }
        int n = 0;
        while ((n = (patternEntry = new PatternEntry()).getNextEntry(string, n)) >= 0) {
            this.fixEntry(patternEntry);
        }
    }

    public int getCount() {
        return this.patterns.size();
    }

    public PatternEntry getItemAt(int n) {
        return (PatternEntry)this.patterns.elementAt(n);
    }

    private final PatternEntry findLastWithNoExtension(int n) {
        --n;
        while (n >= 0) {
            PatternEntry patternEntry = (PatternEntry)this.patterns.elementAt(n);
            if (patternEntry.extension.length() == 0) {
                return patternEntry;
            }
            --n;
        }
        return null;
    }

    private final void fixEntry(PatternEntry patternEntry) throws ParseException {
        boolean bl = true;
        if (patternEntry.strength != -2) {
            int n = -1;
            boolean bl2 = false;
            byte by = 0;
            byte by2 = 0;
            if (patternEntry.chars.length() == 1) {
                n = patternEntry.chars.charAt(0) >> 3;
                by = this.statusArray[n];
                by2 = (byte)(1 << (patternEntry.chars.charAt(0) & 7));
                if (by != 0 && (by & by2) != 0) {
                    n = -1;
                    int n2 = 0;
                    n2 = this.patterns.size() - 1;
                    while (n2 >= 0) {
                        PatternEntry patternEntry2 = (PatternEntry)this.patterns.elementAt(n2);
                        if (patternEntry2 != null && patternEntry2.chars.equals(patternEntry.chars)) {
                            n = n2;
                            break;
                        }
                        --n2;
                    }
                    if (n != -1) {
                        this.patterns.removeElementAt(n);
                    } else {
                        System.out.println("FAILED SEARCH FOR value " + patternEntry.chars);
                    }
                    this.lastIndex = this.patterns.indexOf(this.lastEntry);
                } else {
                    bl2 = true;
                }
            } else {
                n = this.patterns.indexOf(patternEntry);
                if (n != -1) {
                    this.patterns.removeElementAt(n);
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            this.lastIndex = this.findLastEntry(this.lastEntry, stringBuffer);
            if (bl2) {
                this.statusArray[n] = (byte)(by | by2);
            }
            if (stringBuffer.length() != 0) {
                patternEntry.extension = String.valueOf(stringBuffer) + patternEntry.extension;
                if (this.lastIndex != this.patterns.size()) {
                    this.lastEntry = this.saveEntry;
                    bl = false;
                }
            }
            if (this.lastIndex == this.patterns.size()) {
                this.patterns.addElement(patternEntry);
                this.saveEntry = patternEntry;
            } else {
                this.patterns.insertElementAt(patternEntry, this.lastIndex);
                this.lastEntry = this.saveEntry;
            }
        }
        if (bl) {
            this.lastEntry = patternEntry;
            return;
        }
        this.lastIndex = this.patterns.indexOf(this.lastEntry);
    }

    private final int findLastEntry(PatternEntry patternEntry, StringBuffer stringBuffer) throws ParseException {
        if (patternEntry == null) {
            return 0;
        }
        if (patternEntry.strength != -2) {
            int n = -1;
            if (patternEntry.chars.length() == 1) {
                int n2 = patternEntry.chars.charAt(0) >> 3;
                if ((this.statusArray[n2] & 1 << (patternEntry.chars.charAt(0) & 7)) != 0) {
                    n = this.lastIndex;
                }
            } else {
                n = this.patterns.indexOf(patternEntry);
            }
            if (n == -1) {
                throw new ParseException("couldn't find last entry: " + patternEntry, n);
            }
            return n + 1;
        }
        int n = this.patterns.size() - 1;
        while (n >= 0) {
            PatternEntry patternEntry2 = (PatternEntry)this.patterns.elementAt(n);
            if (patternEntry2.chars.regionMatches(0, patternEntry.chars, 0, patternEntry2.chars.length())) {
                stringBuffer.append(patternEntry.chars.substring(patternEntry2.chars.length(), patternEntry.chars.length()));
                break;
            }
            --n;
        }
        if (n == -1) {
            throw new ParseException("couldn't find: " + patternEntry, n);
        }
        return n + 1;
    }
}

