/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MenuBar;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.peer.FramePeer;
import java.util.Vector;
import sun.awt.image.ImageRepresentation;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MMenuBarPeer;
import sun.awt.motif.MPanelPeer;
import sun.awt.motif.MToolkit;
import sun.awt.motif.X11Image;

class MFramePeer
extends MPanelPeer
implements FramePeer {
    Insets insets = new Insets(0, 0, 0, 0);
    static Vector allFrames = new Vector();
    static final int CROSSHAIR_INSET = 5;
    static final int BUTTON_Y = 6;
    static final int BUTTON_W = 17;
    static final int BUTTON_H = 17;
    static final int SYS_MENU_X = 6;
    static final int SYS_MENU_CONTAINED_X = 11;
    static final int SYS_MENU_CONTAINED_Y = 13;
    static final int SYS_MENU_CONTAINED_W = 8;
    static final int SYS_MENU_CONTAINED_H = 3;
    static final int MAXIMIZE_X_DIFF = 22;
    static final int MAXIMIZE_CONTAINED_X_DIFF = 17;
    static final int MAXIMIZE_CONTAINED_Y = 11;
    static final int MAXIMIZE_CONTAINED_W = 8;
    static final int MAXIMIZE_CONTAINED_H = 8;
    static final int MINIMIZE_X_DIFF = 39;
    static final int MINIMIZE_CONTAINED_X_DIFF = 32;
    static final int MINIMIZE_CONTAINED_Y = 13;
    static final int MINIMIZE_CONTAINED_W = 3;
    static final int MINIMIZE_CONTAINED_H = 3;
    static final int TITLE_X = 23;
    static final int TITLE_W_DIFF = 60;
    static final int TITLE_MID_Y = 14;
    static final int MENUBAR_X = 6;
    static final int MENUBAR_Y = 23;
    static final int HORIZ_RESIZE_INSET = 22;
    static final int VERT_RESIZE_INSET = 22;

    native void create(MComponentPeer var1, Object var2);

    native void pSetTitle(String var1);

    native void pShow();

    native void pHide();

    native void pReshape(int var1, int var2, int var3, int var4);

    native void pDispose();

    native Dimension pGetIconImageSize(int var1, int var2);

    native void pSetIconImage(ImageRepresentation var1);

    public native void setResizable(boolean var1);

    native void addTextComponent();

    MFramePeer(Frame frame) {
        Image image;
        Color color;
        Font font;
        this.init(frame, new Insets(Integer.getInteger("awt.frame.topInset", 25), Integer.getInteger("awt.frame.leftInset", 5), Integer.getInteger("awt.frame.bottomInset", 5), Integer.getInteger("awt.frame.rightInset", 5)));
        allFrames.addElement(this);
        if (frame.getTitle() != null) {
            this.pSetTitle(frame.getTitle());
        }
        if ((font = frame.getFont()) == null) {
            font = new Font("Dialog", 0, 12);
            frame.setFont(font);
            this.setFont(font);
        }
        if ((color = frame.getBackground()) == null) {
            frame.setBackground(Color.lightGray);
            this.setBackground(Color.lightGray);
        }
        if ((color = frame.getForeground()) == null) {
            frame.setForeground(Color.black);
            this.setForeground(Color.black);
        }
        if ((image = frame.getIconImage()) != null) {
            this.setIconImage(image);
        }
        this.setResizable(frame.isResizable());
    }

    public void setTitle(String string) {
        this.pSetTitle(string);
    }

    public void dispose() {
        allFrames.removeElement(this);
        super.dispose();
    }

    public void setIconImage(Image image) {
        ImageRepresentation imageRepresentation = ((X11Image)image).getImageRep();
        imageRepresentation.reconstruct(32);
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        Dimension dimension = this.pGetIconImageSize(n, n2);
        if (dimension != null && (n != dimension.width || n2 != dimension.height)) {
            Image image2 = image.getScaledInstance(dimension.width, dimension.height, 1);
            imageRepresentation = ((X11Image)image2).getImageRep();
            imageRepresentation.reconstruct(32);
        }
        this.pSetIconImage(imageRepresentation);
    }

    public void setMenuBar(MenuBar menuBar) {
        MMenuBarPeer mMenuBarPeer = (MMenuBarPeer)MToolkit.targetToPeer(menuBar);
        this.pSetMenuBar(mMenuBarPeer);
        Rectangle rectangle = this.target.bounds();
        this.pReshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.target.invalidate();
        if (this.target.isVisible()) {
            this.target.validate();
        }
    }

    native void pSetMenuBar(MMenuBarPeer var1);

    public void handleActivate() {
        this.postEvent(new WindowEvent((Window)this.target, 205));
    }

    public void handleDeactivate() {
        this.postEvent(new WindowEvent((Window)this.target, 206));
    }

    public void handleQuit() {
        this.postEvent(new WindowEvent((Window)this.target, 201));
    }

    public void handleIconify() {
        this.postEvent(new WindowEvent((Window)this.target, 203));
    }

    public void handleDeiconify() {
        this.postEvent(new WindowEvent((Window)this.target, 204));
    }

    public void toFront() {
        this.pShow();
    }

    public native void toBack();

    public void handleMoved(int n, int n2) {
        this.postEvent(new ComponentEvent(this.target, 100));
    }

    public void handleResize(int n, int n2) {
        this.postEvent(new ComponentEvent(this.target, 101));
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void print(Graphics graphics) {
        MMenuBarPeer mMenuBarPeer;
        MenuBar menuBar;
        super.print(graphics);
        Frame frame = (Frame)this.target;
        frame.getInsets();
        Dimension dimension = frame.getSize();
        SystemColor systemColor = SystemColor.inactiveCaptionBorder;
        SystemColor systemColor2 = SystemColor.inactiveCaption;
        SystemColor systemColor3 = SystemColor.inactiveCaptionText;
        Color color = systemColor.brighter();
        Color color2 = systemColor.darker();
        graphics.setColor(systemColor);
        graphics.drawLine(0, 0, dimension.width, 0);
        graphics.setColor(color);
        graphics.drawLine(0, 1, dimension.width - 1, 1);
        graphics.setColor(systemColor2);
        graphics.fillRect(2, 2, dimension.width - 3, 3);
        graphics.setColor(systemColor);
        graphics.drawLine(0, 0, 0, dimension.height);
        graphics.setColor(color);
        graphics.drawLine(1, 0, 1, dimension.height - 1);
        graphics.setColor(systemColor2);
        graphics.fillRect(2, 2, 3, dimension.height - 3);
        graphics.setColor(color);
        graphics.drawLine(6, dimension.height - 5, dimension.width - 5, dimension.height - 5);
        graphics.drawLine(dimension.width - 5, 6, dimension.width - 5, dimension.height - 5);
        graphics.setColor(color2);
        graphics.drawLine(1, dimension.height, dimension.width, dimension.height);
        graphics.setColor(systemColor);
        graphics.drawLine(2, dimension.height - 1, dimension.width, dimension.height - 1);
        graphics.setColor(systemColor2);
        graphics.fillRect(2, dimension.height - 4, dimension.width - 3, 3);
        graphics.setColor(color2);
        graphics.drawLine(dimension.width, 1, dimension.width, dimension.height);
        graphics.setColor(systemColor);
        graphics.drawLine(dimension.width - 1, 2, dimension.width - 1, dimension.height);
        graphics.setColor(systemColor2);
        graphics.fillRect(dimension.width - 4, 2, 3, dimension.height - 3);
        graphics.setColor(color2);
        graphics.drawLine(5, 5, dimension.width - 5, 5);
        graphics.drawLine(5, 5, 5, dimension.height - 5);
        graphics.setColor(systemColor2);
        graphics.fill3DRect(6, 6, 17, 17, true);
        graphics.fill3DRect(11, 13, 8, 3, true);
        graphics.fill3DRect(23, 6, dimension.width - 60, 17, true);
        graphics.fill3DRect(dimension.width - 39, 6, 17, 17, true);
        graphics.fill3DRect(dimension.width - 32, 13, 3, 3, true);
        graphics.fill3DRect(dimension.width - 22, 6, 17, 17, true);
        graphics.fill3DRect(dimension.width - 17, 11, 8, 8, true);
        graphics.setColor(systemColor3);
        Font font = new Font("SansSerif", 0, 10);
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = frame.getTitle();
        graphics.drawString(string, (46 + dimension.width - 60) / 2 - fontMetrics.stringWidth(string) / 2, 14 + fontMetrics.getMaxDescent());
        if (frame.isResizable()) {
            graphics.setColor(color2);
            graphics.drawLine(2, 22, 5, 22);
            graphics.drawLine(22, 2, 22, 5);
            graphics.drawLine(dimension.width - 5 + 1, 22, dimension.width, 22);
            graphics.drawLine(dimension.width - 22 - 1, 2, dimension.width - 22 - 1, 6);
            graphics.drawLine(2, dimension.height - 22 - 1, 5, dimension.height - 22 - 1);
            graphics.drawLine(22, dimension.height - 5 + 1, 22, dimension.height);
            graphics.drawLine(dimension.width - 5 + 1, dimension.height - 22 - 1, dimension.width, dimension.height - 22 - 1);
            graphics.drawLine(dimension.width - 22 - 1, dimension.height - 5 + 1, dimension.width - 22 - 1, dimension.height);
            graphics.setColor(color);
            graphics.drawLine(2, 23, 5, 23);
            graphics.drawLine(23, 2, 23, 5);
            graphics.drawLine(dimension.width - 5 + 1, 23, dimension.width - 1, 23);
            graphics.drawLine(dimension.width - 22, 2, dimension.width - 22, 5);
            graphics.drawLine(2, dimension.height - 22, 5, dimension.height - 22);
            graphics.drawLine(23, dimension.height - 5 + 1, 23, dimension.height - 1);
            graphics.drawLine(dimension.width - 5 + 1, dimension.height - 22, dimension.width - 1, dimension.height - 22);
            graphics.drawLine(dimension.width - 22, dimension.height - 5 + 1, dimension.width - 22, dimension.height - 1);
        }
        if ((menuBar = frame.getMenuBar()) != null && (mMenuBarPeer = (MMenuBarPeer)MToolkit.targetToPeer(menuBar)) != null) {
            this.insets();
            Graphics graphics2 = graphics.create();
            try {
                graphics2.translate(6, 23);
                mMenuBarPeer.print(graphics2);
                return;
            }
            finally {
                Object var16_15 = null;
                graphics2.dispose();
            }
        }
    }

    public Insets insets() {
        return this.getInsets();
    }
}

