/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.KeyEvent;
import sun.awt.AWTFinalizeable;
import sun.awt.AWTFinalizer;
import sun.awt.im.InputMethodAdapter;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MToolkit;

public class X11InputMethod
extends InputMethodAdapter
implements AWTFinalizeable {
    private static boolean isXIMOpened;
    private Container clientComponentWindow;
    private boolean createXICFailed = false;
    private transient int pData;
    AWTFinalizeable finalnext;

    public X11InputMethod() throws AWTException {
        if (!this.initXIM()) {
            throw new AWTException("cannot open XIM");
        }
    }

    private synchronized boolean initXIM() {
        if (!isXIMOpened) {
            isXIMOpened = this.openXIM();
        }
        return isXIMOpened;
    }

    public void dispatchEvent(AWTEvent aWTEvent) {
    }

    public synchronized void activate() {
        MComponentPeer mComponentPeer;
        if (this.createXICFailed) {
            return;
        }
        this.clientComponentWindow = this.getClientComponentWindow();
        if (this.clientComponentWindow == null) {
            return;
        }
        if (this.pData == 0) {
            mComponentPeer = this.getPeer(this.clientComponentWindow);
            if (mComponentPeer == null) {
                return;
            }
            this.pData = this.initializeXICNative(mComponentPeer);
            if (this.pData == 0) {
                this.createXICFailed = true;
                return;
            }
        }
        mComponentPeer = this.getPeer(this.getFocussedComponent());
        this.setXICFocus(mComponentPeer, true, this.pData);
    }

    public synchronized void deactivate() {
        if (this.pData != 0) {
            this.setXICFocus(this.getPeer(this.getFocussedComponent()), false, this.pData);
        }
    }

    Component getFocussedComponent() {
        return this.getClientComponent();
    }

    private Window getClientComponentWindow() {
        Component component = this.getClientComponent();
        Container container = component instanceof Container ? (Container)component : component.getParent();
        while (container != null && !(container instanceof Window)) {
            container = container.getParent();
        }
        return (Window)container;
    }

    private MComponentPeer getPeer(Component component) {
        MComponentPeer mComponentPeer = (MComponentPeer)MToolkit.targetToPeer(component);
        if (mComponentPeer != null) {
            return mComponentPeer;
        }
        Container container = MToolkit.getNativeContainer(component);
        mComponentPeer = (MComponentPeer)MToolkit.targetToPeer(container);
        return mComponentPeer;
    }

    void dispatchCommittedText(String string, long l) {
        int n = 0;
        while (n < string.length()) {
            KeyEvent keyEvent = new KeyEvent(this.getClientComponent(), 400, l, 0, 0, string.charAt(n));
            MToolkit.postEvent(keyEvent);
            ++n;
        }
    }

    public void dispose() {
        if (this.pData != 0) {
            if (this.clientComponentWindow != null) {
                this.getPeer(this.clientComponentWindow);
            }
            this.disposeXIC(this.pData);
            this.pData = 0;
        }
    }

    public void finalize() {
        AWTFinalizer.addFinalizeable(this);
    }

    public void doFinalization() {
        this.dispose();
    }

    public void setNextFinalizeable(AWTFinalizeable aWTFinalizeable) {
        this.finalnext = aWTFinalizeable;
    }

    public AWTFinalizeable getNextFinalizeable() {
        return this.finalnext;
    }

    public void endComposition() {
        if (this.pData == 0) {
            return;
        }
        String string = this.resetXIC(this.pData);
        if (string != null && string.length() > 0) {
            this.dispatchCommittedText(string, System.currentTimeMillis());
        }
    }

    private native boolean openXIM();

    private native int initializeXICNative(MComponentPeer var1);

    private native void setXICFocus(MComponentPeer var1, boolean var2, int var3);

    private native String resetXIC(int var1);

    private native void disposeXIC(int var1);

    private native void closeXIM();
}

