/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.rmi.MarshalException;
import java.rmi.RemoteException;
import java.rmi.server.LogStream;
import java.rmi.server.Operation;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteRef;
import sun.rmi.server.RemoteProxy;
import sun.rmi.transport.Connection;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.StreamRemoteCall;

public class UnicastRef
implements RemoteRef,
Serializable {
    protected LiveRef ref;

    public UnicastRef() {
    }

    public UnicastRef(LiveRef liveRef) {
        this.ref = liveRef;
    }

    public RemoteCall newCall(RemoteObject remoteObject, Operation[] operationArray, int n, long l) throws RemoteException {
        if (RemoteProxy.logLevel >= 10) {
            LogStream.log("transport").println("UnicastRef.newCall: get connection");
        }
        Connection connection = this.ref.getChannel().newConnection();
        try {
            if (RemoteProxy.logLevel >= 20) {
                LogStream.log("transport").println("UnicastRef.newCall: create call");
            }
            StreamRemoteCall streamRemoteCall = new StreamRemoteCall(connection, this.ref.getObjID(), n, l);
            try {
                this.marshalCustomCallData(streamRemoteCall.getOutputStream());
            }
            catch (IOException iOException) {
                throw new MarshalException("error marshaling custom call data");
            }
            return streamRemoteCall;
        }
        catch (RemoteException remoteException) {
            this.ref.getChannel().free(connection, false);
            throw remoteException;
        }
    }

    protected void marshalCustomCallData(ObjectOutput objectOutput) throws IOException {
    }

    public void invoke(RemoteCall remoteCall) throws Exception {
        try {
            if (RemoteProxy.logLevel >= 20) {
                LogStream.log("transport").println("UnicastRef.invoke: execute call");
            }
            remoteCall.executeCall();
            return;
        }
        catch (RemoteException remoteException) {
            if (RemoteProxy.logLevel >= 10) {
                LogStream logStream;
                LogStream logStream2 = logStream = LogStream.log("transport");
                synchronized (logStream2) {
                    logStream.print("UnicastRef.invoke: exception: ");
                    remoteException.printStackTrace(logStream);
                }
            }
            this.free(remoteCall, false);
            throw remoteException;
        }
        catch (Error error) {
            if (RemoteProxy.logLevel >= 10) {
                LogStream logStream;
                LogStream logStream3 = logStream = LogStream.log("transport");
                synchronized (logStream3) {
                    logStream.print("UnicastRef.invoke: error: ");
                    error.printStackTrace(logStream);
                }
            }
            this.free(remoteCall, false);
            throw error;
        }
        catch (RuntimeException runtimeException) {
            if (RemoteProxy.logLevel >= 10) {
                LogStream logStream;
                LogStream logStream4 = logStream = LogStream.log("transport");
                synchronized (logStream4) {
                    logStream.print("UnicastRef.invoke: exception: ");
                    runtimeException.printStackTrace(logStream);
                }
            }
            this.free(remoteCall, false);
            throw runtimeException;
        }
        catch (Exception exception) {
            if (RemoteProxy.logLevel >= 10) {
                LogStream logStream;
                LogStream logStream5 = logStream = LogStream.log("transport");
                synchronized (logStream5) {
                    logStream.print("UnicastRef.invoke: exception: ");
                    exception.printStackTrace(logStream);
                }
            }
            this.free(remoteCall, true);
            throw exception;
        }
    }

    private void free(RemoteCall remoteCall, boolean bl) throws RemoteException {
        Connection connection = ((StreamRemoteCall)remoteCall).getConnection();
        this.ref.getChannel().free(connection, bl);
    }

    public void done(RemoteCall remoteCall) throws RemoteException {
        if (RemoteProxy.logLevel >= 10) {
            LogStream.log("transport").println("UnicastRef.done: free connection (reuse =  true)");
        }
        this.free(remoteCall, true);
        try {
            remoteCall.done();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public String getRefClass(ObjectOutput objectOutput) {
        return "UnicastRef";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.ref.writeExternal(objectOutput);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.ref = new LiveRef();
        this.ref.readExternal(objectInput);
    }

    public String remoteToString() {
        return "RemoteStub [ref: " + this.ref + "]";
    }

    public int remoteHashCode() {
        return this.ref.hashCode();
    }

    public boolean remoteEquals(RemoteRef remoteRef) {
        if (remoteRef instanceof UnicastRef) {
            return this.ref.remoteEquals(((UnicastRef)remoteRef).ref);
        }
        return false;
    }
}

