/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.MenuComponent;
import java.awt.peer.ActiveEvent;

class EventDispatchThread
extends Thread {
    private EventQueue theQueue;
    private boolean doDispatch = true;

    EventDispatchThread(String string, EventQueue eventQueue) {
        super(string);
        this.theQueue = eventQueue;
    }

    void stopDispatchingNoJoin() {
        this.doDispatch = false;
        this.theQueue.postEvent(new EmptyEvent());
    }

    public void stopDispatching() {
        this.doDispatch = false;
        this.theQueue.postEvent(new EmptyEvent());
        if (Thread.currentThread() != this) {
            try {
                this.join();
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    public void run() {
        while (this.doDispatch) {
            try {
                AWTEvent aWTEvent = this.theQueue.getNextEvent();
                Object object = aWTEvent.getSource();
                if (aWTEvent instanceof ActiveEvent) {
                    ((ActiveEvent)((Object)aWTEvent)).dispatch();
                    continue;
                }
                if (object instanceof Component) {
                    ((Component)object).dispatchEvent(aWTEvent);
                    continue;
                }
                if (!(object instanceof MenuComponent)) continue;
                ((MenuComponent)object).dispatchEvent(aWTEvent);
            }
            catch (ThreadDeath threadDeath) {
                return;
            }
            catch (Throwable throwable) {
                System.err.println("Exception occurred during event dispatching:");
                throwable.printStackTrace();
            }
        }
    }

    class EmptyEvent
    extends AWTEvent
    implements ActiveEvent {
        public EmptyEvent() {
            super(EventDispatchThread.this, 0);
            EventDispatchThread.this = EventDispatchThread.this;
        }

        public void dispatch() {
        }
    }
}

