/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class PrintWriter
extends Writer {
    private Writer out;
    private boolean autoFlush = false;
    private boolean trouble = false;
    private String lineSeparator;

    public PrintWriter(Writer writer) {
        this(writer, false);
    }

    public PrintWriter(Writer writer, boolean bl) {
        super(writer);
        this.out = writer;
        this.autoFlush = bl;
        this.lineSeparator = System.getProperty("line.separator");
    }

    public PrintWriter(OutputStream outputStream) {
        this(outputStream, false);
    }

    public PrintWriter(OutputStream outputStream, boolean bl) {
        this(new BufferedWriter(new OutputStreamWriter(outputStream)), bl);
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    public void flush() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.out == null) {
                    throw new IOException("Stream closed");
                }
                this.out.flush();
                return;
            }
        }
        catch (IOException iOException) {
            this.trouble = true;
            return;
        }
    }

    public void close() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.out == null) {
                    Object var2_2 = null;
                    return;
                }
                this.out.close();
                this.out = null;
                return;
            }
        }
        catch (IOException iOException) {
            this.trouble = true;
            return;
        }
    }

    public boolean checkError() {
        if (this.out != null) {
            this.flush();
        }
        return this.trouble;
    }

    protected void setError() {
        this.trouble = true;
    }

    public void write(int n) {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.out == null) {
                    throw new IOException("Stream closed");
                }
                this.out.write(n);
                return;
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (IOException iOException) {
            this.trouble = true;
            return;
        }
    }

    public void write(char[] cArray, int n, int n2) {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.out == null) {
                    throw new IOException("Stream closed");
                }
                this.out.write(cArray, n, n2);
                return;
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (IOException iOException) {
            this.trouble = true;
            return;
        }
    }

    public void write(char[] cArray) {
        this.write(cArray, 0, cArray.length);
    }

    public void write(String string, int n, int n2) {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.out == null) {
                    throw new IOException("Stream closed");
                }
                this.out.write(string, n, n2);
                return;
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (IOException iOException) {
            this.trouble = true;
            return;
        }
    }

    public void write(String string) {
        this.write(string, 0, string.length());
    }

    private void newLine() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.out == null) {
                    throw new IOException("Stream closed");
                }
                this.out.write(this.lineSeparator);
                if (this.autoFlush) {
                    this.out.flush();
                }
                return;
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (IOException iOException) {
            this.trouble = true;
            return;
        }
    }

    public void print(boolean bl) {
        this.write(bl ? "true" : "false");
    }

    public void print(char c) {
        this.write(String.valueOf(c));
    }

    public void print(int n) {
        this.write(Integer.toString(n, 10));
    }

    public void print(long l) {
        this.write(Long.toString(l, 10));
    }

    public void print(float f) {
        this.write(String.valueOf(f));
    }

    public void print(double d) {
        this.write(String.valueOf(d));
    }

    public void print(char[] cArray) {
        this.write(cArray);
    }

    public void print(String string) {
        if (string == null) {
            string = "null";
        }
        this.write(string);
    }

    public void print(Object object) {
        this.write(object == null ? "null" : object.toString());
    }

    public void println() {
        Object object = this.lock;
        synchronized (object) {
            this.newLine();
            return;
        }
    }

    public void println(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.print(bl);
            this.newLine();
            return;
        }
    }

    public void println(char c) {
        Object object = this.lock;
        synchronized (object) {
            this.print(c);
            this.newLine();
            return;
        }
    }

    public void println(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.print(n);
            this.newLine();
            return;
        }
    }

    public void println(long l) {
        Object object = this.lock;
        synchronized (object) {
            this.print(l);
            this.newLine();
            return;
        }
    }

    public void println(float f) {
        Object object = this.lock;
        synchronized (object) {
            this.print(f);
            this.newLine();
            return;
        }
    }

    public void println(double d) {
        Object object = this.lock;
        synchronized (object) {
            this.print(d);
            this.newLine();
            return;
        }
    }

    public void println(char[] cArray) {
        Object object = this.lock;
        synchronized (object) {
            this.print(cArray);
            this.newLine();
            return;
        }
    }

    public void println(String string) {
        Object object = this.lock;
        synchronized (object) {
            this.print(string);
            this.newLine();
            return;
        }
    }

    public void println(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            this.print(object);
            this.newLine();
            return;
        }
    }
}

